--[[FMPM package metadata:
info = "Spy Camera"
location = "/usr/bin/camera.lua"
]]


local component = require "component"
local term = require "term"
local shell = require "shell"
local event = require "event"
local os = require "os"
local keyboard = require "keyboard"

local gpu = component.gpu
local tape = component.tape_drive
local yp = 1
term.setCursor(1, 1)
term.clear()

local posx, posy = 0, 0
local fovx, fovy = 1.2, 0.8
local size = 0.5

local width, height = gpu.maxResolution()
width, height = width * size, height * size
gpu.setResolution(width, height)

local dists = {}
local lastPlayed = 0
local max = 0
local newmax = 8
local cameras = {}
local camid = 0
for address in component.list("camera") do
    table.insert(cameras, component.proxy(address))
end
local camera = cameras[1]

local function time()
    return os.time() * 1000/60/60 * 20
end

gpu.setForeground(255 * 256 * 256)

while true do
    ::start::
    local xn, yn, zn = 0, 0, 0;
    max = newmax
    newmax = 0
    
    for yn = 1, height do
        local y = posy + (yn / height - 0.5) * fovy
        term.setCursor(1,yn)
        for xn = 1, width do
            local x = posx + (xn / width - 0.5) * fovx
            local zn = (yn - 1) * width + xn
            local d = camera.distance(-x, -y)
            
            if d > newmax then
                newmax = d
            end
            
            if dists[zn] == nil then
                dists[zn] = d
            end
            
            local col = math.max(math.floor((1 - d / max) * 255), 0)
            gpu.setBackground(col * 256 * 256 + col * 256 + col)
            
            if dists[zn] ~= d then
                gpu.setForeground(255 * 256 * 256)
                term.write("X")
                if time() > lastPlayed + 60 * 10 then
                    lastPlayed = time()
                    --tape.seek(-tape.getSize())
                    --tape.play()
                end
            else
                local d = camera.distance(-x, -(posy + ((yn + 0.5) / height - 0.5) * fovy))
                local col = math.max(math.floor((1 - d / max) * 255), 0)
                gpu.setForeground(col * 256 * 256 + col * 256 + col)
                
                term.write("▄")
            end
            
            dists[zn] = d
        end
        
        while true do
            gpu.setBackground(0)
            gpu.setForeground(255 * 256 * 256 + 255 * 256 + 255)
            local event, _, char, code = event.pull(0)
            if event == "interrupted" then
                return
            elseif event == "key_down" then
                local btn = keyboard.keys[code]
                if btn == "numpadadd" then
                    size = math.min(size * 1.2, 1)
                    width, height = gpu.maxResolution()
                    width, height = width * size, height * size
                    gpu.setResolution(width, height)
                    dists = {}
                    goto start
                elseif btn == "numpadsub" then
                    size = size / 1.2
                    width, height = gpu.maxResolution()
                    width, height = width * size, height * size
                    gpu.setResolution(width, height)
                    dists = {}
                    goto start
                elseif btn == "numpad1" then
                    camid = (camid + 1) % #cameras
                    camera = cameras[camid + 1]
                    dists = {}
                    posx = 0
                    posy = 0
                elseif btn == "numpad3" then
                    camid = (camid - 1) % #cameras
                    camera = cameras[camid + 1]
                    dists = {}
                    posx = 0
                    posy = 0
                elseif btn == "numpad4" then
                    posx = posx - 0.1
                    dists = {}
                elseif btn == "numpad6" then
                    posx = posx + 0.1
                    dists = {}
                elseif btn == "numpad8" then
                    posy = posy - 0.1
                    dists = {}
                elseif btn == "numpad5" then
                    posy = posy + 0.1
                    dists = {}
                else
                    
                end
            elseif event == nil then
                break
            end
        end
    end
end
