--[[FMPM package metadata:
info = "Update server for routers."
location = "/etc/rc.d/router-update.lua"
]]

local component = require "component"
local event = require "event"
local serialization = require "serialization"

local function onMessage(_, localAddress, remoteAddress, port, _, data)
    data = serialization.unserialize(data)
    if data == nil or data.type == nil or data.type ~= "request-router-firmware" then return end
    
    file = io.open("/etc/router-firmware.lua")
    content = file:read("*a")
    
    component.modem.send(remoteAddress, 65535, serialization.serialize({type="response-router-firmware"}), content)
end

function push()
    component.modem.broadcast(65535, serialization.serialize{type="update"})
end

function start()
    component.modem.open(65535)
    event.listen("modem_message", onMessage)
end

function stop()
    component.modem.close(65535)
    event.ignore("modem_message", onMessage)
end
