--[[FMPM package metadata:
info = "Default router bootloader"
location = "/etc/router-bootloader.lua"
]]

_G.serialize = function(v) -- Fast n' dirty
    local t = type(v)
    if t == "nil" then
        return "nil"
    elseif t == "boolean" then
        return v and "true" or "false"
    elseif t == "number" then
        if v ~= v then
            return "0/0"
        elseif v == math.huge then
            return "math.huge"
        elseif v == -math.huge then
            return "-math.huge"
        else
            return tostring(v)
        end
    elseif t == "string" then
        return string.format("%q", v):gsub("\\\n","\\n")
    elseif t == "table" then
        local r = "{"
        for k, v in pairs(v) do
            r = r .. "[" .. serialize(k) .. "]"
            r = r .. "=" .. serialize(v) .. ","
        end
        r = r .. "}"
        return r
    else
        error("unsupported type: " .. t)
    end
end

_G.unserialize = function(data) -- Default OpenOS implementation
    checkArg(1, data, "string")
    local result, reason = load("return " .. data, "=data", _, {math={huge=math.huge}})
    if not result then
        return nil, reason
    end
    local ok, output = pcall(result)
    if not ok then
        return nil, output
    end
    return output
end

for address, componentType in component.list() do
    if componentType == "modem" then
        _G.modem = component.proxy(address)
    end
end

if modem == nil then
    error("No modem found.")
end

modem.open(65535)
modem.broadcast(65535, serialize{type="request-router-firmware"})

local timeout = computer.uptime() + 3

while computer.uptime() < timeout do
    local sigtype, localAddress, remoteAddress, port, distance, ipheaders, payload = computer.pullSignal(timeout - computer.uptime())
    _G.payload = payload
    if sigtype == "modem_message" then
        ipheaders = unserialize(ipheaders)
        if type(ipheaders) == "table" and ipheaders.type == "response-router-firmware" then
            load(payload, "Firmware: ")()
        end
    end
end

computer.beep(2000)
computer.beep(1500)
computer.beep(2000)
computer.beep(1500)
computer.beep(2000)
computer.beep(1500, 10)

computer.shutdown(true)
