/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabricators_of_create.porting_lib;

import io.github.fabricators_of_create.porting_lib.entity.ExtraSpawnDataEntity;
import io.github.fabricators_of_create.porting_lib.entity.MultiPartEntity;
import io.github.fabricators_of_create.porting_lib.entity.PartEntity;
import io.github.fabricators_of_create.porting_lib.event.client.ModelsBakedCallback;
import io.github.fabricators_of_create.porting_lib.transfer.cache.ClientBlockApiCache;
import io.github.fabricators_of_create.porting_lib.util.FluidTextUtil;
import io.github.fabricators_of_create.porting_lib.util.FluidVariantFluidAttributesHandler;
import io.github.fabricators_of_create.porting_lib.util.NetworkUtil;
import io.github.fabricators_of_create.porting_lib.util.client.ClientHooks;
import io.netty.buffer.Unpooled;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientEntityEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerType;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributeHandler;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributes;
import net.minecraft.class_1703;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3264;
import net.minecraft.class_3611;
import net.minecraft.class_3917;
import net.minecraft.class_3929;
import net.minecraft.class_3936;
import net.minecraft.class_437;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortingLibClient
implements ClientModInitializer {
    private final Logger LOGGER = LoggerFactory.getLogger((String)"porting_lib_client");

    public void onInitializeClient() {
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)FluidTextUtil.NUMBER_FORMAT);
        ExtraSpawnDataEntity.initClientNetworking();
        ClientEntityEvents.ENTITY_LOAD.register((entity, world) -> {
            MultiPartEntity partEntity;
            if (entity instanceof MultiPartEntity && (partEntity = (MultiPartEntity)entity).isMultipartEntity()) {
                for (PartEntity<?> part : partEntity.getParts()) {
                    world.getPartEntityMap().put(part.method_5628(), part);
                }
            }
        });
        ClientEntityEvents.ENTITY_UNLOAD.register((entity, world) -> {
            MultiPartEntity partEntity;
            if (entity instanceof MultiPartEntity && (partEntity = (MultiPartEntity)entity).isMultipartEntity()) {
                for (PartEntity<?> part : partEntity.getParts()) {
                    world.getPartEntityMap().remove(part.method_5628());
                }
            }
        });
        ClientBlockApiCache.init();
        ModelsBakedCallback.EVENT.register((manager, models, loader) -> class_2378.field_11154.forEach(fluid -> {
            ClientHooks.registerFluidVariantsFromAttributes(fluid, fluid.getAttributes());
            if (FluidVariantAttributes.getHandler((class_3611)fluid) == null) {
                FluidVariantAttributes.register((class_3611)fluid, (FluidVariantAttributeHandler)new FluidVariantFluidAttributesHandler(fluid.getAttributes()));
            }
        }));
        ClientPlayNetworking.registerGlobalReceiver((class_2960)NetworkUtil.OPEN_ID, (client, handler, buf, responseSender) -> {
            int typeId = buf.method_10816();
            int syncId = buf.method_10816();
            class_2561 title = buf.method_10808();
            class_2540 extraData = new class_2540(Unpooled.wrappedBuffer((byte[])buf.method_10803(32600)));
            buf.retain();
            client.execute(() -> this.openScreen(typeId, syncId, title, extraData));
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openScreen(int typeId, int syncId, class_2561 title, class_2540 buf) {
        try {
            class_3917 type = (class_3917)class_2378.field_17429.method_10200(typeId);
            if (type == null) {
                this.LOGGER.warn("Unknown screen handler ID: {}", (Object)typeId);
                return;
            }
            if (!(type instanceof ExtendedScreenHandlerType)) {
                this.LOGGER.warn("Received extended opening packet for non-extended screen handler {}", (Object)typeId);
                return;
            }
            class_1703 c = ((ExtendedScreenHandlerType)type).create(syncId, class_310.method_1551().field_1724.method_31548(), buf);
            class_437 s = class_3929.method_17540((class_3917)type).create(c, class_310.method_1551().field_1724.method_31548(), title);
            class_310.method_1551().field_1724.field_7512 = ((class_3936)s).method_17577();
            class_310.method_1551().method_1507(s);
        }
        finally {
            buf.release();
        }
    }
}

