/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabricators_of_create.porting_lib.biome;

import com.google.common.collect.ImmutableList;
import io.github.fabricators_of_create.porting_lib.extensions.ResourceLocationExtensions;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5458;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BiomeDictionary {
    private static final boolean DEBUG = false;
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Map<class_5321<class_1959>, BiomeInfo> biomeInfoMap = new HashMap<class_5321<class_1959>, BiomeInfo>();

    public static void init() {
    }

    public static void addTypes(class_5321<class_1959> biome, Type ... types) {
        Collection<Type> supertypes = BiomeDictionary.listSupertypes(types);
        Collections.addAll(supertypes, types);
        for (Type type : supertypes) {
            type.biomes.add(biome);
        }
        BiomeInfo biomeInfo = BiomeDictionary.getBiomeInfo(biome);
        Collections.addAll(biomeInfo.types, types);
        biomeInfo.types.addAll(supertypes);
    }

    @Nonnull
    public static Set<class_5321<class_1959>> getBiomes(Type type) {
        return type.biomesUn;
    }

    @Nonnull
    public static Set<Type> getTypes(class_5321<class_1959> biome) {
        return BiomeDictionary.getBiomeInfo(biome).typesUn;
    }

    public static boolean areSimilar(class_5321<class_1959> biomeA, class_5321<class_1959> biomeB) {
        Set<Type> typesA = BiomeDictionary.getTypes(biomeA);
        Set<Type> typesB = BiomeDictionary.getTypes(biomeB);
        return typesA.stream().anyMatch(typesB::contains);
    }

    public static boolean hasType(class_5321<class_1959> biome, Type type) {
        return BiomeDictionary.getTypes(biome).contains(type);
    }

    public static boolean hasAnyType(class_5321<class_1959> biome) {
        return !BiomeDictionary.getBiomeInfo(biome).types.isEmpty();
    }

    private static BiomeInfo getBiomeInfo(class_5321<class_1959> biome) {
        return biomeInfoMap.computeIfAbsent(biome, k -> new BiomeInfo());
    }

    private static Collection<Type> listSupertypes(Type ... types) {
        HashSet<Type> supertypes = new HashSet<Type>();
        ArrayDeque<Type> next = new ArrayDeque<Type>();
        Collections.addAll(next, types);
        while (!next.isEmpty()) {
            Type type = (Type)next.remove();
            for (Type sType : Type.byName.values()) {
                if (!sType.subTypes.contains(type) || !supertypes.add(sType)) continue;
                next.add(sType);
            }
        }
        return supertypes;
    }

    private static void registerVanillaBiomes() {
        BiomeDictionary.addTypes((class_5321<class_1959>)class_1972.field_9423, Type.OCEAN, Type.OVERWORLD);
        BiomeDictionary.addTypes((class_5321<class_1959>)class_1972.field_9451, Type.PLAINS, Type.OVERWORLD);
        BiomeDictionary.addTypes((class_5321<class_1959>)class_1972.field_9424, Type.HOT, Type.DRY, Type.SANDY, Type.OVERWORLD);
        BiomeDictionary.addTypes((class_5321<class_1959>)class_1972.field_35116, Type.HILLS, Type.OVERWORLD);
        BiomeDictionary.addTypes((class_5321<class_1959>)class_1972.field_9409, Type.FOREST, Type.OVERWORLD);
        BiomeDictionary.addTypes((class_5321<class_1959>)class_1972.field_9420, Type.COLD, Type.CONIFEROUS, Type.FOREST, Type.OVERWORLD);
        BiomeDictionary.addTypes((class_5321<class_1959>)class_1972.field_9471, Type.WET, Type.SWAMP, Type.OVERWORLD);
        BiomeDictionary.addTypes((class_5321<class_1959>)class_1972.field_9438, Type.RIVER, Type.OVERWORLD);
        BiomeDictionary.addTypes((class_5321<class_1959>)class_1972.field_9461, Type.HOT, Type.DRY, Type.NETHER);
        BiomeDictionary.addTypes((class_5321<class_1959>)class_1972.field_9411, Type.COLD, Type.DRY, Type.END);
        BiomeDictionary.addTypes((class_5321<class_1959>)class_1972.field_9435, Type.COLD, Type.OCEAN, Type.SNOWY, Type.OVERWORLD);
        BiomeDictionary.addTypes((class_5321<class_1959>)class_1972.field_9463, Type.COLD, Type.RIVER, Type.SNOWY, Type.OVERWORLD);
        BiomeDictionary.addTypes((class_5321<class_1959>)class_1972.field_35117, Type.COLD, Type.SNOWY, Type.WASTELAND, Type.OVERWORLD);
        BiomeDictionary.addTypes((class_5321<class_1959>)class_1972.field_9462, Type.MUSHROOM, Type.RARE, Type.OVERWORLD);
        BiomeDictionary.addTypes((class_5321<class_1959>)class_1972.field_9434, Type.BEACH, Type.OVERWORLD);
        BiomeDictionary.addTypes((class_5321<class_1959>)class_1972.field_9417, Type.HOT, Type.WET, Type.DENSE, Type.JUNGLE, Type.OVERWORLD);
        BiomeDictionary.addTypes((class_5321<class_1959>)class_1972.field_35118, Type.HOT, Type.WET, Type.JUNGLE, Type.FOREST, Type.RARE, Type.OVERWORLD);
        BiomeDictionary.addTypes((class_5321<class_1959>)class_1972.field_9446, Type.OCEAN, Type.OVERWORLD);
        BiomeDictionary.addTypes((class_5321<class_1959>)class_1972.field_9419, Type.BEACH, Type.OVERWORLD);
        BiomeDictionary.addTypes((class_5321<class_1959>)class_1972.field_9478, Type.COLD, Type.BEACH, Type.SNOWY, Type.OVERWORLD);
        BiomeDictionary.addTypes((class_5321<class_1959>)class_1972.field_9412, Type.FOREST, Type.OVERWORLD);
        BiomeDictionary.addTypes((class_5321<class_1959>)class_1972.field_9475, Type.SPOOKY, Type.DENSE, Type.FOREST, Type.OVERWORLD);
        BiomeDictionary.addTypes((class_5321<class_1959>)class_1972.field_9454, Type.COLD, Type.CONIFEROUS, Type.FOREST, Type.SNOWY, Type.OVERWORLD);
        BiomeDictionary.addTypes((class_5321<class_1959>)class_1972.field_35119, Type.COLD, Type.CONIFEROUS, Type.FOREST, Type.OVERWORLD);
        BiomeDictionary.addTypes((class_5321<class_1959>)class_1972.field_35120, Type.HILLS, Type.FOREST, Type.SPARSE, Type.OVERWORLD);
        BiomeDictionary.addTypes((class_5321<class_1959>)class_1972.field_9449, Type.HOT, Type.SAVANNA, Type.PLAINS, Type.SPARSE, Type.OVERWORLD);
        BiomeDictionary.addTypes((class_5321<class_1959>)class_1972.field_9430, Type.HOT, Type.SAVANNA, Type.PLAINS, Type.SPARSE, Type.RARE, Type.OVERWORLD, Type.SLOPE, Type.PLATEAU);
        BiomeDictionary.addTypes((class_5321<class_1959>)class_1972.field_9415, Type.MESA, Type.SANDY, Type.DRY, Type.OVERWORLD);
        BiomeDictionary.addTypes((class_5321<class_1959>)class_1972.field_35110, Type.MESA, Type.SANDY, Type.DRY, Type.SPARSE, Type.OVERWORLD, Type.SLOPE, Type.PLATEAU);
        BiomeDictionary.addTypes((class_5321<class_1959>)class_1972.field_34470, Type.PLAINS, Type.PLATEAU, Type.SLOPE, Type.OVERWORLD);
        BiomeDictionary.addTypes((class_5321<class_1959>)class_1972.field_34471, Type.COLD, Type.CONIFEROUS, Type.FOREST, Type.SNOWY, Type.SLOPE, Type.OVERWORLD);
        BiomeDictionary.addTypes((class_5321<class_1959>)class_1972.field_34472, Type.COLD, Type.SPARSE, Type.SNOWY, Type.SLOPE, Type.OVERWORLD);
        BiomeDictionary.addTypes((class_5321<class_1959>)class_1972.field_34474, Type.COLD, Type.SPARSE, Type.SNOWY, Type.PEAK, Type.OVERWORLD);
        BiomeDictionary.addTypes((class_5321<class_1959>)class_1972.field_35115, Type.COLD, Type.SPARSE, Type.SNOWY, Type.PEAK, Type.OVERWORLD);
        BiomeDictionary.addTypes((class_5321<class_1959>)class_1972.field_34475, Type.HOT, Type.PEAK, Type.OVERWORLD);
        BiomeDictionary.addTypes((class_5321<class_1959>)class_1972.field_9457, Type.END);
        BiomeDictionary.addTypes((class_5321<class_1959>)class_1972.field_9447, Type.END);
        BiomeDictionary.addTypes((class_5321<class_1959>)class_1972.field_9442, Type.END);
        BiomeDictionary.addTypes((class_5321<class_1959>)class_1972.field_9465, Type.END);
        BiomeDictionary.addTypes((class_5321<class_1959>)class_1972.field_9408, Type.OCEAN, Type.HOT, Type.OVERWORLD);
        BiomeDictionary.addTypes((class_5321<class_1959>)class_1972.field_9441, Type.OCEAN, Type.OVERWORLD);
        BiomeDictionary.addTypes((class_5321<class_1959>)class_1972.field_9467, Type.OCEAN, Type.COLD, Type.OVERWORLD);
        BiomeDictionary.addTypes((class_5321<class_1959>)class_1972.field_9439, Type.OCEAN, Type.OVERWORLD);
        BiomeDictionary.addTypes((class_5321<class_1959>)class_1972.field_9470, Type.OCEAN, Type.COLD, Type.OVERWORLD);
        BiomeDictionary.addTypes((class_5321<class_1959>)class_1972.field_9418, Type.OCEAN, Type.COLD, Type.OVERWORLD);
        BiomeDictionary.addTypes((class_5321<class_1959>)class_1972.field_9473, Type.VOID);
        BiomeDictionary.addTypes((class_5321<class_1959>)class_1972.field_9455, Type.PLAINS, Type.RARE, Type.OVERWORLD);
        BiomeDictionary.addTypes((class_5321<class_1959>)class_1972.field_35111, Type.HILLS, Type.SPARSE, Type.RARE, Type.OVERWORLD);
        BiomeDictionary.addTypes((class_5321<class_1959>)class_1972.field_9414, Type.FOREST, Type.RARE, Type.OVERWORLD);
        BiomeDictionary.addTypes((class_5321<class_1959>)class_1972.field_9453, Type.COLD, Type.SNOWY, Type.RARE, Type.OVERWORLD);
        BiomeDictionary.addTypes((class_5321<class_1959>)class_1972.field_35112, Type.FOREST, Type.DENSE, Type.RARE, Type.OVERWORLD);
        BiomeDictionary.addTypes((class_5321<class_1959>)class_1972.field_35113, Type.DENSE, Type.FOREST, Type.RARE, Type.OVERWORLD);
        BiomeDictionary.addTypes((class_5321<class_1959>)class_1972.field_35114, Type.HOT, Type.DRY, Type.SPARSE, Type.SAVANNA, Type.HILLS, Type.RARE, Type.OVERWORLD);
        BiomeDictionary.addTypes((class_5321<class_1959>)class_1972.field_9443, Type.MESA, Type.HOT, Type.DRY, Type.SPARSE, Type.RARE, Type.OVERWORLD);
        BiomeDictionary.addTypes((class_5321<class_1959>)class_1972.field_9440, Type.HOT, Type.WET, Type.RARE, Type.JUNGLE, Type.OVERWORLD);
        BiomeDictionary.addTypes((class_5321<class_1959>)class_1972.field_29218, Type.UNDERGROUND, Type.LUSH, Type.WET, Type.OVERWORLD);
        BiomeDictionary.addTypes((class_5321<class_1959>)class_1972.field_28107, Type.UNDERGROUND, Type.SPARSE, Type.OVERWORLD);
        BiomeDictionary.addTypes((class_5321<class_1959>)class_1972.field_22076, Type.HOT, Type.DRY, Type.NETHER);
        BiomeDictionary.addTypes((class_5321<class_1959>)class_1972.field_22077, Type.HOT, Type.DRY, Type.NETHER, Type.FOREST);
        BiomeDictionary.addTypes((class_5321<class_1959>)class_1972.field_22075, Type.HOT, Type.DRY, Type.NETHER, Type.FOREST);
        BiomeDictionary.addTypes((class_5321<class_1959>)class_1972.field_23859, Type.HOT, Type.DRY, Type.NETHER);
    }

    private static /* synthetic */ class_5321 lambda$registerVanillaBiomes$2(class_1959 b) {
        return class_5321.method_29179((class_5321)class_2378.field_25114, (class_2960)class_5458.field_25933.method_10221((Object)b));
    }

    private static /* synthetic */ void lambda$registerVanillaBiomes$1(StringBuilder buf, String name, Type type) {
        buf.append("    ").append(type.name).append(": ").append(type.biomes.stream().map(class_5321::method_29177).sorted(ResourceLocationExtensions::compareNamespaced).map(Object::toString).collect(Collectors.joining(", "))).append('\n');
    }

    static {
        BiomeDictionary.registerVanillaBiomes();
    }

    public static final class Type {
        private static final Map<String, Type> byName = new TreeMap<String, Type>();
        private static Collection<Type> allTypes = Collections.unmodifiableCollection(byName.values());
        public static final Type HOT = new Type("HOT", new Type[0]);
        public static final Type COLD = new Type("COLD", new Type[0]);
        public static final Type SPARSE = new Type("SPARSE", new Type[0]);
        public static final Type DENSE = new Type("DENSE", new Type[0]);
        public static final Type WET = new Type("WET", new Type[0]);
        public static final Type DRY = new Type("DRY", new Type[0]);
        public static final Type SAVANNA = new Type("SAVANNA", new Type[0]);
        public static final Type CONIFEROUS = new Type("CONIFEROUS", new Type[0]);
        public static final Type JUNGLE = new Type("JUNGLE", new Type[0]);
        public static final Type SPOOKY = new Type("SPOOKY", new Type[0]);
        public static final Type DEAD = new Type("DEAD", new Type[0]);
        public static final Type LUSH = new Type("LUSH", new Type[0]);
        public static final Type MUSHROOM = new Type("MUSHROOM", new Type[0]);
        public static final Type MAGICAL = new Type("MAGICAL", new Type[0]);
        public static final Type RARE = new Type("RARE", new Type[0]);
        public static final Type PLATEAU = new Type("PLATEAU", new Type[0]);
        public static final Type MODIFIED = new Type("MODIFIED", new Type[0]);
        public static final Type OCEAN = new Type("OCEAN", new Type[0]);
        public static final Type RIVER = new Type("RIVER", new Type[0]);
        public static final Type WATER = new Type("WATER", OCEAN, RIVER);
        public static final Type MESA = new Type("MESA", new Type[0]);
        public static final Type FOREST = new Type("FOREST", new Type[0]);
        public static final Type PLAINS = new Type("PLAINS", new Type[0]);
        public static final Type HILLS = new Type("HILLS", new Type[0]);
        public static final Type SWAMP = new Type("SWAMP", new Type[0]);
        public static final Type SANDY = new Type("SANDY", new Type[0]);
        public static final Type SNOWY = new Type("SNOWY", new Type[0]);
        public static final Type WASTELAND = new Type("WASTELAND", new Type[0]);
        public static final Type BEACH = new Type("BEACH", new Type[0]);
        public static final Type VOID = new Type("VOID", new Type[0]);
        public static final Type UNDERGROUND = new Type("UNDERGROUND", new Type[0]);
        public static final Type PEAK = new Type("PEAK", new Type[0]);
        public static final Type SLOPE = new Type("SLOPE", new Type[0]);
        public static final Type MOUNTAIN = new Type("MOUNTAIN", PEAK, SLOPE);
        public static final Type OVERWORLD = new Type("OVERWORLD", new Type[0]);
        public static final Type NETHER = new Type("NETHER", new Type[0]);
        public static final Type END = new Type("END", new Type[0]);
        private final String name;
        private final List<Type> subTypes;
        private final Set<class_5321<class_1959>> biomes = new HashSet<class_5321<class_1959>>();
        private final Set<class_5321<class_1959>> biomesUn = Collections.unmodifiableSet(this.biomes);

        private Type(String name, Type ... subTypes) {
            this.name = name;
            this.subTypes = ImmutableList.copyOf((Object[])subTypes);
            byName.put(name, this);
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        public static Type getType(String name, Type ... subTypes) {
            Type t = byName.get(name = name.toUpperCase());
            if (t == null) {
                t = new Type(name, subTypes);
            }
            return t;
        }

        public static boolean hasType(String name) {
            return byName.containsKey(name.toUpperCase());
        }

        public static Collection<Type> getAll() {
            return allTypes;
        }

        @Nullable
        public static Type fromVanilla(class_1959.class_1961 category) {
            if (category == class_1959.class_1961.field_9371) {
                return null;
            }
            if (category == class_1959.class_1961.field_9360) {
                return VOID;
            }
            return Type.getType(category.name(), new Type[0]);
        }
    }

    private static class BiomeInfo {
        private final Set<Type> types = new HashSet<Type>();
        private final Set<Type> typesUn = Collections.unmodifiableSet(this.types);

        private BiomeInfo() {
        }
    }
}

