/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabricators_of_create.porting_lib.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.fabricators_of_create.porting_lib.data.SoundDefinition;
import java.io.IOException;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.class_2378;
import net.minecraft.class_2403;
import net.minecraft.class_2405;
import net.minecraft.class_2408;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3414;
import net.minecraftforge.common.data.ExistingFileHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class SoundDefinitionsProvider
implements class_2405 {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final class_2403 generator;
    private final String modId;
    private final ExistingFileHelper helper;
    private final Map<String, SoundDefinition> sounds = new LinkedHashMap<String, SoundDefinition>();

    protected SoundDefinitionsProvider(class_2403 generator, String modId, ExistingFileHelper helper) {
        this.generator = generator;
        this.modId = modId;
        this.helper = helper;
    }

    public abstract void registerSounds();

    public void method_10319(class_2408 cache) throws IOException {
        this.sounds.clear();
        this.registerSounds();
        this.validate();
        if (!this.sounds.isEmpty()) {
            this.save(cache, this.generator.method_10313().resolve("assets/" + this.modId + "/sounds.json"));
        }
    }

    public String method_10321() {
        return "Sound Definitions";
    }

    protected static SoundDefinition definition() {
        return SoundDefinition.definition();
    }

    protected static SoundDefinition.Sound sound(class_2960 name, SoundDefinition.SoundType type) {
        return SoundDefinition.Sound.sound(name, type);
    }

    protected static SoundDefinition.Sound sound(class_2960 name) {
        return SoundDefinitionsProvider.sound(name, SoundDefinition.SoundType.SOUND);
    }

    protected static SoundDefinition.Sound sound(String name, SoundDefinition.SoundType type) {
        return SoundDefinitionsProvider.sound(new class_2960(name), type);
    }

    protected static SoundDefinition.Sound sound(String name) {
        return SoundDefinitionsProvider.sound(new class_2960(name));
    }

    protected void add(Supplier<class_3414> soundEvent, SoundDefinition definition) {
        this.add(soundEvent.get(), definition);
    }

    protected void add(class_3414 soundEvent, SoundDefinition definition) {
        this.add(soundEvent.method_14833(), definition);
    }

    protected void add(class_2960 soundEvent, SoundDefinition definition) {
        this.addSounds(soundEvent.method_12832(), definition);
    }

    protected void add(String soundEvent, SoundDefinition definition) {
        this.add(new class_2960(soundEvent), definition);
    }

    private void addSounds(String soundEvent, SoundDefinition definition) {
        if (this.sounds.put(soundEvent, definition) != null) {
            throw new IllegalStateException("Sound event '" + this.modId + ":" + soundEvent + "' already exists");
        }
    }

    private void validate() {
        List notValid = this.sounds.entrySet().stream().filter(it -> !this.validate((String)it.getKey(), (SoundDefinition)it.getValue())).map(Map.Entry::getKey).map(it -> this.modId + ":" + it).collect(Collectors.toList());
        if (!notValid.isEmpty()) {
            throw new IllegalStateException("Found invalid sound events: " + notValid);
        }
    }

    private boolean validate(String name, SoundDefinition def) {
        return def.soundList().stream().allMatch(it -> this.validate(name, (SoundDefinition.Sound)it));
    }

    private boolean validate(String name, SoundDefinition.Sound sound) {
        switch (sound.type()) {
            case SOUND: {
                return this.validateSound(name, sound.name());
            }
            case EVENT: {
                return this.validateEvent(name, sound.name());
            }
        }
        throw new IllegalArgumentException("The given sound '" + sound.name() + "' does not have a valid type: expected either SOUND or EVENT, but found " + sound.type());
    }

    private boolean validateSound(String soundName, class_2960 name) {
        boolean valid = this.helper.exists(name, class_3264.field_14188, ".ogg", "sounds");
        if (!valid) {
            String path = name.method_12836() + ":sounds/" + name.method_12832() + ".ogg";
            LOGGER.warn("Unable to find corresponding OGG file '{}' for sound event '{}'", (Object)path, (Object)soundName);
        }
        return valid;
    }

    private boolean validateEvent(String soundName, class_2960 name) {
        boolean valid;
        boolean bl = valid = this.sounds.containsKey(soundName) || class_2378.field_11156.method_10250(name);
        if (!valid) {
            LOGGER.warn("Unable to find event '{}' referenced from '{}'", (Object)name, (Object)soundName);
        }
        return valid;
    }

    private void save(class_2408 cache, Path targetFile) throws IOException {
        class_2405.method_10320((Gson)GSON, (class_2408)cache, (JsonElement)this.mapToJson(this.sounds), (Path)targetFile);
    }

    private JsonObject mapToJson(Map<String, SoundDefinition> map) {
        JsonObject obj = new JsonObject();
        map.forEach((k, v) -> obj.add(k, (JsonElement)v.serialize()));
        return obj;
    }
}

