/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabricators_of_create.porting_lib.event.common;

import io.github.fabricators_of_create.porting_lib.event.common.EntityEvent;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3222;

public class EntityEvents {
    public static final Event<EyeHeight> EYE_HEIGHT = EventFactory.createArrayBacked(EyeHeight.class, callbacks -> (entity, height) -> {
        for (EyeHeight callback : callbacks) {
            float newHeight = callback.onEntitySize(entity, height);
            if (newHeight == height) continue;
            return newHeight;
        }
        return height;
    });
    public static final Event<JoinWorld> ON_JOIN_WORLD = EventFactory.createArrayBacked(JoinWorld.class, callbacks -> (entity, world, loadedFromDisk) -> {
        for (JoinWorld callback : callbacks) {
            if (callback.onJoinWorld(entity, world, loadedFromDisk)) continue;
            return true;
        }
        return false;
    });
    public static final Event<Remove> ON_REMOVE = EventFactory.createArrayBacked(Remove.class, callbacks -> (entity, reason) -> {
        for (Remove e : callbacks) {
            e.onRemove(entity, reason);
        }
    });
    public static final Event<Teleport> TELEPORT = EventFactory.createArrayBacked(Teleport.class, callbacks -> event -> {
        for (Teleport callback : callbacks) {
            callback.onTeleport(event);
            if (!event.isCanceled()) continue;
            return;
        }
    });
    public static final Event<Tracking> START_TRACKING_TAIL = EventFactory.createArrayBacked(Tracking.class, callbacks -> (entity, player) -> {
        for (Tracking callback : callbacks) {
            callback.onTrackingStart(entity, player);
        }
    });
    public static final Event<EnteringSection> ENTERING_SECTION = EventFactory.createArrayBacked(EnteringSection.class, callbacks -> (entity, packedOldPos, packedNewPos) -> {
        for (EnteringSection e : callbacks) {
            e.onEntityEnterSection(entity, packedOldPos, packedNewPos);
        }
    });

    @FunctionalInterface
    public static interface EnteringSection {
        public void onEntityEnterSection(class_1297 var1, long var2, long var4);
    }

    public static interface Tracking {
        public void onTrackingStart(class_1297 var1, class_3222 var2);
    }

    @FunctionalInterface
    public static interface Teleport {
        public void onTeleport(EntityTeleportEvent var1);

        public static class EntityTeleportEvent
        extends EntityEvent {
            protected double targetX;
            protected double targetY;
            protected double targetZ;

            public EntityTeleportEvent(class_1297 entity, double targetX, double targetY, double targetZ) {
                super(entity);
                this.targetX = targetX;
                this.targetY = targetY;
                this.targetZ = targetZ;
            }

            @Override
            public void sendEvent() {
                ((Teleport)TELEPORT.invoker()).onTeleport(this);
            }

            @Override
            public class_1297 getEntity() {
                return this.entity;
            }

            public double getTargetX() {
                return this.targetX;
            }

            public void setTargetX(double targetX) {
                this.targetX = targetX;
            }

            public double getTargetY() {
                return this.targetY;
            }

            public void setTargetY(double targetY) {
                this.targetY = targetY;
            }

            public double getTargetZ() {
                return this.targetZ;
            }

            public void setTargetZ(double targetZ) {
                this.targetZ = targetZ;
            }

            public class_243 getTarget() {
                return new class_243(this.targetX, this.targetY, this.targetZ);
            }

            public double getPrevX() {
                return this.getEntity().method_23317();
            }

            public double getPrevY() {
                return this.getEntity().method_23318();
            }

            public double getPrevZ() {
                return this.getEntity().method_23321();
            }

            public class_243 getPrev() {
                return this.getEntity().method_19538();
            }
        }
    }

    @FunctionalInterface
    public static interface Remove {
        public void onRemove(class_1297 var1, class_1297.class_5529 var2);
    }

    @FunctionalInterface
    public static interface JoinWorld {
        public boolean onJoinWorld(class_1297 var1, class_1937 var2, boolean var3);
    }

    @FunctionalInterface
    public static interface EyeHeight {
        public float onEntitySize(class_1297 var1, float var2);
    }
}

