/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabricators_of_create.porting_lib.model;

import com.google.common.collect.ImmutableList;
import io.github.fabricators_of_create.porting_lib.model.IVertexConsumer;
import io.github.fabricators_of_create.porting_lib.util.LightUtil;
import net.minecraft.class_1058;
import net.minecraft.class_2350;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_296;
import net.minecraft.class_777;

public class BakedQuadBuilder
implements IVertexConsumer {
    private static final int SIZE = class_290.field_1590.method_1357().size();
    private final float[][][] unpackedData = new float[4][SIZE][4];
    private final float eps = 0.00390625f;
    private int tint = -1;
    private class_2350 orientation;
    private class_1058 texture;
    private boolean applyDiffuseLighting = true;
    private int vertices = 0;
    private int elements = 0;
    private boolean full = false;
    private boolean contractUVs = false;

    public BakedQuadBuilder() {
    }

    public BakedQuadBuilder(class_1058 texture) {
        this.texture = texture;
    }

    public void setContractUVs(boolean value) {
        this.contractUVs = value;
    }

    @Override
    public class_293 getVertexFormat() {
        return class_290.field_1590;
    }

    @Override
    public void setQuadTint(int tint) {
        this.tint = tint;
    }

    @Override
    public void setQuadOrientation(class_2350 orientation) {
        this.orientation = orientation;
    }

    @Override
    public void setTexture(class_1058 texture) {
        this.texture = texture;
    }

    @Override
    public void setApplyDiffuseLighting(boolean diffuse) {
        this.applyDiffuseLighting = diffuse;
    }

    @Override
    public void put(int element, float ... data) {
        for (int i = 0; i < 4; ++i) {
            this.unpackedData[this.vertices][element][i] = i < data.length ? data[i] : 0.0f;
        }
        ++this.elements;
        if (this.elements == SIZE) {
            ++this.vertices;
            this.elements = 0;
        }
        if (this.vertices == 4) {
            this.full = true;
        }
    }

    public class_777 build() {
        if (!this.full) {
            throw new IllegalStateException("not enough data");
        }
        if (this.texture == null) {
            throw new IllegalStateException("texture not set");
        }
        if (this.contractUVs) {
            int i;
            int v;
            class_296 e;
            int uve;
            float tY;
            float tX = (float)this.texture.method_4578() / (this.texture.method_4577() - this.texture.method_4594());
            float tS = tX > (tY = (float)this.texture.method_4595() / (this.texture.method_4575() - this.texture.method_4593())) ? tX : tY;
            float ep = 1.0f / (tS * 256.0f);
            ImmutableList elements = class_290.field_1590.method_1357();
            for (uve = 0; uve < elements.size() && ((e = (class_296)elements.get(uve)).method_1382() != class_296.class_298.field_1636 || e.method_1385() != 0); ++uve) {
            }
            if (uve == elements.size()) {
                throw new IllegalStateException("Can't contract UVs: format doesn't contain UVs");
            }
            float[] uvc = new float[4];
            for (v = 0; v < 4; ++v) {
                for (i = 0; i < 4; ++i) {
                    int n = i;
                    uvc[n] = uvc[n] + this.unpackedData[v][uve][i] / 4.0f;
                }
            }
            for (v = 0; v < 4; ++v) {
                for (i = 0; i < 4; ++i) {
                    float uo = this.unpackedData[v][uve][i];
                    float un = uo * 0.99609375f + uvc[i] * 0.00390625f;
                    float ud = uo - un;
                    float aud = ud;
                    if (aud < 0.0f) {
                        aud = -aud;
                    }
                    if (aud < ep) {
                        float udc = uo - uvc[i];
                        if (udc < 0.0f) {
                            udc = -udc;
                        }
                        un = udc < 2.0f * ep ? (uo + uvc[i]) / 2.0f : uo + (ud < 0.0f ? ep : -ep);
                    }
                    this.unpackedData[v][uve][i] = un;
                }
            }
        }
        int[] packed = new int[class_290.field_1590.method_1359() * 4];
        for (int v = 0; v < 4; ++v) {
            for (int e = 0; e < SIZE; ++e) {
                LightUtil.pack(this.unpackedData[v][e], packed, class_290.field_1590, v, e);
            }
        }
        return new class_777(packed, this.tint, this.orientation, this.texture, this.applyDiffuseLighting);
    }
}

