/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabricators_of_create.porting_lib.transfer;

import io.github.fabricators_of_create.porting_lib.transfer.cache.ClientFluidLookupCache;
import io.github.fabricators_of_create.porting_lib.transfer.cache.ClientItemLookupCache;
import io.github.fabricators_of_create.porting_lib.transfer.cache.EmptyFluidLookupCache;
import io.github.fabricators_of_create.porting_lib.transfer.cache.EmptyItemLookupCache;
import io.github.fabricators_of_create.porting_lib.transfer.fluid.FluidTransferable;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemTransferable;
import io.github.fabricators_of_create.porting_lib.util.FluidStack;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiCache;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiLookup;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.item.PlayerInventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.base.CombinedStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import org.jetbrains.annotations.NotNull;

public class TransferUtil {
    public static Transaction getTransaction() {
        TransactionContext open = Transaction.getCurrentUnsafe();
        if (open != null) {
            return open.openNested();
        }
        return Transaction.openOuter();
    }

    @Nullable
    public static Storage<ItemVariant> getItemStorage(class_1937 level, class_2338 pos, @Nullable class_2350 side) {
        return TransferUtil.getItemStorage(level, pos, null, side);
    }

    @Nullable
    public static Storage<ItemVariant> getItemStorage(class_1937 level, class_2338 pos) {
        return TransferUtil.getItemStorage(level, pos, null);
    }

    @Nullable
    public static Storage<ItemVariant> getItemStorage(class_2586 be, @Nullable class_2350 side) {
        return TransferUtil.getItemStorage(null, null, be, side);
    }

    @Nullable
    public static Storage<ItemVariant> getItemStorage(class_2586 be) {
        return TransferUtil.getItemStorage(be, null);
    }

    @Nullable
    public static Storage<ItemVariant> getItemStorage(class_1937 level, class_2338 pos, class_2586 be, @Nullable class_2350 side) {
        boolean libOnly;
        if (be == null) {
            Objects.requireNonNull(level, "If a null Block Entity is provided, the Level may NOT be null!");
            Objects.requireNonNull(pos, "If a null Block Entity is provided, the pos may NOT be null!");
        }
        if (level == null || pos == null) {
            Objects.requireNonNull(be, "If a null level or pos is provided, the Block Entity may NOT be null!");
            level = be.method_10997();
            pos = be.method_11016();
        }
        boolean bl = libOnly = level == null || level.method_8608();
        if (libOnly) {
            if (be instanceof ItemTransferable) {
                boolean client;
                ItemTransferable t = (ItemTransferable)be;
                boolean bl2 = client = level != null && level.method_8608();
                if (client) {
                    if (t.canTransferItemsClientSide()) {
                        return t.getItemStorage(side);
                    }
                } else {
                    return t.getItemStorage(side);
                }
            }
            return null;
        }
        ArrayList<Storage> itemStorages = new ArrayList<Storage>();
        class_2680 state = be == null ? level.method_8320(pos) : be.method_11010();
        block0: for (class_2350 direction : TransferUtil.getDirections(side)) {
            Storage fluidStorage = (Storage)ItemStorage.SIDED.find(level, pos, state, be, (Object)direction);
            if (fluidStorage == null) continue;
            if (itemStorages.size() == 0) {
                itemStorages.add(fluidStorage);
                continue;
            }
            for (Storage storage : itemStorages) {
                if (Objects.equals(fluidStorage, storage)) continue;
                itemStorages.add(fluidStorage);
                continue block0;
            }
        }
        if (itemStorages.isEmpty()) {
            return null;
        }
        if (itemStorages.size() == 1) {
            return (Storage)itemStorages.get(0);
        }
        return new CombinedStorage(itemStorages);
    }

    @Nullable
    public static Storage<FluidVariant> getFluidStorage(class_1937 level, class_2338 pos, @Nullable class_2350 side) {
        return TransferUtil.getFluidStorage(level, pos, null, side);
    }

    @Nullable
    public static Storage<FluidVariant> getFluidStorage(class_1937 level, class_2338 pos) {
        return TransferUtil.getFluidStorage(level, pos, null);
    }

    @Nullable
    public static Storage<FluidVariant> getFluidStorage(class_2586 be, @Nullable class_2350 side) {
        return TransferUtil.getFluidStorage(null, null, be, side);
    }

    @Nullable
    public static Storage<FluidVariant> getFluidStorage(class_2586 be) {
        return TransferUtil.getFluidStorage(be, null);
    }

    @Nullable
    public static Storage<FluidVariant> getFluidStorage(class_1937 level, class_2338 pos, class_2586 be, @Nullable class_2350 side) {
        boolean libOnly;
        if (be == null) {
            Objects.requireNonNull(level, "If a null Block Entity is provided, the Level may NOT be null!");
            Objects.requireNonNull(pos, "If a null Block Entity is provided, the pos may NOT be null!");
        }
        if (level == null || pos == null) {
            Objects.requireNonNull(be, "If a null level or pos is provided, the Block Entity may NOT be null!");
            level = be.method_10997();
            pos = be.method_11016();
        }
        boolean bl = libOnly = level == null || level.method_8608();
        if (libOnly) {
            if (be instanceof FluidTransferable) {
                boolean client;
                FluidTransferable t = (FluidTransferable)be;
                boolean bl2 = client = level != null && level.method_8608();
                if (client) {
                    if (t.canTransferFluidsClientSide()) {
                        return t.getFluidStorage(side);
                    }
                } else {
                    return t.getFluidStorage(side);
                }
            }
            return null;
        }
        ArrayList<Storage> fluidStorages = new ArrayList<Storage>();
        class_2680 state = be == null ? level.method_8320(pos) : be.method_11010();
        block0: for (class_2350 direction : TransferUtil.getDirections(side)) {
            Storage fluidStorage = (Storage)FluidStorage.SIDED.find(level, pos, state, be, (Object)direction);
            if (fluidStorage == null) continue;
            if (fluidStorages.size() == 0) {
                fluidStorages.add(fluidStorage);
                continue;
            }
            for (Storage storage : fluidStorages) {
                if (Objects.equals(fluidStorage, storage)) continue;
                fluidStorages.add(fluidStorage);
                continue block0;
            }
        }
        if (fluidStorages.isEmpty()) {
            return null;
        }
        if (fluidStorages.size() == 1) {
            return (Storage)fluidStorages.get(0);
        }
        return new CombinedStorage(fluidStorages);
    }

    @Nullable
    public static <T> Storage<T> getStorage(class_2586 be, @Nullable class_2350 side, Class<T> capability) {
        if (capability == ItemVariant.class) {
            return TransferUtil.getItemStorage(null, null, be, side);
        }
        if (capability == FluidVariant.class) {
            return TransferUtil.getFluidStorage(null, null, be, side);
        }
        throw new RuntimeException("Class must either be ItemVariant or FluidVariant!");
    }

    private static class_2350[] getDirections(@Nullable class_2350 direction) {
        if (direction == null) {
            return class_2350.values();
        }
        return new class_2350[]{direction};
    }

    public static Optional<FluidStack> getFluidContained(class_1799 container) {
        FluidStack first;
        Storage storage;
        if (container != null && !container.method_7960() && (storage = (Storage)ContainerItemContext.withInitial((class_1799)container).find(FluidStorage.ITEM)) != null && (first = TransferUtil.getFirstFluid((Storage<FluidVariant>)storage)) != null) {
            return Optional.of(first);
        }
        return Optional.empty();
    }

    public static <T> long firstCapacity(Storage<T> storage) {
        List<Long> capacities = TransferUtil.capacities(storage, 1);
        return capacities.size() > 0 ? capacities.get(0) : 0L;
    }

    public static <T> long totalCapacity(Storage<T> storage) {
        long total = 0L;
        List<Long> capacities = TransferUtil.capacities(storage, Integer.MAX_VALUE);
        for (Long l : capacities) {
            total += l.longValue();
        }
        return total;
    }

    public static <T> List<Long> capacities(Storage<T> storage, int cutoff) {
        ArrayList<Long> capacities = new ArrayList<Long>();
        try (Transaction t = TransferUtil.getTransaction();){
            for (StorageView view : storage.iterable((TransactionContext)t)) {
                capacities.add(view.getCapacity());
                if (capacities.size() != cutoff) continue;
                break;
            }
        }
        return capacities;
    }

    public static FluidStack firstCopyOrEmpty(Storage<FluidVariant> storage) {
        return TransferUtil.firstOrEmpty(storage).copy();
    }

    public static FluidStack firstOrEmpty(Storage<FluidVariant> storage) {
        FluidStack stack = TransferUtil.getFirstFluid(storage);
        return stack == null ? FluidStack.EMPTY : stack;
    }

    @Nullable
    public static FluidStack getFirstFluid(Storage<FluidVariant> storage) {
        List<FluidStack> stacks = TransferUtil.getFluids(storage, 1);
        if (stacks.size() > 0) {
            return stacks.get(0);
        }
        return null;
    }

    public static List<FluidStack> getAllFluids(Storage<FluidVariant> storage) {
        return TransferUtil.getFluids(storage, Integer.MAX_VALUE);
    }

    public static List<FluidStack> getFluids(Storage<FluidVariant> storage, int cutoff) {
        ArrayList<FluidStack> stacks = new ArrayList<FluidStack>();
        try (Transaction t = TransferUtil.getTransaction();){
            for (StorageView view : storage.iterable((TransactionContext)t)) {
                if (!view.isResourceBlank()) {
                    stacks.add(new FluidStack((StorageView<FluidVariant>)view));
                }
                if (stacks.size() != cutoff) continue;
                break;
            }
        }
        return stacks;
    }

    public static List<class_1799> getAllItems(Storage<ItemVariant> storage) {
        return TransferUtil.getItems(storage, Integer.MAX_VALUE);
    }

    public static List<class_1799> getItems(Storage<ItemVariant> storage, int cutoff) {
        ArrayList<class_1799> stacks = new ArrayList<class_1799>();
        try (Transaction t = TransferUtil.getTransaction();){
            for (StorageView view : storage.iterable((TransactionContext)t)) {
                if (!view.isResourceBlank()) {
                    int stackSize;
                    ItemVariant item = (ItemVariant)view.getResource();
                    int maxSize = item.getItem().method_7882();
                    for (long contained = view.getAmount(); contained > 0L && stacks.size() < cutoff; contained -= (long)stackSize) {
                        stackSize = Math.min(maxSize, (int)contained);
                        stacks.add(item.toStack(stackSize));
                    }
                }
                if (stacks.size() != cutoff) continue;
                break;
            }
        }
        return stacks;
    }

    public static <T> boolean clearStorage(Storage<T> storage) {
        if (!storage.supportsExtraction()) {
            return false;
        }
        boolean success = true;
        try (Transaction t = TransferUtil.getTransaction();){
            Iterator itr = storage.iterator((TransactionContext)t);
            StorageView currentView = itr.hasNext() ? (StorageView)itr.next() : null;
            int attempts = 0;
            while (currentView != null) {
                if (currentView.isResourceBlank() || attempts >= 10) {
                    currentView = itr.hasNext() ? (StorageView)itr.next() : null;
                    attempts = 0;
                    continue;
                }
                long contained = currentView.getAmount();
                if (contained == 0L) {
                    currentView = itr.hasNext() ? (StorageView)itr.next() : null;
                    attempts = 0;
                    continue;
                }
                Object variant = currentView.getResource();
                long extracted = currentView.extract(variant, contained, (TransactionContext)t);
                if (extracted == 0L) {
                    success = false;
                    attempts = 0;
                    currentView = itr.hasNext() ? (StorageView)itr.next() : null;
                }
                ++attempts;
            }
            t.commit();
        }
        return success;
    }

    public static FluidStack extractAnyFluid(Storage<FluidVariant> storage, long maxAmount, Transaction tx) {
        FluidStack fluid = FluidStack.EMPTY;
        if (!storage.supportsExtraction()) {
            return fluid;
        }
        for (StorageView view : storage.iterable((TransactionContext)tx)) {
            if (view.isResourceBlank()) continue;
            FluidVariant var = (FluidVariant)view.getResource();
            long amount = Math.min(maxAmount, view.getAmount());
            long extracted = view.extract((Object)var, amount, (TransactionContext)tx);
            maxAmount -= extracted;
            if (fluid.isEmpty()) {
                fluid = new FluidStack(var, extracted);
            } else if (fluid.canFill(var)) {
                fluid.grow(extracted);
            }
            if (maxAmount != 0L) continue;
            break;
        }
        return fluid;
    }

    public static FluidStack extractAnyFluid(Storage<FluidVariant> storage, long maxAmount) {
        try (Transaction tx = TransferUtil.getTransaction();){
            FluidStack fluid = TransferUtil.extractAnyFluid(storage, maxAmount, tx);
            tx.commit();
            FluidStack fluidStack = fluid;
            return fluidStack;
        }
    }

    public static FluidStack simulateExtractAnyFluid(Storage<FluidVariant> storage, long maxAmount) {
        try (Transaction t = TransferUtil.getTransaction();){
            FluidStack fluidStack = TransferUtil.extractAnyFluid(storage, maxAmount, t);
            return fluidStack;
        }
    }

    public static class_1799 extractAnyItem(Storage<ItemVariant> storage, long maxAmount, Transaction tx) {
        class_1799 stack = class_1799.field_8037;
        if (!storage.supportsExtraction()) {
            return stack;
        }
        for (StorageView view : storage.iterable((TransactionContext)tx)) {
            if (view.isResourceBlank()) continue;
            ItemVariant var = (ItemVariant)view.getResource();
            long amount = Math.min((long)var.getItem().method_7882(), Math.min(maxAmount, view.getAmount()));
            long extracted = view.extract((Object)var, amount, (TransactionContext)tx);
            maxAmount -= extracted;
            if (stack.method_7960()) {
                stack = var.toStack((int)extracted);
            } else if (var.matches(stack)) {
                stack.method_7933((int)extracted);
            }
            if (maxAmount != 0L) continue;
            break;
        }
        return stack;
    }

    public static class_1799 extractAnyItem(Storage<ItemVariant> storage, long maxAmount) {
        try (Transaction tx = TransferUtil.getTransaction();){
            class_1799 stack = TransferUtil.extractAnyItem(storage, maxAmount, tx);
            tx.commit();
            class_1799 class_17992 = stack;
            return class_17992;
        }
    }

    public static class_1799 simulateExtractAnyItem(Storage<ItemVariant> storage, long maxAmount) {
        try (Transaction tx = TransferUtil.getTransaction();){
            class_1799 class_17992 = TransferUtil.extractAnyItem(storage, maxAmount, tx);
            return class_17992;
        }
    }

    public static <T> long simulateExtractView(@NotNull StorageView<T> view, T variant, long amount) {
        try (Transaction t = TransferUtil.getTransaction();){
            long l = view.extract(variant, amount, (TransactionContext)t);
            return l;
        }
    }

    public static <T> long extract(Storage<T> storage, T variant, long amount) {
        if (!storage.supportsExtraction()) {
            return 0L;
        }
        try (Transaction t = TransferUtil.getTransaction();){
            long extracted = storage.extract(variant, amount, (TransactionContext)t);
            t.commit();
            long l = extracted;
            return l;
        }
    }

    public static long extractItem(Storage<ItemVariant> storage, class_1799 stack) {
        return TransferUtil.extract(storage, ItemVariant.of((class_1799)stack), stack.method_7947());
    }

    public static long extractFluid(Storage<FluidVariant> storage, FluidStack stack) {
        return TransferUtil.extract(storage, stack.getType(), stack.getAmount());
    }

    public static <T> long insert(Storage<T> storage, T variant, long amount) {
        if (!storage.supportsInsertion()) {
            return 0L;
        }
        try (Transaction t = TransferUtil.getTransaction();){
            long inserted = storage.insert(variant, amount, (TransactionContext)t);
            t.commit();
            long l = inserted;
            return l;
        }
    }

    public static long insertItem(Storage<ItemVariant> storage, class_1799 stack) {
        return TransferUtil.insert(storage, ItemVariant.of((class_1799)stack), stack.method_7947());
    }

    public static long insertFluid(Storage<FluidVariant> storage, FluidStack stack) {
        return TransferUtil.insert(storage, stack.getType(), stack.getAmount());
    }

    public static long insertToMainInv(class_1657 player, ItemVariant variant, long amount) {
        long inserted = 0L;
        try (Transaction t = TransferUtil.getTransaction();){
            PlayerInventoryStorage inv = PlayerInventoryStorage.of((class_1657)player);
            if (!inv.supportsInsertion()) {
                long l = 0L;
                return l;
            }
            List slots = inv.getSlots();
            for (int i = 9; i < 36; ++i) {
                SingleSlotStorage slot = (SingleSlotStorage)slots.get(i);
                inserted += slot.insert((Object)variant, amount - inserted, (TransactionContext)t);
                if (amount == 0L) break;
            }
            t.commit();
            long l = inserted;
            return l;
        }
    }

    public static List<class_1799> extractAllAsStacks(Storage<ItemVariant> storage) {
        ArrayList<class_1799> stacks = new ArrayList<class_1799>();
        if (!storage.supportsExtraction()) {
            return stacks;
        }
        try (Transaction t = TransferUtil.getTransaction();){
            StorageView currentView;
            Iterator itr = storage.iterator((TransactionContext)t);
            StorageView storageView = currentView = itr.hasNext() ? (StorageView)itr.next() : null;
            while (currentView != null) {
                int max;
                if (currentView.isResourceBlank()) {
                    currentView = itr.hasNext() ? (StorageView)itr.next() : null;
                    continue;
                }
                long contained = currentView.getAmount();
                if (contained == 0L) {
                    currentView = itr.hasNext() ? (StorageView)itr.next() : null;
                    continue;
                }
                ItemVariant variant = (ItemVariant)currentView.getResource();
                long extracted = currentView.extract((Object)variant, (long)(max = (int)Math.min(contained, (long)variant.getItem().method_7882())), (TransactionContext)t);
                if (extracted == 0L) {
                    currentView = itr.hasNext() ? (StorageView)itr.next() : null;
                    continue;
                }
                class_1799 stack = variant.toStack((int)extracted);
                stacks.add(stack);
            }
            t.commit();
            ArrayList<class_1799> arrayList = stacks;
            return arrayList;
        }
    }

    public static FluidStack convertViewToFluidStack(StorageView<FluidVariant> view) {
        return new FluidStack((FluidVariant)view.getResource(), view.getAmount());
    }

    public static BlockApiCache<Storage<ItemVariant>, class_2350> getItemCache(class_1937 level, class_2338 pos) {
        if (level instanceof class_3218) {
            class_3218 server = (class_3218)level;
            return BlockApiCache.create((BlockApiLookup)ItemStorage.SIDED, (class_3218)server, (class_2338)pos);
        }
        if (level.method_8608()) {
            return ClientItemLookupCache.get(level, pos);
        }
        return EmptyItemLookupCache.INSTANCE;
    }

    public static BlockApiCache<Storage<FluidVariant>, class_2350> getFluidCache(class_1937 level, class_2338 pos) {
        if (level instanceof class_3218) {
            class_3218 server = (class_3218)level;
            return BlockApiCache.create((BlockApiLookup)FluidStorage.SIDED, (class_3218)server, (class_2338)pos);
        }
        if (level.method_8608()) {
            return ClientFluidLookupCache.get(level, pos);
        }
        return EmptyFluidLookupCache.INSTANCE;
    }

    public static void initApi() {
        FluidStorage.SIDED.registerFallback((world, pos, state, be, face) -> {
            if (be instanceof FluidTransferable) {
                FluidTransferable t = (FluidTransferable)be;
                return t.getFluidStorage((class_2350)face);
            }
            return null;
        });
        ItemStorage.SIDED.registerFallback((world, pos, state, be, face) -> {
            if (be instanceof ItemTransferable) {
                ItemTransferable t = (ItemTransferable)be;
                return t.getItemStorage((class_2350)face);
            }
            return null;
        });
    }
}

