/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabricators_of_create.porting_lib.transfer.item;

import io.github.fabricators_of_create.porting_lib.transfer.callbacks.TransactionCallback;
import io.github.fabricators_of_create.porting_lib.transfer.callbacks.TransactionSuccessCallback;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemStackHandlerIterator;
import io.github.fabricators_of_create.porting_lib.util.INBTSerializable;
import io.github.fabricators_of_create.porting_lib.util.ItemStackUtil;
import java.util.Arrays;
import java.util.Iterator;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;

public class ItemStackHandler
extends SnapshotParticipant<SnapshotData>
implements Storage<ItemVariant>,
INBTSerializable<class_2487> {
    public class_1799[] stacks;

    public ItemStackHandler() {
        this(1);
    }

    public ItemStackHandler(int stacks) {
        this.stacks = new class_1799[stacks];
        Arrays.fill(this.stacks, class_1799.field_8037);
    }

    public ItemStackHandler(class_1799[] stacks) {
        this.stacks = stacks;
    }

    public long insert(ItemVariant resource, long maxAmount, TransactionContext transaction) {
        long inserted = 0L;
        this.updateSnapshots(transaction);
        for (int i = 0; i < this.stacks.length; ++i) {
            if (this.isItemValid(i, resource)) {
                int max;
                int canInsert;
                int actuallyInsert;
                class_1799 held = this.stacks[i];
                if (held.method_7960()) {
                    int toFill = (int)Math.min((long)this.getStackLimit(i, resource), maxAmount);
                    maxAmount -= (long)toFill;
                    inserted += (long)toFill;
                    class_1799 stack = resource.toStack(toFill);
                    this.contentsChangedInternal(i, stack, transaction);
                } else if (ItemStackUtil.canItemStacksStack(held, resource.toStack()) && (actuallyInsert = Math.min(canInsert = (max = this.getStackLimit(i, resource)) - held.method_7947(), (int)maxAmount)) > 0) {
                    maxAmount -= (long)actuallyInsert;
                    inserted += (long)actuallyInsert;
                    held = held.method_7972();
                    held.method_7933(actuallyInsert);
                    this.contentsChangedInternal(i, held, transaction);
                }
            }
            if (maxAmount == 0L) break;
        }
        return inserted;
    }

    public long extract(ItemVariant resource, long maxAmount, TransactionContext transaction) {
        long extracted = 0L;
        this.updateSnapshots(transaction);
        TransactionSuccessCallback callback = new TransactionSuccessCallback(transaction);
        for (int i = 0; i < this.stacks.length; ++i) {
            class_1799 stack = this.stacks[i];
            if (!resource.matches(stack)) continue;
            int stored = stack.method_7947();
            int toRemove = (int)Math.min((long)stored, maxAmount);
            maxAmount -= (long)toRemove;
            extracted += (long)toRemove;
            stack = stack.method_7972();
            stack.method_7939(stack.method_7947() - toRemove);
            int finalI = i;
            callback.addCallback(() -> this.onContentsChanged(finalI));
            if (stack.method_7960()) {
                stack = class_1799.field_8037;
            }
            this.stacks[i] = stack;
            if (maxAmount == 0L) break;
        }
        return extracted;
    }

    protected void contentsChangedInternal(int slot, class_1799 newStack, @Nullable TransactionContext ctx) {
        this.stacks[slot] = newStack;
        if (ctx != null) {
            TransactionCallback.onSuccess(ctx, () -> this.onContentsChanged(slot));
        }
    }

    public Iterator<StorageView<ItemVariant>> iterator(TransactionContext transaction) {
        return new ItemStackHandlerIterator(this, transaction);
    }

    protected SnapshotData createSnapshot() {
        class_1799[] array = new class_1799[this.stacks.length];
        System.arraycopy(this.stacks, 0, array, 0, this.stacks.length);
        return new SnapshotData(array);
    }

    protected void readSnapshot(SnapshotData snapshot) {
        this.stacks = snapshot.stacks;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{stacks=" + Arrays.toString(this.stacks) + "}";
    }

    public int getSlots() {
        return this.stacks.length;
    }

    public void setStackInSlot(int slot, class_1799 stack) {
        this.stacks[slot] = stack;
        this.onContentsChanged(slot);
    }

    public class_1799 getStackInSlot(int slot) {
        return this.stacks[slot];
    }

    public int getSlotLimit(int slot) {
        return this.getStackInSlot(slot).method_7914();
    }

    protected int getStackLimit(int slot, ItemVariant resource) {
        return Math.min(this.getSlotLimit(slot), resource.getItem().method_7882());
    }

    public boolean isItemValid(int slot, ItemVariant resource) {
        return true;
    }

    protected void onLoad() {
    }

    protected void onContentsChanged(int slot) {
    }

    public void setSize(int size) {
        this.stacks = new class_1799[size];
        Arrays.fill(this.stacks, class_1799.field_8037);
    }

    @Override
    public class_2487 serializeNBT() {
        class_2499 nbtTagList = new class_2499();
        for (int i = 0; i < this.stacks.length; ++i) {
            class_1799 stack = this.stacks[i];
            if (stack.method_7960()) continue;
            class_2487 itemTag = new class_2487();
            itemTag.method_10569("Slot", i);
            stack.method_7953(itemTag);
            nbtTagList.add((Object)itemTag);
        }
        class_2487 nbt = new class_2487();
        nbt.method_10566("Items", (class_2520)nbtTagList);
        nbt.method_10569("Size", this.stacks.length);
        return nbt;
    }

    @Override
    public void deserializeNBT(class_2487 nbt) {
        this.setSize(nbt.method_10573("Size", 3) ? nbt.method_10550("Size") : this.stacks.length);
        class_2499 tagList = nbt.method_10554("Items", 10);
        for (int i = 0; i < tagList.size(); ++i) {
            class_2487 itemTags = tagList.method_10602(i);
            int slot = itemTags.method_10550("Slot");
            if (slot < 0 || slot >= this.stacks.length) continue;
            this.stacks[slot] = class_1799.method_7915((class_2487)itemTags);
        }
        this.onLoad();
    }

    protected void onFinalCommit() {
        super.onFinalCommit();
    }

    public static class SnapshotData {
        public final class_1799[] stacks;

        public SnapshotData(class_1799[] stacks) {
            this.stacks = stacks;
        }
    }
}

