/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabricators_of_create.porting_lib.util;

import io.github.fabricators_of_create.porting_lib.util.ServerLifecycleHooks;
import java.lang.ref.WeakReference;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_5321;

public class BlockSnapshot {
    private static final boolean DEBUG = Boolean.parseBoolean(System.getProperty("forge.debugBlockSnapshot", "false"));
    private final class_5321<class_1937> dim;
    private final class_2338 pos;
    private final int flags;
    private final class_2680 block;
    @Nullable
    private final class_2487 nbt;
    @Nullable
    private WeakReference<class_1936> level;
    private String toString = null;

    private BlockSnapshot(class_5321<class_1937> dim, class_1936 level, class_2338 pos, class_2680 state, @Nullable class_2487 nbt, int flags) {
        this.dim = dim;
        this.pos = pos.method_10062();
        this.block = state;
        this.flags = flags;
        this.nbt = nbt;
        this.level = new WeakReference<class_1936>(level);
        if (DEBUG) {
            System.out.println("Created " + this.toString());
        }
    }

    public static BlockSnapshot create(class_5321<class_1937> dim, class_1936 world, class_2338 pos) {
        return BlockSnapshot.create(dim, world, pos, 3);
    }

    public static BlockSnapshot create(class_5321<class_1937> dim, class_1936 world, class_2338 pos, int flag) {
        return new BlockSnapshot(dim, world, pos, world.method_8320(pos), BlockSnapshot.getBlockEntityTag(world.method_8321(pos)), flag);
    }

    @Nullable
    private static class_2487 getBlockEntityTag(@Nullable class_2586 te) {
        return te == null ? null : te.method_38242();
    }

    public class_2680 getCurrentBlock() {
        class_1936 world = this.getLevel();
        return world == null ? class_2246.field_10124.method_9564() : world.method_8320(this.pos);
    }

    @Nullable
    public class_1936 getLevel() {
        class_1936 world;
        class_1936 class_19362 = world = this.level != null ? (class_1936)this.level.get() : null;
        if (world == null) {
            world = ServerLifecycleHooks.getCurrentServer().method_3847(this.dim);
            this.level = new WeakReference<class_1936>(world);
        }
        return world;
    }

    public class_2680 getReplacedBlock() {
        return this.block;
    }

    @Nullable
    public class_2586 getBlockEntity() {
        return this.getTag() != null ? class_2586.method_11005((class_2338)this.getPos(), (class_2680)this.getReplacedBlock(), (class_2487)this.getTag()) : null;
    }

    public boolean restore() {
        return this.restore(false);
    }

    public boolean restore(boolean force) {
        return this.restore(force, true);
    }

    public boolean restore(boolean force, boolean notifyNeighbors) {
        return this.restoreToLocation(this.getLevel(), this.getPos(), force, notifyNeighbors);
    }

    public boolean restoreToLocation(class_1936 world, class_2338 pos, boolean force, boolean notifyNeighbors) {
        int flags;
        class_2680 current = this.getCurrentBlock();
        class_2680 replaced = this.getReplacedBlock();
        int n = flags = notifyNeighbors ? 3 : 2;
        if (current != replaced) {
            if (force) {
                world.method_8652(pos, replaced, flags);
            } else {
                return false;
            }
        }
        world.method_8652(pos, replaced, flags);
        if (world instanceof class_1937) {
            ((class_1937)world).method_8413(pos, current, replaced, flags);
        }
        class_2586 te = null;
        if (this.getTag() != null && (te = world.method_8321(pos)) != null) {
            te.method_11014(this.getTag());
            te.method_5431();
        }
        if (DEBUG) {
            System.out.println("Restored " + this.toString());
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BlockSnapshot other = (BlockSnapshot)obj;
        return this.dim.equals(other.dim) && this.pos.equals((Object)other.pos) && this.block == other.block && this.flags == other.flags && Objects.equals(this.nbt, other.nbt);
    }

    public int hashCode() {
        int hash = 7;
        hash = 73 * hash + this.dim.hashCode();
        hash = 73 * hash + this.pos.hashCode();
        hash = 73 * hash + this.block.hashCode();
        hash = 73 * hash + this.flags;
        hash = 73 * hash + Objects.hashCode(this.getTag());
        return hash;
    }

    public String toString() {
        if (this.toString == null) {
            this.toString = "BlockSnapshot[World:" + this.dim.method_29177() + ",Pos: " + this.pos + ",State: " + this.block + ",Flags: " + this.flags + ",NBT: " + (this.nbt == null ? "null" : this.nbt.toString()) + "]";
        }
        return this.toString;
    }

    public class_2338 getPos() {
        return this.pos;
    }

    public int getFlag() {
        return this.flags;
    }

    @Nullable
    public class_2487 getTag() {
        return this.nbt;
    }
}

