/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabricators_of_create.porting_lib.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.Optional;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributes;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3609;
import net.minecraft.class_3611;
import org.jetbrains.annotations.Nullable;

public class FluidStack {
    public static final Codec<FluidStack> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2378.field_11154.method_39673().fieldOf("FluidName").forGetter(FluidStack::getFluid), (App)Codec.LONG.fieldOf("Amount").forGetter(FluidStack::getAmount), (App)class_2487.field_25128.optionalFieldOf("VariantTag", null).forGetter(fluidStack -> fluidStack.getType().copyNbt()), (App)class_2487.field_25128.optionalFieldOf("Tag").forGetter(stack -> Optional.ofNullable(stack.getTag()))).apply((Applicative)instance, (fluid, amount, variantTag, tag) -> {
        FluidStack stack = new FluidStack((class_3611)fluid, (long)amount, (class_2487)variantTag);
        tag.ifPresent(stack::setTag);
        return stack;
    }));
    public static final FluidStack EMPTY = new FluidStack(FluidVariant.blank(), 0L){

        @Override
        public FluidStack setAmount(long amount) {
            return this;
        }

        @Override
        public void shrink(int amount) {
        }

        @Override
        public void shrink(long amount) {
        }

        @Override
        public void grow(long amount) {
        }

        @Override
        public void setTag(class_2487 tag) {
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public FluidStack copy() {
            return this;
        }
    };
    private final FluidVariant type;
    @Nullable
    private class_2487 tag;
    private long amount;

    public FluidStack(FluidVariant type, long amount) {
        this.type = type;
        this.amount = amount;
        this.tag = type.copyNbt();
    }

    public FluidStack(FluidVariant type, long amount, @Nullable class_2487 tag) {
        this(type, amount);
        this.tag = tag;
    }

    public FluidStack(StorageView<FluidVariant> view) {
        this((FluidVariant)view.getResource(), view.getAmount());
    }

    public FluidStack(class_3611 type, long amount) {
        class_3611 class_36112;
        if (type instanceof class_3609) {
            class_3609 flowing = (class_3609)type;
            class_36112 = flowing.method_15751();
        } else {
            class_36112 = type;
        }
        this(FluidVariant.of((class_3611)class_36112), amount);
    }

    public FluidStack(class_3611 type, long amount, @Nullable class_2487 nbt) {
        class_3611 class_36112;
        if (type instanceof class_3609) {
            class_3609 flowing = (class_3609)type;
            class_36112 = flowing.method_15751();
        } else {
            class_36112 = type;
        }
        this(FluidVariant.of((class_3611)class_36112, (class_2487)nbt), amount);
        this.tag = nbt;
    }

    public FluidStack(FluidStack copy, long amount) {
        this(copy.getType(), amount);
        if (copy.hasTag()) {
            this.tag = copy.getTag().method_10553();
        }
    }

    public FluidStack setAmount(long amount) {
        this.amount = amount;
        return this;
    }

    public void grow(long amount) {
        this.setAmount(this.getAmount() + amount);
    }

    public FluidVariant getType() {
        return this.type;
    }

    public class_3611 getFluid() {
        return this.getType().getFluid();
    }

    public long getAmount() {
        return this.amount;
    }

    public boolean isEmpty() {
        return this.amount <= 0L || this.getType().isBlank();
    }

    public void shrink(int amount) {
        this.setAmount(this.getAmount() - (long)amount);
    }

    public void shrink(long amount) {
        this.setAmount(this.getAmount() - amount);
    }

    public boolean isFluidEqual(FluidStack other) {
        if (this == other) {
            return true;
        }
        return this.isFluidEqual(other.getType());
    }

    public boolean isFluidEqual(FluidVariant other) {
        if (this.getType() == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        FluidVariant mine = this.getType();
        boolean fluidsEqual = mine.isOf((Object)other.getFluid());
        class_2487 myTag = mine.getNbt();
        class_2487 theirTag = other.getNbt();
        boolean tagsEqual = Objects.equals(myTag, theirTag);
        return fluidsEqual && tagsEqual;
    }

    public boolean canFill(FluidVariant var) {
        return this.isEmpty() || var.isOf((Object)this.getFluid()) && Objects.equals(var.getNbt(), this.getType().getNbt());
    }

    public class_2487 writeToNBT(class_2487 nbt) {
        nbt.method_10566("Variant", (class_2520)this.getType().toNbt());
        nbt.method_10544("Amount", this.getAmount());
        if (this.tag != null) {
            nbt.method_10566("Tag", (class_2520)this.tag);
        }
        return nbt;
    }

    public static FluidStack loadFluidStackFromNBT(class_2487 tag) {
        FluidStack stack;
        if (tag.method_10545("FluidName")) {
            class_3611 fluid = (class_3611)class_2378.field_11154.method_10223(new class_2960(tag.method_10558("FluidName")));
            int amount = tag.method_10550("Amount");
            stack = tag.method_10545("Tag") ? new FluidStack(fluid, (long)amount, tag.method_10562("Tag")) : new FluidStack(fluid, (long)amount);
        } else {
            class_2487 fluidTag = tag.method_10562("Variant");
            FluidVariant fluid = FluidVariant.fromNbt((class_2487)fluidTag);
            stack = new FluidStack(fluid, tag.method_10537("Amount"));
            if (tag.method_10573("Tag", 10)) {
                stack.tag = tag.method_10562("Tag");
            }
        }
        return stack;
    }

    public void setTag(class_2487 tag) {
        this.tag = tag;
    }

    @Nullable
    public class_2487 getTag() {
        return this.tag;
    }

    public class_2487 getOrCreateTag() {
        if (this.tag == null) {
            this.tag = new class_2487();
        }
        return this.tag;
    }

    public void removeChildTag(String key) {
        if (this.getTag() == null) {
            return;
        }
        this.getTag().method_10551(key);
    }

    public class_2561 getDisplayName() {
        return FluidVariantAttributes.getName((FluidVariant)this.type);
    }

    public boolean hasTag() {
        return this.tag != null;
    }

    public static FluidStack fromBuffer(class_2540 buffer) {
        FluidVariant fluid = FluidVariant.fromPacket((class_2540)buffer);
        long amount = buffer.method_10792();
        class_2487 tag = buffer.method_10798();
        if (fluid.isBlank()) {
            return EMPTY;
        }
        return new FluidStack(fluid, amount, tag);
    }

    public class_2540 toBuffer(class_2540 buffer) {
        return FluidStack.toBuffer(this, buffer);
    }

    public static class_2540 toBuffer(FluidStack stack, class_2540 buffer) {
        stack.getType().toPacket(buffer);
        buffer.method_10791(stack.getAmount());
        buffer.method_10794(stack.tag);
        return buffer;
    }

    public FluidStack copy() {
        class_2487 tag = this.getTag();
        if (tag != null) {
            tag = tag.method_10553();
        }
        return new FluidStack(this.getType(), this.getAmount(), tag);
    }
}

