/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabricators_of_create.porting_lib.util;

import com.google.common.base.Joiner;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_2960;
import net.minecraft.class_3255;
import net.minecraft.class_3264;

public class PathResourcePack
extends class_3255 {
    private final Path source;
    private final String packName;

    public PathResourcePack(String packName, Path source) {
        super(new File("dummy"));
        this.source = source;
        this.packName = packName;
    }

    public Path getSource() {
        return this.source;
    }

    public String method_14409() {
        return this.packName;
    }

    protected Path resolve(String ... paths) {
        Path path = this.getSource();
        for (String name : paths) {
            path = path.resolve(name);
        }
        return path;
    }

    protected InputStream method_14391(String name) throws IOException {
        Path path = this.resolve(name);
        if (!Files.exists(path, new LinkOption[0])) {
            throw new FileNotFoundException("Can't find resource " + name + " at " + this.getSource());
        }
        return Files.newInputStream(path, StandardOpenOption.READ);
    }

    protected boolean method_14393(String name) {
        Path path = this.resolve(name);
        return Files.exists(path, new LinkOption[0]);
    }

    public Collection<class_2960> method_14408(class_3264 type, String resourceNamespace, String pathIn, int maxDepth, Predicate<String> filter) {
        try {
            Path root = this.resolve(type.method_14413(), resourceNamespace).toAbsolutePath();
            Path inputPath = root.getFileSystem().getPath(pathIn, new String[0]);
            return Files.walk(root, new FileVisitOption[0]).map(root::relativize).filter(path -> path.getNameCount() <= maxDepth && !path.toString().endsWith(".mcmeta") && path.startsWith(inputPath)).filter(path -> filter.test(path.getFileName().toString())).map(path -> new class_2960(resourceNamespace, Joiner.on((char)'/').join((Iterable)path))).collect(Collectors.toList());
        }
        catch (IOException e) {
            return Collections.emptyList();
        }
    }

    public Set<String> method_14406(class_3264 type) {
        try {
            Path root = this.resolve(type.method_14413());
            return Files.walk(root, 1, new FileVisitOption[0]).map(path -> root.relativize((Path)path)).filter(path -> path.getNameCount() > 0).map(p -> p.toString().replaceAll("/$", "")).filter(s -> !s.isEmpty()).collect(Collectors.toSet());
        }
        catch (IOException e) {
            if (type == class_3264.field_14190) {
                return this.method_14406(class_3264.field_14188);
            }
            return Collections.emptySet();
        }
    }

    public InputStream method_14405(class_3264 type, class_2960 location) throws IOException {
        if (location.method_12832().startsWith("lang/")) {
            return super.method_14405(class_3264.field_14188, location);
        }
        return super.method_14405(type, location);
    }

    public boolean method_14411(class_3264 type, class_2960 location) {
        if (location.method_12832().startsWith("lang/")) {
            return super.method_14411(class_3264.field_14188, location);
        }
        return super.method_14411(type, location);
    }

    public void close() {
    }

    public String toString() {
        return String.format("%s: %s", ((Object)((Object)this)).getClass().getName(), this.getSource());
    }
}

