/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterdungeons.world;

import java.lang.ref.WeakReference;

public class DungeonContext {
    private static final ThreadLocal<DungeonContext> CONTEXT = new ThreadLocal();
    private WeakReference<Integer> bannerCount = new WeakReference<Integer>(0);
    private WeakReference<Integer> chestCount = new WeakReference<Integer>(0);

    public int getBannerCount() {
        Integer value = (Integer)this.bannerCount.get();
        return value == null ? 0 : value;
    }

    public int getChestCount() {
        Integer value = (Integer)this.chestCount.get();
        return value == null ? 0 : value;
    }

    public void incrementBannerCount() {
        Integer boxedVal = (Integer)this.bannerCount.get();
        int val = boxedVal == null ? 0 : boxedVal;
        this.bannerCount.clear();
        this.bannerCount = new WeakReference<Integer>(val + 1);
    }

    public void incrementChestCount() {
        Integer boxedVal = (Integer)this.chestCount.get();
        int val = boxedVal == null ? 0 : boxedVal;
        this.chestCount.clear();
        this.chestCount = new WeakReference<Integer>(val + 1);
    }

    public static DungeonContext pop() {
        DungeonContext context = CONTEXT.get();
        CONTEXT.set(null);
        return context;
    }

    public static DungeonContext peek() {
        return CONTEXT.get();
    }

    public static void initialize() {
        CONTEXT.set(new DungeonContext());
    }
}

