/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.errornotifier.launch;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.IntConsumer;
import me.shedaniel.errornotifier.ErrorNotifier;
import me.shedaniel.errornotifier.launch.EarlyGraphics;
import me.shedaniel.errornotifier.launch.EarlyTimer;
import me.shedaniel.errornotifier.launch.EarlyWindowRenderer;
import me.shedaniel.errornotifier.launch.render.EarlyRenderingStates;
import me.shedaniel.errornotifier.launch.render.math.Matrix4f;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWErrorCallback;
import org.lwjgl.glfw.GLFWVidMode;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;

public class EarlyWindow {
    public static final Logger LOGGER = LogManager.getLogger(EarlyWindow.class);
    public static long window;
    public static int width;
    public static int height;
    public static int framebufferWidth;
    public static int framebufferHeight;
    private static int x;
    private static int y;
    private static double mouseX;
    private static double mouseY;
    public static double scale;
    public static int defaultGuiScale;
    public static boolean fullscreen;
    public static boolean running;
    public static boolean hasRendered;
    public static Lock lock;
    public static boolean hasRender;
    public static EarlyTimer timer;

    private static void initDimensions(@Nullable Boolean fullscreen, String[] args) {
        width = 854;
        height = 480;
        EarlyWindow.fullscreen = BooleanUtils.isTrue((Boolean)fullscreen);
        try {
            int i = 0;
            for (String s : args) {
                if (i == 1) {
                    try {
                        width = Integer.parseInt(s);
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else if (i == 2) {
                    try {
                        height = Integer.parseInt(s);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                i = 0;
                if ("--width".equals(s)) {
                    i = 1;
                    continue;
                }
                if ("--height".equals(s)) {
                    i = 2;
                    continue;
                }
                if (!"--fullscreen".equals(s)) continue;
                EarlyWindow.fullscreen = true;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static Boolean getDefaultFullscreen(Path gameDir) {
        Path path = gameDir.resolve("options.txt");
        if (Files.exists(path, new LinkOption[0])) {
            try {
                for (String line : Files.readAllLines(path)) {
                    if (!line.trim().startsWith("fullscreen:")) continue;
                    return Boolean.parseBoolean(line.substring(line.indexOf(58) + 1).trim());
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static Double getDefaultGuiScale(Path gameDir) {
        Path path = gameDir.resolve("options.txt");
        if (Files.exists(path, new LinkOption[0])) {
            try {
                for (String line : Files.readAllLines(path)) {
                    if (!line.trim().startsWith("guiScale:")) continue;
                    return Double.parseDouble(line.substring(line.indexOf(58) + 1).trim());
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static void start(String[] args, Path gameDir, @Nullable String mcVersion, EarlyWindowRenderer renderer) {
        ArrayList list = Lists.newArrayList();
        GLFWErrorCallback errorCallback = GLFW.glfwSetErrorCallback((i, l) -> list.add(String.format("GLFW error during init: [0x%X]%s", i, l)));
        if (!GLFW.glfwInit()) {
            throw new IllegalStateException("Failed to initialize GLFW, errors: " + Joiner.on((String)",").join((Iterable)list));
        }
        for (String string : list) {
            LOGGER.error("GLFW error collected during initialization: {}", (Object)string);
        }
        if (errorCallback != null) {
            errorCallback.close();
        }
        Boolean defaultFullscreen = EarlyWindow.getDefaultFullscreen(gameDir);
        defaultGuiScale = Objects.requireNonNullElse(EarlyWindow.getDefaultGuiScale(gameDir), 0.0).intValue();
        GLFWErrorCallback.createPrint((PrintStream)System.err).set();
        long monitor = GLFW.glfwGetPrimaryMonitor();
        GLFW.glfwDefaultWindowHints();
        GLFW.glfwWindowHint((int)139265, (int)196609);
        GLFW.glfwWindowHint((int)139275, (int)221185);
        GLFW.glfwWindowHint((int)139266, (int)3);
        GLFW.glfwWindowHint((int)139267, (int)2);
        GLFW.glfwWindowHint((int)139270, (int)1);
        GLFW.glfwWindowHint((int)139272, (int)204801);
        GLFW.glfwWindowHint((int)131076, (int)1);
        EarlyWindow.initDimensions(defaultFullscreen, args);
        if (fullscreen) {
            GLFWVidMode vidMode = GLFW.glfwGetVideoMode((long)monitor);
            width = vidMode.width();
            height = vidMode.height();
        }
        if ((window = GLFW.glfwCreateWindow((int)width, (int)height, (CharSequence)("Minecraft* " + mcVersion), (long)(fullscreen ? monitor : 0L), (long)0L)) == 0L) {
            throw new IllegalStateException("Failed to create the GLFW window");
        }
        if (!fullscreen) {
            if (monitor == 0L) {
                int[] ax = new int[1];
                int[] ay = new int[1];
                GLFW.glfwGetWindowPos((long)window, (int[])ax, (int[])ay);
                EarlyWindow.x = ax[0];
                EarlyWindow.y = ay[0];
            } else {
                int[] monitorXA = new int[1];
                int[] monitorYA = new int[1];
                GLFW.glfwGetMonitorPos((long)monitor, (int[])monitorXA, (int[])monitorYA);
                GLFWVidMode vidMode = GLFW.glfwGetVideoMode((long)monitor);
                int monitorX = monitorXA[0];
                int monitorY = monitorYA[0];
                EarlyWindow.x = monitorX + vidMode.width() / 2 - width / 2;
                EarlyWindow.y = monitorY + vidMode.height() / 2 - height / 2;
            }
        }
        GLFW.glfwMakeContextCurrent((long)window);
        GL.createCapabilities();
        EarlyWindow.setMode(monitor);
        EarlyWindow.refreshFramebufferSize();
        scale = EarlyWindow.calculateScale(defaultGuiScale, false);
        GLFW.glfwSetFramebufferSizeCallback((long)window, EarlyWindow::framebufferResize);
        GLFW.glfwSetWindowPosCallback((long)window, EarlyWindow::windowMove);
        GLFW.glfwSetWindowSizeCallback((long)window, EarlyWindow::windowResize);
        GLFW.glfwSetWindowFocusCallback((long)window, (win, focused) -> {});
        GLFW.glfwSetCursorEnterCallback((long)window, (win, entered) -> {});
        GLFW.glfwSetWindowCloseCallback((long)window, win -> System.exit(1));
        GLFW.glfwSetCursorPosCallback((long)window, (win, x, y) -> {
            mouseX = x / scale;
            mouseY = y / scale;
        });
        GLFW.glfwSetMouseButtonCallback((long)window, (win, but, action, mods) -> {
            if (action == 1) {
                renderer.mouseClicked(mouseX, mouseY, but);
            }
        });
        GL11.glClearColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        while (running) {
            try {
                if (hasRender) {
                    EarlyWindow.renderWindow(renderer);
                }
                hasRendered = true;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private static void renderWindow(EarlyWindowRenderer renderer) {
        GL11.glClear((int)16640);
        if (ErrorNotifier.isMac()) {
            GL11.glGetError();
        }
        GL11.glViewport((int)0, (int)0, (int)width, (int)height);
        EarlyRenderingStates.projectionMatrix.setIdentity();
        EarlyRenderingStates.projectionMatrix = Matrix4f.orthographic(0.0f, (float)((double)width / scale), 0.0f, (float)((double)height / scale), 1000.0f, 3000.0f);
        EarlyRenderingStates.modelViewMatrix.setIdentity();
        EarlyRenderingStates.modelViewMatrix.translate(0.0f, 0.0f, -2000.0f);
        EarlyWindow.render(renderer);
        GLFW.glfwPollEvents();
        GLFW.glfwSwapBuffers((long)window);
    }

    private static void render(EarlyWindowRenderer renderer) {
        EarlyGraphics graphics = EarlyGraphics.INSTANCE;
        timer.advanceTime(System.currentTimeMillis());
        renderer.render(graphics, mouseX, mouseY, EarlyWindow.timer.tickDelta);
        EarlyRenderingStates.modelViewMatrix.translate(0.0f, 0.0f, 10.0f);
    }

    public static void setMode(long monitor) {
        boolean valid;
        if (monitor == 0L) {
            monitor = GLFW.glfwGetWindowMonitor((long)window);
        }
        boolean bl = valid = monitor != 0L;
        if (fullscreen) {
            if (!valid) {
                LOGGER.warn("Failed to find suitable monitor for fullscreen mode");
                fullscreen = false;
            } else {
                if (ErrorNotifier.isMac()) {
                    try {
                        Class.forName("me.shedaniel.errornotifier.launch.EarlyWindowMacOS").getDeclaredMethod("toggleMacOSFullscreen", Long.TYPE).invoke(null, window);
                    }
                    catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                        throw new RuntimeException(e);
                    }
                }
                GLFWVidMode videoMode = GLFW.glfwGetVideoMode((long)monitor);
                x = 0;
                y = 0;
                width = videoMode.width();
                height = videoMode.height();
                GLFW.glfwSetWindowMonitor((long)window, (long)monitor, (int)x, (int)y, (int)width, (int)height, (int)videoMode.refreshRate());
            }
        } else {
            GLFW.glfwSetWindowMonitor((long)window, (long)0L, (int)x, (int)y, (int)width, (int)height, (int)-1);
        }
    }

    public static void refreshFramebufferSize() {
        int[] aw = new int[1];
        int[] ah = new int[1];
        GLFW.glfwGetFramebufferSize((long)window, (int[])aw, (int[])ah);
        framebufferWidth = aw[0] > 0 ? aw[0] : 1;
        framebufferHeight = ah[0] > 0 ? ah[0] : 1;
    }

    public static int calculateScale(int scale, boolean bl) {
        int j;
        for (j = 1; j != scale && j < framebufferWidth && j < framebufferHeight && framebufferWidth / (j + 1) >= 320 && framebufferHeight / (j + 1) >= 240; ++j) {
        }
        if (bl && j % 2 != 0) {
            ++j;
        }
        return j;
    }

    public static void updateFBSize(IntConsumer width, IntConsumer height) {
    }

    public static void framebufferResize(long win, int w, int h) {
        framebufferWidth = w;
        framebufferHeight = h;
        scale = EarlyWindow.calculateScale(defaultGuiScale, false);
    }

    public static void framebufferResizeWithScale(double scale, int w, int h) {
        framebufferWidth = w;
        framebufferHeight = h;
        EarlyWindow.scale = scale;
    }

    public static void windowMove(long win, int xpos, int ypos) {
        x = xpos;
        y = ypos;
    }

    public static void windowResize(long win, int w, int h) {
        width = w;
        height = h;
    }

    static {
        running = true;
        hasRendered = false;
        lock = new ReentrantLock();
        hasRender = true;
        timer = new EarlyTimer(20.0f, 0L);
    }
}

