/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.errornotifier.launch.early;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.opengl.GL11;
import org.lwjgl.stb.STBIWriteCallback;
import org.lwjgl.stb.STBImage;
import org.lwjgl.stb.STBImageWrite;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class Image
implements Closeable {
    public static final Logger LOGGER = LogManager.getLogger(Image.class);
    public int width;
    public int height;
    public int channels;
    public long pixels;

    public Image(int width, int height) {
        this(width, height, 4);
    }

    public Image(int width, int height, int channels) {
        this(width, height, channels, MemoryUtil.nmemAlloc((long)((long)width * (long)height * (long)channels)));
    }

    public Image(int width, int height, int channels, long pixels) {
        this.width = width;
        this.height = height;
        this.channels = channels;
        this.pixels = pixels;
    }

    @Override
    public void close() {
        if (this.pixels != 0L) {
            MemoryUtil.nmemFree((long)this.pixels);
        }
        this.pixels = 0L;
    }

    public static void prepareImage(int id, int level, int width, int height, int glFormat) {
        GL11.glBindTexture((int)3553, (int)id);
        if (level >= 0) {
            GL11.glTexParameteri((int)3553, (int)33085, (int)level);
            GL11.glTexParameteri((int)3553, (int)33082, (int)0);
            GL11.glTexParameteri((int)3553, (int)33083, (int)level);
            GL11.glTexParameterf((int)3553, (int)34049, (float)0.0f);
        }
        for (int i = 0; i <= level; ++i) {
            GL11.glTexImage2D((int)3553, (int)i, (int)glFormat, (int)(width >> i), (int)(height >> i), (int)0, (int)6408, (int)5121, (IntBuffer)null);
        }
    }

    private static void setFilter(boolean blur, boolean mipmap) {
        if (blur) {
            GL11.glTexParameteri((int)3553, (int)10241, (int)(mipmap ? 9987 : 9729));
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        } else {
            GL11.glTexParameteri((int)3553, (int)10241, (int)(mipmap ? 9986 : 9728));
            GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        }
    }

    public void upload(int id, boolean blur, boolean wrap) {
        this.upload(id, 0, 0, 0, 0, 0, this.width, this.height, blur, wrap, false, false);
    }

    public void upload(int id, int level, int xOffset, int yOffset, boolean close) {
        this.upload(id, level, xOffset, yOffset, 0, 0, this.width, this.height, false, close);
    }

    public void upload(int id, int level, int xOffset, int yOffset, int skipPixels, int skipRows, int width, int height, boolean mipmap, boolean close) {
        this.upload(id, level, xOffset, yOffset, skipPixels, skipRows, width, height, false, false, mipmap, close);
    }

    public void upload(int id, int level, int xOffset, int yOffset, int skipPixels, int skipRows, int width, int height, boolean blur, boolean wrap, boolean mipmap, boolean close) {
        Image.prepareImage(id, 0, width, height, this.getGlFormat());
        Image.setFilter(blur, mipmap);
        if (width == width) {
            GL11.glPixelStorei((int)3314, (int)0);
        } else {
            GL11.glPixelStorei((int)3314, (int)width);
        }
        GL11.glPixelStorei((int)3316, (int)skipPixels);
        GL11.glPixelStorei((int)3315, (int)skipRows);
        GL11.glPixelStorei((int)3317, (int)this.channels);
        GL11.glTexSubImage2D((int)3553, (int)level, (int)xOffset, (int)yOffset, (int)width, (int)height, (int)this.getGlFormat(), (int)5121, (long)this.pixels);
        if (wrap) {
            GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
            GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
        }
        if (close) {
            this.close();
        }
    }

    public int getGlFormat() {
        return this.channels == 2 ? 33319 : 6408;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeToChannel(WritableByteChannel writableByteChannel) throws IOException {
        boolean var4;
        class WriteCallback
        extends STBIWriteCallback {
            private final WritableByteChannel output;
            @Nullable
            private IOException exception;

            WriteCallback(WritableByteChannel writableByteChannel) {
                this.output = writableByteChannel;
            }

            public void invoke(long l, long m, int i) {
                ByteBuffer byteBuffer = WriteCallback.getData((long)m, (int)i);
                try {
                    this.output.write(byteBuffer);
                }
                catch (IOException var8) {
                    this.exception = var8;
                }
            }

            public void throwIfException() throws IOException {
                if (this.exception != null) {
                    throw this.exception;
                }
            }
        }
        WriteCallback writeCallback = new WriteCallback(writableByteChannel);
        try {
            int height = Math.min(this.height, Integer.MAX_VALUE / this.width / this.channels);
            if (height < this.height) {
                LOGGER.warn("Dropping image height from {} to {} to fit the size into 32-bit signed int", (Object)this.height, (Object)height);
            }
            if (STBImageWrite.nstbi_write_png_to_func((long)writeCallback.address(), (long)0L, (int)this.width, (int)height, (int)this.channels, (long)this.pixels, (int)0) == 0) {
                boolean var42;
                boolean bl = var42 = false;
                return bl;
            }
            writeCallback.throwIfException();
            var4 = true;
        }
        finally {
            writeCallback.free();
        }
        return var4;
    }

    public void writeToFile(Path path) throws IOException {
        try (SeekableByteChannel channel = Files.newByteChannel(path, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
            if (!this.writeToChannel(channel)) {
                throw new IOException("Could not write image to the PNG file \"" + path.normalize().toAbsolutePath() + "\": " + STBImage.stbi_failure_reason());
            }
        }
    }

    public static Image load(InputStream stream) throws IOException {
        ByteBuffer buffer = MemoryUtil.memAlloc((int)8192);
        try {
            Image image;
            block11: {
                MemoryStack memoryStack = MemoryStack.stackPush();
                try {
                    IntBuffer width = memoryStack.mallocInt(1);
                    IntBuffer height = memoryStack.mallocInt(1);
                    IntBuffer channels = memoryStack.mallocInt(1);
                    ReadableByteChannel byteChannel = Channels.newChannel(stream);
                    while (byteChannel.read(buffer) != -1) {
                        if (buffer.remaining() != 0) continue;
                        ByteBuffer newBuffer = MemoryUtil.memRealloc((ByteBuffer)buffer, (int)(buffer.capacity() * 2));
                        if (buffer == null || MemoryUtil.memAddress((ByteBuffer)newBuffer) == MemoryUtil.memAddress((ByteBuffer)buffer)) continue;
                        MemoryUtil.memFree((Buffer)buffer);
                        buffer = newBuffer;
                    }
                    buffer.rewind();
                    ByteBuffer byteBuffer2 = STBImage.stbi_load_from_memory((ByteBuffer)buffer, (IntBuffer)width, (IntBuffer)height, (IntBuffer)channels, (int)4);
                    if (byteBuffer2 == null) {
                        throw new IOException("Could not load image: " + STBImage.stbi_failure_reason());
                    }
                    image = new Image(width.get(0), height.get(0), 4, MemoryUtil.memAddress((ByteBuffer)byteBuffer2));
                    if (memoryStack == null) break block11;
                }
                catch (Throwable throwable) {
                    if (memoryStack != null) {
                        try {
                            memoryStack.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                memoryStack.close();
            }
            return image;
        }
        finally {
            MemoryUtil.memFree((Buffer)buffer);
        }
    }

    public boolean supportsLuminance() {
        return this.channels == 2;
    }

    public byte getLuminanceOrAlpha(long x, long y) {
        return this.supportsLuminance() ? this.getLuminance(x, y) : this.getAlpha(x, y);
    }

    public byte getAlpha(long x, long y) {
        long offset = (x + y * (long)this.width) * (long)this.channels + (long)((this.channels == 2 ? 8 : 24) / 8);
        return MemoryUtil.memGetByte((long)(this.pixels + offset));
    }

    public byte getLuminance(long x, long y) {
        if (!this.supportsLuminance()) {
            throw new IllegalStateException("Image does not support luminance: " + this.channels);
        }
        long offset = (x + y * (long)this.width) * (long)this.channels;
        return MemoryUtil.memGetByte((long)(this.pixels + offset));
    }

    public int getPixelRGBA(long x, long y) {
        long offset = (x + y * (long)this.width) * (long)this.channels;
        return MemoryUtil.memGetInt((long)(this.pixels + offset));
    }

    public void setPixelRGBA(long x, long y, int color) {
        long offset = (x + y * (long)this.width) * (long)this.channels;
        MemoryUtil.memPutInt((long)(this.pixels + offset), (int)color);
    }
}

