/*
 * Decompiled with CFR 0.152.
 */
package lain.mods.skins.impl;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.mojang.authlib.GameProfile;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import lain.mods.skins.api.interfaces.IPlayerProfile;
import lain.mods.skins.impl.MojangService;
import lain.mods.skins.impl.Shared;

public class PlayerProfile
implements IPlayerProfile {
    private static final PlayerProfile DUMMY = new PlayerProfile(Shared.DUMMY);
    private static final LoadingCache<GameProfile, PlayerProfile> profiles = CacheBuilder.newBuilder().weakKeys().refreshAfterWrite(10L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<GameProfile, PlayerProfile>(){

        public PlayerProfile load(final GameProfile key) throws Exception {
            if (key.getProperties() == null || key == Shared.DUMMY) {
                return DUMMY;
            }
            final PlayerProfile profile = new PlayerProfile(key);
            if (Shared.isBlank(key.getName())) {
                if (key.getId() != null) {
                    Futures.addCallback(MojangService.fillProfile(key), (FutureCallback)new FutureCallback<GameProfile>(){

                        public void onFailure(Throwable t) {
                        }

                        public void onSuccess(GameProfile filled) {
                            if (filled == key) {
                                return;
                            }
                            profile.set(filled);
                        }
                    }, Runnable::run);
                }
            } else if (Shared.isOfflinePlayer(key.getId(), key.getName())) {
                Futures.addCallback(MojangService.getProfile(key.getName()), (FutureCallback)new FutureCallback<GameProfile>(){

                    public void onFailure(Throwable t) {
                    }

                    public void onSuccess(final GameProfile resolved) {
                        if (resolved == Shared.DUMMY) {
                            return;
                        }
                        profile.set(resolved);
                        Futures.addCallback(MojangService.fillProfile(resolved), (FutureCallback)new FutureCallback<GameProfile>(){

                            public void onFailure(Throwable t) {
                            }

                            public void onSuccess(GameProfile filled) {
                                if (filled == resolved) {
                                    return;
                                }
                                profile.set(filled);
                            }
                        }, Runnable::run);
                    }
                }, Runnable::run);
            } else if (key.getProperties().isEmpty()) {
                Futures.addCallback(MojangService.fillProfile(key), (FutureCallback)new FutureCallback<GameProfile>(){

                    public void onFailure(Throwable t) {
                    }

                    public void onSuccess(GameProfile filled) {
                        if (filled != key) {
                            profile.set(filled);
                            return;
                        }
                        Futures.addCallback(MojangService.getProfile(key.getName()), (FutureCallback)new FutureCallback<GameProfile>(){

                            public void onFailure(Throwable t) {
                            }

                            public void onSuccess(final GameProfile resolved) {
                                if (resolved == Shared.DUMMY) {
                                    return;
                                }
                                profile.set(resolved);
                                Futures.addCallback(MojangService.fillProfile(resolved), (FutureCallback)new FutureCallback<GameProfile>(){

                                    public void onFailure(Throwable t) {
                                    }

                                    public void onSuccess(GameProfile filled) {
                                        if (filled == resolved) {
                                            return;
                                        }
                                        profile.set(filled);
                                    }
                                }, Runnable::run);
                            }
                        }, Runnable::run);
                    }
                }, Runnable::run);
            }
            return profile;
        }

        public ListenableFuture<PlayerProfile> reload(GameProfile key, PlayerProfile oldValue) throws Exception {
            if (oldValue == DUMMY) {
                return Futures.immediateFuture((Object)DUMMY);
            }
            return Shared.submitTask(() -> {
                PlayerProfile newValue = this.load(key);
                if (oldValue.getOriginal() != newValue.getOriginal()) {
                    oldValue.set(newValue.getOriginal());
                }
                return newValue;
            });
        }
    });
    private final Collection<Consumer<IPlayerProfile>> _listeners = new CopyOnWriteArrayList<Consumer<IPlayerProfile>>();
    private WeakReference<GameProfile> _profile;

    private PlayerProfile(GameProfile profile) {
        if (profile == null) {
            throw new IllegalArgumentException("profile must not be null");
        }
        this._profile = new WeakReference<GameProfile>(profile);
    }

    public static PlayerProfile wrapGameProfile(GameProfile profile) {
        if (profile == null) {
            return DUMMY;
        }
        return (PlayerProfile)profiles.getUnchecked((Object)profile);
    }

    public boolean equals(Object o) {
        GameProfile p = (GameProfile)this._profile.get();
        if (p == null) {
            return false;
        }
        if (o instanceof PlayerProfile) {
            return p.equals(((PlayerProfile)o)._profile.get());
        }
        return false;
    }

    public GameProfile getOriginal() {
        GameProfile p = (GameProfile)this._profile.get();
        if (p == null) {
            return Shared.DUMMY;
        }
        return p;
    }

    @Override
    public UUID getPlayerID() {
        GameProfile p = (GameProfile)this._profile.get();
        if (p == null) {
            return Shared.DUMMY.getId();
        }
        return p.getId();
    }

    @Override
    public String getPlayerName() {
        GameProfile p = (GameProfile)this._profile.get();
        if (p == null) {
            return Shared.DUMMY.getName();
        }
        return p.getName();
    }

    public int hashCode() {
        GameProfile p = (GameProfile)this._profile.get();
        if (p == null) {
            return 0;
        }
        return p.hashCode();
    }

    private synchronized void set(GameProfile profile) {
        if (this == DUMMY) {
            return;
        }
        if (profile == null) {
            throw new IllegalArgumentException("profile must not be null");
        }
        this._profile = new WeakReference<GameProfile>(profile);
        for (Consumer<IPlayerProfile> l : this._listeners) {
            l.accept(this);
        }
    }

    @Override
    public boolean setUpdateListener(Consumer<IPlayerProfile> listener) {
        if (this == DUMMY) {
            return false;
        }
        if (listener == null || this._listeners.contains(listener)) {
            return false;
        }
        return this._listeners.add(listener);
    }
}

