/*
 * Decompiled with CFR 0.152.
 */
package lain.mods.skins.impl.fabric;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import lain.mods.skins.impl.SkinData;
import net.minecraft.class_1011;

public class ImageUtils {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String judgeSkinType(byte[] data) {
        try (class_1011 image = class_1011.method_4309((InputStream)new ByteArrayInputStream(data));){
            int w = image.method_4307();
            int h = image.method_4323();
            if (w == h * 2) {
                String string = "default";
                return string;
            }
            if (w == h) {
                int r = Math.max(w / 64, 1);
                if ((image.method_4315(55 * r, 20 * r) & 0xFF000000) >>> 24 == 0) {
                    String string = "slim";
                    return string;
                }
                String string = "default";
                return string;
            }
            String string = "unknown";
            return string;
        }
        catch (Throwable t) {
            return "unknown";
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static ByteBuffer legacyFilter(ByteBuffer buffer) {
        try (class_1011 input = class_1011.method_4324((ByteBuffer)buffer);){
            ByteBuffer byteBuffer;
            try (class_1011 output = new class_1011(input.method_4307(), input.method_4307(), true);){
                int r = Math.max(input.method_4307() / 64, 1);
                boolean f = input.method_4307() == input.method_4323() * 2;
                output.method_4317(input);
                if (f) {
                    output.method_4326(0 * r, 32 * r, 64 * r, 32 * r, 0);
                    output.method_4304(4 * r, 16 * r, 16 * r, 32 * r, 4 * r, 4 * r, true, false);
                    output.method_4304(8 * r, 16 * r, 16 * r, 32 * r, 4 * r, 4 * r, true, false);
                    output.method_4304(0 * r, 20 * r, 24 * r, 32 * r, 4 * r, 12 * r, true, false);
                    output.method_4304(4 * r, 20 * r, 16 * r, 32 * r, 4 * r, 12 * r, true, false);
                    output.method_4304(8 * r, 20 * r, 8 * r, 32 * r, 4 * r, 12 * r, true, false);
                    output.method_4304(12 * r, 20 * r, 16 * r, 32 * r, 4 * r, 12 * r, true, false);
                    output.method_4304(44 * r, 16 * r, -8 * r, 32 * r, 4 * r, 4 * r, true, false);
                    output.method_4304(48 * r, 16 * r, -8 * r, 32 * r, 4 * r, 4 * r, true, false);
                    output.method_4304(40 * r, 20 * r, 0 * r, 32 * r, 4 * r, 12 * r, true, false);
                    output.method_4304(44 * r, 20 * r, -8 * r, 32 * r, 4 * r, 12 * r, true, false);
                    output.method_4304(48 * r, 20 * r, -16 * r, 32 * r, 4 * r, 12 * r, true, false);
                    output.method_4304(52 * r, 20 * r, -8 * r, 32 * r, 4 * r, 12 * r, true, false);
                }
                ImageUtils.setAreaOpaque(output, 0 * r, 0 * r, 32 * r, 16 * r);
                if (f) {
                    ImageUtils.setAreaTransparent(output, 32 * r, 0 * r, 64 * r, 32 * r);
                }
                ImageUtils.setAreaOpaque(output, 0 * r, 16 * r, 64 * r, 32 * r);
                ImageUtils.setAreaOpaque(output, 16 * r, 48 * r, 48 * r, 64 * r);
                byteBuffer = SkinData.toBuffer(output.method_24036());
            }
            return byteBuffer;
        }
        catch (Throwable t) {
            return buffer;
        }
    }

    private static void setAreaOpaque(class_1011 image, int x, int y, int width, int height) {
        for (int i = x; i < width; ++i) {
            for (int j = y; j < height; ++j) {
                image.method_4305(i, j, image.method_4315(i, j) | 0xFF000000);
            }
        }
    }

    private static void setAreaTransparent(class_1011 image, int x, int y, int width, int height) {
        for (int i = x; i < width; ++i) {
            for (int j = y; j < height; ++j) {
                if ((image.method_4315(i, j) >> 24 & 0xFF) >= 128) continue;
                return;
            }
        }
        for (int l = x; l < width; ++l) {
            for (int i1 = y; i1 < height; ++i1) {
                image.method_4305(l, i1, image.method_4315(l, i1) & 0xFFFFFF);
            }
        }
    }

    public static boolean validateData(byte[] data) {
        boolean bl;
        block8: {
            class_1011 image = class_1011.method_4309((InputStream)new ByteArrayInputStream(data));
            try {
                boolean bl2 = bl = image != null;
                if (image == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (image != null) {
                        try {
                            image.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    return false;
                }
            }
            image.close();
        }
        return bl;
    }
}

