/*
 * Decompiled with CFR 0.152.
 */
package com.github.legoatoom.connectiblechains.client.render.entity;

import com.github.legoatoom.connectiblechains.ConnectibleChains;
import com.github.legoatoom.connectiblechains.chain.ChainLink;
import com.github.legoatoom.connectiblechains.chain.ChainType;
import com.github.legoatoom.connectiblechains.client.ClientInitializer;
import com.github.legoatoom.connectiblechains.client.render.entity.ChainRenderer;
import com.github.legoatoom.connectiblechains.client.render.entity.model.ChainKnotEntityModel;
import com.github.legoatoom.connectiblechains.enitity.ChainKnotEntity;
import com.github.legoatoom.connectiblechains.util.Helper;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1158;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_1297;
import net.minecraft.class_1530;
import net.minecraft.class_1657;
import net.minecraft.class_1921;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4604;
import net.minecraft.class_4608;
import net.minecraft.class_5617;
import net.minecraft.class_897;

@Environment(value=EnvType.CLIENT)
public class ChainKnotEntityRenderer
extends class_897<ChainKnotEntity> {
    private final ChainKnotEntityModel<ChainKnotEntity> model;
    private final ChainRenderer chainRenderer = new ChainRenderer();

    public ChainKnotEntityRenderer(class_5617.class_5618 context) {
        super(context);
        this.model = new ChainKnotEntityModel(context.method_32167(ClientInitializer.CHAIN_KNOT));
    }

    public ChainRenderer getChainRenderer() {
        return this.chainRenderer;
    }

    public boolean shouldRender(ChainKnotEntity entity, class_4604 frustum, double x, double y, double z) {
        if (entity.field_5985) {
            return true;
        }
        for (ChainLink link : entity.getLinks()) {
            if (link.primary != entity) continue;
            if (link.secondary instanceof class_1657) {
                return true;
            }
            if (!link.secondary.method_5727(x, y, z)) continue;
            return true;
        }
        return super.method_3933((class_1297)entity, frustum, x, y, z);
    }

    public void render(ChainKnotEntity chainKnotEntity, float yaw, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light) {
        if (chainKnotEntity.shouldRenderKnot()) {
            matrices.method_22903();
            class_243 leashOffset = chainKnotEntity.method_30951(tickDelta).method_1020(chainKnotEntity.method_30950(tickDelta));
            matrices.method_22904(leashOffset.field_1352, leashOffset.field_1351 + 0.40625, leashOffset.field_1350);
            matrices.method_22905(0.8333333f, 1.0f, 0.8333333f);
            class_4588 vertexConsumer = vertexConsumers.getBuffer(this.model.method_23500(chainKnotEntity.getChainType().getKnotTexture()));
            this.model.method_2828(matrices, vertexConsumer, light, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
            matrices.method_22909();
        }
        List<ChainLink> links = chainKnotEntity.getLinks();
        for (ChainLink link : links) {
            if (link.primary != chainKnotEntity || link.isDead()) continue;
            this.renderChainLink(link, tickDelta, matrices, vertexConsumers);
            if (!ConnectibleChains.runtimeConfig.doDebugDraw()) continue;
            this.drawDebugVector(matrices, (class_1297)chainKnotEntity, link.secondary, vertexConsumers.getBuffer((class_1921)class_1921.field_21695));
        }
        if (ConnectibleChains.runtimeConfig.doDebugDraw()) {
            matrices.method_22903();
            class_2585 holdingCount = new class_2585("F: " + chainKnotEntity.getLinks().stream().filter(l -> l.primary == chainKnotEntity).count());
            class_2585 heldCount = new class_2585("T: " + chainKnotEntity.getLinks().stream().filter(l -> l.secondary == chainKnotEntity).count());
            matrices.method_22904(0.0, 0.25, 0.0);
            this.method_3926((class_1297)chainKnotEntity, (class_2561)holdingCount, matrices, vertexConsumers, light);
            matrices.method_22904(0.0, 0.25, 0.0);
            this.method_3926((class_1297)chainKnotEntity, (class_2561)heldCount, matrices, vertexConsumers, light);
            matrices.method_22909();
        }
        super.method_3936((class_1297)chainKnotEntity, yaw, tickDelta, matrices, vertexConsumers, light);
    }

    private void renderChainLink(ChainLink link, float tickDelta, class_4587 matrices, class_4597 vertexConsumerProvider) {
        ChainKnotEntity fromEntity = link.primary;
        class_1297 toEntity = link.secondary;
        matrices.method_22903();
        class_243 srcPos = fromEntity.method_19538().method_1019(fromEntity.method_29919());
        class_243 dstPos = toEntity instanceof class_1530 ? toEntity.method_19538().method_1019(toEntity.method_29919()) : toEntity.method_30951(tickDelta);
        class_243 leashOffset = fromEntity.method_29919();
        matrices.method_22904(leashOffset.field_1352, leashOffset.field_1351, leashOffset.field_1350);
        ChainType chainType = link.chainType;
        class_4588 buffer = vertexConsumerProvider.getBuffer(class_1921.method_23578((class_2960)chainType.getChainTexture()));
        if (ConnectibleChains.runtimeConfig.doDebugDraw()) {
            buffer = vertexConsumerProvider.getBuffer(class_1921.method_23594());
        }
        class_1160 offset = Helper.getChainOffset(srcPos, dstPos);
        matrices.method_22904((double)offset.method_4943(), 0.0, (double)offset.method_4947());
        class_2338 blockPosOfStart = new class_2338(fromEntity.method_5836(tickDelta));
        class_2338 blockPosOfEnd = new class_2338(toEntity.method_5836(tickDelta));
        int blockLightLevelOfStart = fromEntity.field_6002.method_8314(class_1944.field_9282, blockPosOfStart);
        int blockLightLevelOfEnd = toEntity.field_6002.method_8314(class_1944.field_9282, blockPosOfEnd);
        int skylightLevelOfStart = fromEntity.field_6002.method_8314(class_1944.field_9284, blockPosOfStart);
        int skylightLevelOfEnd = fromEntity.field_6002.method_8314(class_1944.field_9284, blockPosOfEnd);
        class_243 startPos = srcPos.method_1031((double)offset.method_4943(), 0.0, (double)offset.method_4947());
        class_243 endPos = dstPos.method_1031((double)(-offset.method_4943()), 0.0, (double)(-offset.method_4947()));
        class_1160 chainVec = new class_1160((float)(endPos.field_1352 - startPos.field_1352), (float)(endPos.field_1351 - startPos.field_1351), (float)(endPos.field_1350 - startPos.field_1350));
        float angleY = -((float)Math.atan2(chainVec.method_4947(), chainVec.method_4943()));
        matrices.method_22907(class_1158.method_35825((float)0.0f, (float)angleY, (float)0.0f));
        if (toEntity instanceof class_1530) {
            ChainRenderer.BakeKey key = new ChainRenderer.BakeKey(fromEntity.method_19538(), toEntity.method_19538());
            this.chainRenderer.renderBaked(buffer, matrices, key, chainVec, blockLightLevelOfStart, blockLightLevelOfEnd, skylightLevelOfStart, skylightLevelOfEnd);
        } else {
            this.chainRenderer.render(buffer, matrices, chainVec, blockLightLevelOfStart, blockLightLevelOfEnd, skylightLevelOfStart, skylightLevelOfEnd);
        }
        matrices.method_22909();
    }

    private void drawDebugVector(class_4587 matrices, class_1297 fromEntity, class_1297 toEntity, class_4588 buffer) {
        if (toEntity == null) {
            return;
        }
        class_1159 modelMat = matrices.method_23760().method_23761();
        class_243 vec = toEntity.method_19538().method_1020(fromEntity.method_19538());
        class_243 normal = vec.method_1029();
        buffer.method_22918(modelMat, 0.0f, 0.0f, 0.0f).method_1336(0, 255, 0, 255).method_22914((float)normal.field_1352, (float)normal.field_1351, (float)normal.field_1350).method_1344();
        buffer.method_22918(modelMat, (float)vec.field_1352, (float)vec.field_1351, (float)vec.field_1350).method_1336(255, 0, 0, 255).method_22914((float)normal.field_1352, (float)normal.field_1351, (float)normal.field_1350).method_1344();
    }

    public class_2960 getTexture(ChainKnotEntity entity) {
        return entity.getChainType().getKnotTexture();
    }
}

