/*
 * Decompiled with CFR 0.152.
 */
package com.github.legoatoom.connectiblechains.client.render.entity;

import com.github.legoatoom.connectiblechains.ConnectibleChains;
import com.github.legoatoom.connectiblechains.chain.ChainTypesRegistry;
import com.github.legoatoom.connectiblechains.compat.BuiltinCompat;
import com.github.legoatoom.connectiblechains.util.Helper;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.fabricmc.fabric.api.resource.SimpleResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import org.jetbrains.annotations.Nullable;

public class ChainTextureManager
implements SimpleResourceReloadListener<Map<class_2960, JsonModel>> {
    private static final Gson GSON = new GsonBuilder().setLenient().create();
    private static final class_2960 MISSING_ID = new class_2960("connectiblechains", "textures/entity/missing.png");
    private final Object2ObjectMap<class_2960, class_2960> chainTextures = new Object2ObjectOpenHashMap(64);
    private final Object2ObjectMap<class_2960, class_2960> knotTextures = new Object2ObjectOpenHashMap(64);

    public class_2960 getFabricId() {
        return Helper.identifier("chain_textures");
    }

    public CompletableFuture<Map<class_2960, JsonModel>> load(class_3300 manager, class_3695 profiler, Executor executor) {
        return CompletableFuture.supplyAsync(() -> this.load(manager));
    }

    public Map<class_2960, JsonModel> load(class_3300 manager) {
        HashMap<class_2960, JsonModel> map = new HashMap<class_2960, JsonModel>();
        for (class_2960 chainType : ChainTypesRegistry.REGISTRY.method_10235()) {
            try {
                class_3298 resource = manager.method_14486(ChainTextureManager.getResourceId(ChainTextureManager.getModelId(chainType)));
                try {
                    InputStreamReader reader = new InputStreamReader(resource.method_14482(), StandardCharsets.UTF_8);
                    JsonModel jsonModel = (JsonModel)GSON.fromJson((Reader)reader, JsonModel.class);
                    map.put(chainType, jsonModel);
                }
                finally {
                    if (resource == null) continue;
                    resource.close();
                }
            }
            catch (FileNotFoundException e) {
                JsonModel builtinModel = this.loadBuiltinModel(manager, chainType);
                if (builtinModel != null) {
                    map.put(chainType, builtinModel);
                    continue;
                }
                ConnectibleChains.LOGGER.error("Missing model for {}.", (Object)chainType, (Object)e);
            }
            catch (Exception e) {
                ConnectibleChains.LOGGER.error("Failed to load model for {}.", (Object)chainType, (Object)e);
            }
        }
        return map;
    }

    public static class_2960 getResourceId(class_2960 modelId) {
        return new class_2960(modelId.method_12836(), "models/" + modelId.method_12832() + ".json");
    }

    public static class_2960 getModelId(class_2960 chainType) {
        return new class_2960(chainType.method_12836(), "entity/connectiblechains/" + chainType.method_12832());
    }

    @Nullable
    private JsonModel loadBuiltinModel(class_3300 manager, class_2960 chainType) {
        if (BuiltinCompat.BUILTIN_TYPES.contains(chainType)) {
            JsonModel jsonModel;
            block9: {
                class_3298 resource = manager.method_14486(ChainTextureManager.getBuiltinResourceId(ChainTextureManager.getModelId(chainType)));
                try {
                    InputStreamReader reader = new InputStreamReader(resource.method_14482(), StandardCharsets.UTF_8);
                    jsonModel = (JsonModel)GSON.fromJson((Reader)reader, JsonModel.class);
                    if (resource == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (resource != null) {
                            try {
                                resource.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        ConnectibleChains.LOGGER.error("Error for builtin type {}.", (Object)chainType, (Object)e);
                    }
                }
                resource.close();
            }
            return jsonModel;
        }
        return null;
    }

    private static class_2960 getBuiltinResourceId(class_2960 modelId) {
        return new class_2960("connectiblechains", "models/" + modelId.method_12832() + ".json");
    }

    public CompletableFuture<Void> apply(Map<class_2960, JsonModel> textureMap, class_3300 manager, class_3695 profiler, Executor executor) {
        this.chainTextures.clear();
        this.knotTextures.clear();
        textureMap.forEach((id, entry) -> {
            this.chainTextures.put(id, (Object)entry.textures.chainTextureId());
            this.knotTextures.put(id, (Object)entry.textures.knotTextureId());
        });
        return CompletableFuture.completedFuture(null);
    }

    public class_2960 getChainTexture(class_2960 chainType) {
        return (class_2960)this.chainTextures.getOrDefault((Object)chainType, (Object)MISSING_ID);
    }

    public class_2960 getKnotTexture(class_2960 chainType) {
        return (class_2960)this.knotTextures.getOrDefault((Object)chainType, (Object)MISSING_ID);
    }

    protected static final class JsonModel {
        public Textures textures;

        protected JsonModel() {
        }

        protected static final class Textures {
            public String chain;
            public String knot;

            protected Textures() {
            }

            public class_2960 chainTextureId() {
                return new class_2960(this.chain + ".png");
            }

            public class_2960 knotTextureId() {
                return new class_2960(this.knot + ".png");
            }
        }
    }
}

