/*
 * Decompiled with CFR 0.152.
 */
package com.github.legoatoom.connectiblechains.datafixer;

import com.github.legoatoom.connectiblechains.ConnectibleChains;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;

public abstract class NbtFixer {
    private static final String DATA_VERSION_KEY = "connectiblechains_DataVersion";
    private final SortedMap<Integer, List<NamedFix>> fixes = new TreeMap<Integer, List<NamedFix>>();

    public NbtFixer() {
        this.registerFixers();
    }

    public abstract void registerFixers();

    public class_2487 update(class_2487 nbt) {
        class_2499 entities = nbt.method_10554("Entities", 10);
        for (class_2520 entity : entities) {
            this.updateEntity((class_2487)entity);
        }
        return nbt;
    }

    protected void updateEntity(class_2487 nbt) {
        int currentVersion = nbt.method_10550(DATA_VERSION_KEY);
        if (currentVersion >= this.getVersion()) {
            return;
        }
        if (!nbt.method_10558("id").startsWith("connectiblechains")) {
            return;
        }
        for (Map.Entry<Integer, List<NamedFix>> entry : this.fixes.entrySet()) {
            if (entry.getKey() <= currentVersion) continue;
            for (NamedFix namedFix : entry.getValue()) {
                try {
                    nbt = namedFix.fix.apply(nbt);
                }
                catch (Exception e) {
                    ConnectibleChains.LOGGER.error("During fix '{}' for '{}': ", (Object)namedFix.name, (Object)nbt, (Object)e);
                }
            }
        }
    }

    protected abstract int getVersion();

    public void addVersionTag(class_2487 nbt) {
        nbt.method_10569(DATA_VERSION_KEY, this.getVersion());
    }

    protected void addFix(int version, String name, Fix fix) {
        if (!this.fixes.containsKey(version)) {
            this.fixes.put(version, new ArrayList());
        }
        ((List)this.fixes.get(version)).add(new NamedFix(name, fix));
    }

    private record NamedFix(String name, Fix fix) {
    }

    static interface Fix {
        public class_2487 apply(class_2487 var1);
    }
}

