/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.indigo.renderer.render;

import java.util.function.Consumer;
import java.util.function.Function;
import net.fabricmc.fabric.api.renderer.v1.mesh.Mesh;
import net.fabricmc.fabric.api.renderer.v1.mesh.MutableQuadView;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.fabricmc.fabric.impl.client.indigo.renderer.IndigoRenderer;
import net.fabricmc.fabric.impl.client.indigo.renderer.RenderMaterialImpl;
import net.fabricmc.fabric.impl.client.indigo.renderer.aocalc.AoCalculator;
import net.fabricmc.fabric.impl.client.indigo.renderer.mesh.EncodingFormat;
import net.fabricmc.fabric.impl.client.indigo.renderer.mesh.MeshImpl;
import net.fabricmc.fabric.impl.client.indigo.renderer.mesh.MutableQuadViewImpl;
import net.fabricmc.fabric.impl.client.indigo.renderer.render.AbstractQuadRenderer;
import net.fabricmc.fabric.impl.client.indigo.renderer.render.BlockRenderInfo;
import net.minecraft.class_1921;
import net.minecraft.class_4588;

public abstract class AbstractMeshConsumer
extends AbstractQuadRenderer
implements Consumer<Mesh> {
    private final Maker editorQuad = new Maker();

    protected AbstractMeshConsumer(BlockRenderInfo blockInfo, Function<class_1921, class_4588> bufferFunc, AoCalculator aoCalc, RenderContext.QuadTransform transform) {
        super(blockInfo, bufferFunc, aoCalc, transform);
    }

    @Override
    public void accept(Mesh mesh) {
        MeshImpl m = (MeshImpl)mesh;
        int[] data = m.data();
        int limit = data.length;
        for (int index = 0; index < limit; index += EncodingFormat.TOTAL_STRIDE) {
            System.arraycopy(data, index, this.editorQuad.data(), 0, EncodingFormat.TOTAL_STRIDE);
            this.editorQuad.load();
            this.renderQuad(this.editorQuad);
        }
    }

    public QuadEmitter getEmitter() {
        this.editorQuad.clear();
        return this.editorQuad;
    }

    private void renderQuad(MutableQuadViewImpl quad) {
        if (!this.transform.transform((MutableQuadView)quad)) {
            return;
        }
        if (!this.blockInfo.shouldDrawFace(quad.cullFace())) {
            return;
        }
        this.tessellateQuad(quad, 0);
    }

    private void tessellateQuad(MutableQuadViewImpl quad, int textureIndex) {
        RenderMaterialImpl.Value mat = quad.material();
        int colorIndex = mat.disableColorIndex(textureIndex) ? -1 : quad.colorIndex();
        class_1921 renderLayer = this.blockInfo.effectiveRenderLayer(mat.blendMode(textureIndex));
        if (this.blockInfo.defaultAo && !mat.disableAo(textureIndex)) {
            this.aoCalc.compute(quad, false);
            if (mat.emissive(textureIndex)) {
                this.tessellateSmoothEmissive(quad, renderLayer, colorIndex);
            } else {
                this.tessellateSmooth(quad, renderLayer, colorIndex);
            }
        } else if (mat.emissive(textureIndex)) {
            this.tessellateFlatEmissive(quad, renderLayer, colorIndex);
        } else {
            this.tessellateFlat(quad, renderLayer, colorIndex);
        }
    }

    private class Maker
    extends MutableQuadViewImpl {
        private Maker() {
            this.data = new int[EncodingFormat.TOTAL_STRIDE];
            this.material(IndigoRenderer.MATERIAL_STANDARD);
        }

        public Maker emit() {
            this.computeGeometry();
            AbstractMeshConsumer.this.renderQuad(this);
            this.clear();
            return this;
        }
    }
}

