/*
 * Decompiled with CFR 0.152.
 */
package com.nhoryzon.mc.farmersdelight.block;

import com.nhoryzon.mc.farmersdelight.entity.block.StoveBlockEntity;
import com.nhoryzon.mc.farmersdelight.registry.BlockEntityTypesRegistry;
import com.nhoryzon.mc.farmersdelight.registry.DamageSourcesRegistry;
import com.nhoryzon.mc.farmersdelight.registry.SoundsRegistry;
import com.nhoryzon.mc.farmersdelight.util.MathUtils;
import java.util.Optional;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.object.builder.v1.block.FabricBlockSettings;
import net.fabricmc.fabric.api.tag.convention.v1.ConventionalItemTags;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1778;
import net.minecraft.class_1786;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2769;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3920;
import net.minecraft.class_3922;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import org.jetbrains.annotations.Nullable;

public class StoveBlock
extends class_2237 {
    public static final class_2753 FACING = class_2741.field_12481;
    public static final class_2746 LIT = class_2741.field_12548;

    public StoveBlock() {
        super((class_4970.class_2251)FabricBlockSettings.copyOf((class_4970)class_2246.field_10104).luminance(state -> Boolean.TRUE.equals(state.method_11654((class_2769)class_2741.field_12548)) ? 13 : 0));
        this.method_9590((class_2680)((class_2680)((class_2680)this.method_9595().method_11664()).method_11657((class_2769)FACING, (Comparable)class_2350.field_11043)).method_11657((class_2769)LIT, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return BlockEntityTypesRegistry.STOVE.get().method_11032(pos, state);
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return StoveBlock.method_31618(type, BlockEntityTypesRegistry.STOVE.get(), StoveBlockEntity::tick);
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (!Boolean.TRUE.equals(state.method_11654((class_2769)LIT)) && this.tryLightUpByPlayerHand(state, world, pos, player, hand) == class_1269.field_5812) {
            return class_1269.field_5812;
        }
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof StoveBlockEntity) {
            StoveBlockEntity stoveBlockEntity = (StoveBlockEntity)class_25862;
            return this.onUseByPlayerHand(stoveBlockEntity, state, world, pos, player, hand);
        }
        return class_1269.field_5811;
    }

    protected class_1269 onUseByPlayerHand(StoveBlockEntity stoveBlockEntity, class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand) {
        class_1799 itemStack = player.method_5998(hand);
        Optional<class_3920> optional = stoveBlockEntity.findMatchingRecipe(itemStack);
        if (optional.isEmpty()) {
            return this.tryExtinguishByPlayerHand(state, world, pos, player, hand);
        }
        if (!world.method_8608() && !stoveBlockEntity.isStoveBlockedAbove() && stoveBlockEntity.addItem(player.method_31549().field_7477 ? itemStack.method_7972() : itemStack, optional.get().method_8167())) {
            player.method_7281(class_3468.field_17486);
            return class_1269.field_5812;
        }
        return class_1269.field_21466;
    }

    protected class_1269 tryLightUpByPlayerHand(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand) {
        class_1269 actionResult = class_1269.field_5811;
        class_1799 stackHand = player.method_5998(hand);
        if (stackHand.method_7909() instanceof class_1786) {
            world.method_8396(player, pos, class_3417.field_15145, class_3419.field_15245, 1.0f, MathUtils.RAND.nextFloat() * 0.4f + 0.8f);
            stackHand.method_7956(1, (class_1309)player, playerEntity -> playerEntity.method_20236(hand));
            actionResult = class_1269.field_5812;
        } else if (stackHand.method_7909() instanceof class_1778) {
            world.method_8396(player, pos, class_3417.field_15145, class_3419.field_15245, 1.0f, (MathUtils.RAND.nextFloat() - MathUtils.RAND.nextFloat()) * 0.2f + 1.0f);
            if (!player.method_7337()) {
                stackHand.method_7934(1);
            }
            actionResult = class_1269.field_5812;
        }
        if (actionResult.method_23665()) {
            world.method_8652(pos, (class_2680)state.method_11657((class_2769)LIT, (Comparable)Boolean.TRUE), 11);
        }
        return actionResult;
    }

    protected class_1269 tryExtinguishByPlayerHand(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand) {
        class_1799 stackHand = player.method_5998(hand);
        class_1792 usedItem = stackHand.method_7909();
        if (!stackHand.method_31573(ConventionalItemTags.SHOVELS) && usedItem != class_1802.field_8705) {
            return class_1269.field_5811;
        }
        this.extinguish(state, world, pos);
        if (!player.method_7337() && usedItem == class_1802.field_8705) {
            player.method_6122(hand, new class_1799((class_1935)class_1802.field_8550));
        }
        return class_1269.field_5812;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{FACING, LIT});
    }

    @Nullable
    public class_2680 method_9605(class_1750 context) {
        return (class_2680)((class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)context.method_8042().method_10153())).method_11657((class_2769)LIT, (Comparable)Boolean.valueOf(true));
    }

    public void method_9591(class_1937 world, class_2338 pos, class_2680 state, class_1297 entity) {
        class_1309 livingEntity;
        boolean isLit = (Boolean)world.method_8320(pos).method_11654((class_2769)LIT);
        if (isLit && !entity.method_5753() && entity instanceof class_1309 && !class_1890.method_8216((class_1309)(livingEntity = (class_1309)entity))) {
            entity.method_5643(DamageSourcesRegistry.STOVE_BLOCK, 1.0f);
        }
        super.method_9591(world, pos, state, entity);
    }

    @Environment(value=EnvType.CLIENT)
    public void method_9496(class_2680 state, class_1937 world, class_2338 pos, Random random) {
        if (Boolean.TRUE.equals(state.method_11654((class_2769)class_3922.field_17352))) {
            double dx = (double)pos.method_10263() + 0.5;
            double dy = pos.method_10264();
            double dz = (double)pos.method_10260() + 0.5;
            if (random.nextInt(10) == 0) {
                world.method_8486(dx, dy, dz, SoundsRegistry.BLOCK_STOVE_CRACKLE.get(), class_3419.field_15245, 1.0f, 1.0f, false);
            }
            class_2350 direction = (class_2350)state.method_11654((class_2769)FACING);
            class_2350.class_2351 axis = direction.method_10166();
            double d0 = random.nextDouble() * 0.6 - 0.3;
            double d1 = axis == class_2350.class_2351.field_11048 ? (double)direction.method_10148() * 0.52 : d0;
            double d2 = random.nextDouble() * 6.0 / 16.0;
            double d3 = axis == class_2350.class_2351.field_11051 ? (double)direction.method_10165() * 0.52 : d0;
            world.method_8406((class_2394)class_2398.field_11251, dx + d1, dy + d2, dz + d3, 0.0, 0.0, 0.0);
            world.method_8406((class_2394)class_2398.field_11240, dx + d1, dy + d2, dz + d3, 0.0, 0.0, 0.0);
        }
    }

    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        if (state.method_26204() != newState.method_26204()) {
            class_2586 class_25862 = world.method_8321(pos);
            if (class_25862 instanceof StoveBlockEntity) {
                StoveBlockEntity stoveBlockEntity = (StoveBlockEntity)class_25862;
                class_1264.method_17349((class_1937)world, (class_2338)pos, stoveBlockEntity.getInventory());
            }
            super.method_9536(state, world, pos, newState, moved);
        }
    }

    private void extinguish(class_2680 state, class_1937 world, class_2338 pos) {
        world.method_8501(pos, (class_2680)state.method_11657((class_2769)LIT, (Comparable)Boolean.valueOf(false)));
        double dx = (double)pos.method_10263() + 0.5;
        double dy = pos.method_10264();
        double dz = (double)pos.method_10260() + 0.5;
        world.method_8486(dx, dy, dz, class_3417.field_15102, class_3419.field_15245, 0.5f, 2.6f, false);
    }
}

