/*
 * Decompiled with CFR 0.152.
 */
package com.nhoryzon.mc.farmersdelight.client.render.block;

import com.nhoryzon.mc.farmersdelight.block.signs.ICanvasSign;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1011;
import net.minecraft.class_1160;
import net.minecraft.class_1297;
import net.minecraft.class_1767;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2508;
import net.minecraft.class_2551;
import net.minecraft.class_2625;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4719;
import net.minecraft.class_4722;
import net.minecraft.class_4730;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_5602;
import net.minecraft.class_5614;
import net.minecraft.class_746;
import net.minecraft.class_837;

@Environment(value=EnvType.CLIENT)
public class CanvasSignBlockEntityRenderer
extends class_837 {
    public static final class_4730 BLANK_CANVAS_SIGN_SPRITE = new class_4730(class_4722.field_21708, new class_2960("farmersdelight", "entity/signs/canvas"));
    public static final Map<class_1767, class_4730> DYED_CANVAS_SIGN_SPRITES = Arrays.stream(class_1767.values()).collect(Collectors.toMap(Function.identity(), CanvasSignBlockEntityRenderer::createSignSpriteIdentifier));
    public static final float TEXT_LINE_HEIGHT = 10.0f;
    public static final float TEXT_VERTICAL_OFFSET = 19.0f;
    private static final int RENDER_DISTANCE = class_3532.method_34954((int)16);
    private final class_837.class_4702 signModel;
    private final class_327 textRenderer;

    public CanvasSignBlockEntityRenderer(class_5614.class_5615 context) {
        super(context);
        this.signModel = new class_837.class_4702(context.method_32140(class_5602.method_32078((class_4719)class_4719.field_21677)));
        this.textRenderer = context.method_32143();
    }

    public void method_23083(class_2625 signBlockEntity, float f, class_4587 matrixStack, class_4597 vertexConsumerProvider, int packedLight, int packedOverlay) {
        int light;
        boolean hasOutline;
        int baseColor;
        int darkColor;
        class_2680 blockState = signBlockEntity.method_11010();
        matrixStack.method_22903();
        if (blockState.method_26204() instanceof class_2508) {
            matrixStack.method_22904(0.5, 0.5, 0.5);
            h = -((float)((Integer)blockState.method_11654((class_2769)class_2508.field_11559) * 360) / 16.0f);
            matrixStack.method_22907(class_1160.field_20705.method_23214(h));
            this.signModel.field_21531.field_3665 = true;
        } else {
            matrixStack.method_22904(0.5, 0.5, 0.5);
            h = -((class_2350)blockState.method_11654((class_2769)class_2551.field_11726)).method_10144();
            matrixStack.method_22907(class_1160.field_20705.method_23214(h));
            matrixStack.method_22904(0.0, -0.3125, -0.4375);
            this.signModel.field_21531.field_3665 = false;
        }
        matrixStack.method_22903();
        float rootScale = 0.6666667f;
        matrixStack.method_22905(rootScale, -rootScale, -rootScale);
        class_1767 dye = null;
        class_2248 class_22482 = blockState.method_26204();
        if (class_22482 instanceof ICanvasSign) {
            ICanvasSign canvasSign = (ICanvasSign)class_22482;
            dye = canvasSign.getBackgroundColor();
        }
        class_4730 spriteIdentifier = CanvasSignBlockEntityRenderer.getCanvasSignSpriteTexture(dye);
        Objects.requireNonNull(this.signModel);
        class_4588 vertexConsumer = spriteIdentifier.method_24145(vertexConsumerProvider, arg_0 -> ((class_837.class_4702)this.signModel).method_23500(arg_0));
        this.signModel.field_27756.method_22698(matrixStack, vertexConsumer, packedLight, packedOverlay);
        matrixStack.method_22909();
        float textScale = 0.010416667f;
        matrixStack.method_22904(0.0, 0.3333333432674408, 0.046666666865348816);
        matrixStack.method_22905(textScale, -textScale, textScale);
        class_5481[] orderedTexts = signBlockEntity.method_33829(class_310.method_1551().method_33883(), text -> {
            List list = this.textRenderer.method_1728((class_5348)text, 90);
            return list.isEmpty() ? class_5481.field_26385 : (class_5481)list.get(0);
        });
        if (signBlockEntity.method_34271()) {
            darkColor = CanvasSignBlockEntityRenderer.getColor(signBlockEntity, true);
            baseColor = signBlockEntity.method_16126().method_16357();
            hasOutline = CanvasSignBlockEntityRenderer.shouldRender(signBlockEntity, baseColor);
            light = 0xF000F0;
        } else {
            baseColor = darkColor = CanvasSignBlockEntityRenderer.getColor(signBlockEntity, false);
            hasOutline = false;
            light = packedLight;
        }
        for (int p = 0; p < 4; ++p) {
            class_5481 orderedText = orderedTexts[p];
            float x = -this.textRenderer.method_30880(orderedText) / 2;
            float y = (float)p * 10.0f - 19.0f;
            if (hasOutline) {
                this.textRenderer.method_37296(orderedText, x, y, baseColor, darkColor, matrixStack.method_23760().method_23761(), vertexConsumerProvider, light);
                continue;
            }
            this.textRenderer.method_22942(orderedText, x, y, baseColor, false, matrixStack.method_23760().method_23761(), vertexConsumerProvider, false, 0, light);
        }
        matrixStack.method_22909();
    }

    private static boolean shouldRender(class_2625 sign, int textColor) {
        if (textColor == class_1767.field_7963.method_16357()) {
            return true;
        }
        class_310 minecraftClient = class_310.method_1551();
        class_746 clientPlayerEntity = minecraftClient.field_1724;
        if (clientPlayerEntity != null && minecraftClient.field_1690.method_31044().method_31034() && clientPlayerEntity.method_31550()) {
            return true;
        }
        class_1297 entity = minecraftClient.method_1560();
        return entity != null && entity.method_5707(class_243.method_24953((class_2382)sign.method_11016())) < (double)RENDER_DISTANCE;
    }

    private static int getColor(class_2625 sign, boolean isOutlineVisible) {
        int textColor = sign.method_16126().method_16357();
        double brightness = isOutlineVisible ? 0.4 : 0.6;
        int red = (int)((double)class_1011.method_24033((int)textColor) * brightness);
        int green = (int)((double)class_1011.method_24034((int)textColor) * brightness);
        int blue = (int)((double)class_1011.method_24035((int)textColor) * brightness);
        return textColor == class_1767.field_7963.method_16357() && sign.method_34271() ? -988212 : class_1011.method_24031((int)0, (int)blue, (int)green, (int)red);
    }

    public static class_4730 getCanvasSignSpriteTexture(class_1767 dyeColor) {
        return dyeColor != null ? DYED_CANVAS_SIGN_SPRITES.get(dyeColor) : BLANK_CANVAS_SIGN_SPRITE;
    }

    public static class_4730 createSignSpriteIdentifier(class_1767 dyeColor) {
        return new class_4730(class_4722.field_21708, new class_2960("farmersdelight", "entity/signs/canvas_" + dyeColor.method_7792()));
    }
}

