/*
 * Decompiled with CFR 0.152.
 */
package com.tterrag.registrate.providers;

import com.google.common.collect.ImmutableMap;
import com.tterrag.registrate.AbstractRegistrate;
import com.tterrag.registrate.providers.ProviderType;
import com.tterrag.registrate.providers.RegistrateProvider;
import com.tterrag.registrate.util.DataIngredient;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import me.alphamode.forgetags.Tags;
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricRecipesProvider;
import net.minecraft.class_1792;
import net.minecraft.class_184;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_2037;
import net.minecraft.class_2066;
import net.minecraft.class_2073;
import net.minecraft.class_2096;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2444;
import net.minecraft.class_2446;
import net.minecraft.class_2447;
import net.minecraft.class_2450;
import net.minecraft.class_2454;
import net.minecraft.class_2960;
import net.minecraft.class_3957;
import net.minecraft.class_3981;
import net.minecraft.class_5794;
import net.minecraft.class_5797;
import net.minecraft.class_6862;
import org.jetbrains.annotations.Nullable;

public class RegistrateRecipeProvider
extends FabricRecipesProvider
implements RegistrateProvider,
Consumer<class_2444> {
    private final AbstractRegistrate<?> owner;
    @Nullable
    private Consumer<class_2444> callback;
    public static final int DEFAULT_SMELT_TIME = 200;
    public static final int DEFAULT_BLAST_TIME = 100;
    public static final int DEFAULT_SMOKE_TIME = 100;
    public static final int DEFAULT_CAMPFIRE_TIME = 600;
    private static final String SMELTING_NAME = "smelting";
    private static final ImmutableMap<class_3957<?>, String> COOKING_TYPE_NAMES = ImmutableMap.builder().put((Object)class_1865.field_9042, (Object)"smelting").put((Object)class_1865.field_17084, (Object)"blasting").put((Object)class_1865.field_17085, (Object)"smoking").put((Object)class_1865.field_17347, (Object)"campfire").build();

    public RegistrateRecipeProvider(AbstractRegistrate<?> owner, FabricDataGenerator generatorIn) {
        super(generatorIn);
        this.owner = owner;
    }

    @Override
    public EnvType getSide() {
        return EnvType.SERVER;
    }

    @Override
    public void accept(@Nullable class_2444 t) {
        if (this.callback == null) {
            throw new IllegalStateException("Cannot accept recipes outside of a call to registerRecipes");
        }
        this.callback.accept(t);
    }

    protected void generateRecipes(Consumer<class_2444> consumer) {
        this.callback = consumer;
        this.owner.genData(ProviderType.RECIPE, this);
        this.callback = null;
    }

    public class_2960 safeId(class_2960 id) {
        return new class_2960(this.owner.getModid(), this.safeName(id));
    }

    public class_2960 safeId(DataIngredient source) {
        return this.safeId(source.getId());
    }

    public <R extends class_1935> class_2960 safeId(R registryEntry) {
        return class_2378.field_11142.method_10221((Object)registryEntry.method_8389());
    }

    public String safeName(class_2960 id) {
        return id.method_12832().replace('/', '_');
    }

    public String safeName(DataIngredient source) {
        return this.safeName(source.getId());
    }

    public <T extends class_1935> void cooking(DataIngredient source, Supplier<? extends T> result, float experience, int cookingTime, class_3957<?> serializer) {
        this.cooking(source, result, experience, cookingTime, (String)COOKING_TYPE_NAMES.get(serializer), serializer);
    }

    public <T extends class_1935> void cooking(DataIngredient source, Supplier<? extends T> result, float experience, int cookingTime, String typeName, class_3957<?> serializer) {
        class_2454.method_17801((class_1856)source, (class_1935)((class_1935)result.get()), (float)experience, (int)cookingTime, serializer).method_10469("has_" + this.safeName(source), (class_184)source.getCritereon(this)).method_36443((Consumer)this, this.safeId((class_1935)result.get()) + "_from_" + this.safeName(source) + "_" + typeName);
    }

    public <T extends class_1935> void smelting(DataIngredient source, Supplier<? extends T> result, float experience) {
        this.smelting(source, result, experience, 200);
    }

    public <T extends class_1935> void smelting(DataIngredient source, Supplier<? extends T> result, float experience, int cookingTime) {
        this.cooking(source, result, experience, cookingTime, class_1865.field_9042);
    }

    public <T extends class_1935> void blasting(DataIngredient source, Supplier<? extends T> result, float experience) {
        this.blasting(source, result, experience, 100);
    }

    public <T extends class_1935> void blasting(DataIngredient source, Supplier<? extends T> result, float experience, int cookingTime) {
        this.cooking(source, result, experience, cookingTime, class_1865.field_17084);
    }

    public <T extends class_1935> void smoking(DataIngredient source, Supplier<? extends T> result, float experience) {
        this.smoking(source, result, experience, 100);
    }

    public <T extends class_1935> void smoking(DataIngredient source, Supplier<? extends T> result, float experience, int cookingTime) {
        this.cooking(source, result, experience, cookingTime, class_1865.field_17085);
    }

    public <T extends class_1935> void campfire(DataIngredient source, Supplier<? extends T> result, float experience) {
        this.campfire(source, result, experience, 600);
    }

    public <T extends class_1935> void campfire(DataIngredient source, Supplier<? extends T> result, float experience, int cookingTime) {
        this.cooking(source, result, experience, cookingTime, class_1865.field_17347);
    }

    public <T extends class_1935> void stonecutting(DataIngredient source, Supplier<? extends T> result) {
        this.stonecutting(source, result, 1);
    }

    public <T extends class_1935> void stonecutting(DataIngredient source, Supplier<? extends T> result, int resultAmount) {
        class_3981.method_17969((class_1856)source, (class_1935)((class_1935)result.get()), (int)resultAmount).method_17970("has_" + this.safeName(source), (class_184)source.getCritereon(this)).method_36443((Consumer)this, this.safeId((class_1935)result.get()) + "_from_" + this.safeName(source) + "_stonecutting");
    }

    public <T extends class_1935> void smeltingAndBlasting(DataIngredient source, Supplier<? extends T> result, float xp) {
        this.smelting(source, result, xp);
        this.blasting(source, result, xp);
    }

    public <T extends class_1935> void food(DataIngredient source, Supplier<? extends T> result, float xp) {
        this.smelting(source, result, xp);
        this.smoking(source, result, xp);
        this.campfire(source, result, xp);
    }

    public <T extends class_1935> void square(DataIngredient source, Supplier<? extends T> output, boolean small) {
        class_2447 builder = class_2447.method_10437((class_1935)((class_1935)output.get())).method_10428(Character.valueOf('X'), (class_1856)source);
        if (small) {
            builder.method_10439("XX").method_10439("XX");
        } else {
            builder.method_10439("XXX").method_10439("XXX").method_10439("XXX");
        }
        builder.method_10429("has_" + this.safeName(source), (class_184)source.getCritereon(this)).method_17972((Consumer)this, this.safeId((class_1935)output.get()));
    }

    @Deprecated
    public <T extends class_1935> void storage(DataIngredient source, NonNullSupplier<? extends T> output) {
        this.square(source, output, false);
        this.singleItemUnfinished(source, output, 1, 9).method_36443((Consumer)this, this.safeId(source) + "_from_" + this.safeName(class_2378.field_11142.method_10221((Object)((class_1935)output.get()).method_8389())));
    }

    public <T extends class_1935> void storage(NonNullSupplier<? extends T> source, NonNullSupplier<? extends T> output) {
        this.storage(DataIngredient.items(source, new NonNullSupplier[0]), source, DataIngredient.items(output, new NonNullSupplier[0]), output);
    }

    public <T extends class_1935> void storage(DataIngredient sourceIngredient, NonNullSupplier<? extends T> source, DataIngredient outputIngredient, NonNullSupplier<? extends T> output) {
        this.square(sourceIngredient, output, false);
        this.singleItemUnfinished(outputIngredient, source, 1, 9).method_36443((Consumer)this, this.safeId(sourceIngredient) + "_from_" + this.safeName(class_2378.field_11142.method_10221((Object)((class_1935)output.get()).method_8389())));
    }

    public <T extends class_1935> class_2450 singleItemUnfinished(DataIngredient source, Supplier<? extends T> result, int required, int amount) {
        return class_2450.method_10448((class_1935)((class_1935)result.get()), (int)amount).method_10453((class_1856)source, required).method_10442("has_" + this.safeName(source), (class_184)source.getCritereon(this));
    }

    public <T extends class_1935> void singleItem(DataIngredient source, Supplier<? extends T> result, int required, int amount) {
        this.singleItemUnfinished(source, result, required, amount).method_17972((Consumer)this, this.safeId((class_1935)result.get()));
    }

    public <T extends class_1935> void planks(DataIngredient source, Supplier<? extends T> result) {
        this.singleItemUnfinished(source, result, 1, 4).method_10452("planks").method_17972((Consumer)this, this.safeId((class_1935)result.get()));
    }

    public <T extends class_1935> void stairs(DataIngredient source, Supplier<? extends T> result, @Nullable String group, boolean stone) {
        class_2447.method_10436((class_1935)((class_1935)result.get()), (int)4).method_10439("X  ").method_10439("XX ").method_10439("XXX").method_10428(Character.valueOf('X'), (class_1856)source).method_10435(group).method_10429("has_" + this.safeName(source), (class_184)source.getCritereon(this)).method_17972((Consumer)this, this.safeId((class_1935)result.get()));
        if (stone) {
            this.stonecutting(source, result);
        }
    }

    public <T extends class_1935> void slab(DataIngredient source, Supplier<? extends T> result, @Nullable String group, boolean stone) {
        class_2447.method_10436((class_1935)((class_1935)result.get()), (int)6).method_10439("XXX").method_10428(Character.valueOf('X'), (class_1856)source).method_10435(group).method_10429("has_" + this.safeName(source), (class_184)source.getCritereon(this)).method_17972((Consumer)this, this.safeId((class_1935)result.get()));
        if (stone) {
            this.stonecutting(source, result, 2);
        }
    }

    public <T extends class_1935> void fence(DataIngredient source, Supplier<? extends T> result, @Nullable String group) {
        class_2447.method_10436((class_1935)((class_1935)result.get()), (int)3).method_10439("W#W").method_10439("W#W").method_10428(Character.valueOf('W'), (class_1856)source).method_10433(Character.valueOf('#'), Tags.Items.RODS_WOODEN).method_10435(group).method_10429("has_" + this.safeName(source), (class_184)source.getCritereon(this)).method_17972((Consumer)this, this.safeId((class_1935)result.get()));
    }

    public <T extends class_1935> void fenceGate(DataIngredient source, Supplier<? extends T> result, @Nullable String group) {
        class_2447.method_10437((class_1935)((class_1935)result.get())).method_10439("#W#").method_10439("#W#").method_10428(Character.valueOf('W'), (class_1856)source).method_10433(Character.valueOf('#'), Tags.Items.RODS_WOODEN).method_10435(group).method_10429("has_" + this.safeName(source), (class_184)source.getCritereon(this)).method_17972((Consumer)this, this.safeId((class_1935)result.get()));
    }

    public <T extends class_1935> void wall(DataIngredient source, Supplier<? extends T> result) {
        class_2447.method_10436((class_1935)((class_1935)result.get()), (int)6).method_10439("XXX").method_10439("XXX").method_10428(Character.valueOf('X'), (class_1856)source).method_10429("has_" + this.safeName(source), (class_184)source.getCritereon(this)).method_17972((Consumer)this, this.safeId((class_1935)result.get()));
        this.stonecutting(source, result);
    }

    public <T extends class_1935> void door(DataIngredient source, Supplier<? extends T> result, @Nullable String group) {
        class_2447.method_10436((class_1935)((class_1935)result.get()), (int)3).method_10439("XX").method_10439("XX").method_10439("XX").method_10428(Character.valueOf('X'), (class_1856)source).method_10435(group).method_10429("has_" + this.safeName(source), (class_184)source.getCritereon(this)).method_17972((Consumer)this, this.safeId((class_1935)result.get()));
    }

    public <T extends class_1935> void trapDoor(DataIngredient source, Supplier<? extends T> result, @Nullable String group) {
        class_2447.method_10436((class_1935)((class_1935)result.get()), (int)2).method_10439("XXX").method_10439("XXX").method_10428(Character.valueOf('X'), (class_1856)source).method_10435(group).method_10429("has_" + this.safeName(source), (class_184)source.getCritereon(this)).method_17972((Consumer)this, this.safeId((class_1935)result.get()));
    }

    public static void oreSmelting(Consumer<class_2444> p_176592_, List<class_1935> p_176593_, class_1935 p_176594_, float p_176595_, int p_176596_, String p_176597_) {
        class_2446.method_36233(p_176592_, p_176593_, (class_1935)p_176594_, (float)p_176595_, (int)p_176596_, (String)p_176597_);
    }

    public static void oreBlasting(Consumer<class_2444> p_176626_, List<class_1935> p_176627_, class_1935 p_176628_, float p_176629_, int p_176630_, String p_176631_) {
        class_2446.method_36234(p_176626_, p_176627_, (class_1935)p_176628_, (float)p_176629_, (int)p_176630_, (String)p_176631_);
    }

    public static void oreCooking(Consumer<class_2444> p_176534_, class_3957<?> p_176535_, List<class_1935> p_176536_, class_1935 p_176537_, float p_176538_, int p_176539_, String p_176540_, String p_176541_) {
        class_2446.method_36232(p_176534_, p_176535_, p_176536_, (class_1935)p_176537_, (float)p_176538_, (int)p_176539_, (String)p_176540_, (String)p_176541_);
    }

    public static void netheriteSmithing(Consumer<class_2444> p_125995_, class_1792 p_125996_, class_1792 p_125997_) {
        class_2446.method_29728(p_125995_, (class_1792)p_125996_, (class_1792)p_125997_);
    }

    public static void planksFromLog(Consumer<class_2444> p_206409_, class_1935 p_206410_, class_6862<class_1792> p_206411_) {
        class_2446.method_24475(p_206409_, (class_1935)p_206410_, p_206411_);
    }

    public static void planksFromLogs(Consumer<class_2444> p_206413_, class_1935 p_206414_, class_6862<class_1792> p_206415_) {
        class_2446.method_24477(p_206413_, (class_1935)p_206414_, p_206415_);
    }

    public static void woodFromLogs(Consumer<class_2444> p_126003_, class_1935 p_126004_, class_1935 p_126005_) {
        class_2446.method_24476(p_126003_, (class_1935)p_126004_, (class_1935)p_126005_);
    }

    public static void woodenBoat(Consumer<class_2444> p_126022_, class_1935 p_126023_, class_1935 p_126024_) {
        class_2446.method_24478(p_126022_, (class_1935)p_126023_, (class_1935)p_126024_);
    }

    public static class_5797 buttonBuilder(class_1935 p_176659_, class_1856 p_176660_) {
        return class_2446.method_33542((class_1935)p_176659_, (class_1856)p_176660_);
    }

    public static class_5797 doorBuilder(class_1935 p_176671_, class_1856 p_176672_) {
        return class_2446.method_33544((class_1935)p_176671_, (class_1856)p_176672_);
    }

    public static class_5797 fenceBuilder(class_1935 p_176679_, class_1856 p_176680_) {
        return class_2446.method_33546((class_1935)p_176679_, (class_1856)p_176680_);
    }

    public static class_5797 fenceGateBuilder(class_1935 p_176685_, class_1856 p_176686_) {
        return class_2446.method_33548((class_1935)p_176685_, (class_1856)p_176686_);
    }

    public static void pressurePlate(Consumer<class_2444> p_176691_, class_1935 p_176692_, class_1935 p_176693_) {
        class_2446.method_32813(p_176691_, (class_1935)p_176692_, (class_1935)p_176693_);
    }

    public static class_5797 pressurePlateBuilder(class_1935 p_176695_, class_1856 p_176696_) {
        return class_2446.method_32806((class_1935)p_176695_, (class_1856)p_176696_);
    }

    public static void slab(Consumer<class_2444> p_176701_, class_1935 p_176702_, class_1935 p_176703_) {
        class_2446.method_32814(p_176701_, (class_1935)p_176702_, (class_1935)p_176703_);
    }

    public static class_5797 slabBuilder(class_1935 p_176705_, class_1856 p_176706_) {
        return class_2446.method_32804((class_1935)p_176705_, (class_1856)p_176706_);
    }

    public static class_5797 stairBuilder(class_1935 p_176711_, class_1856 p_176712_) {
        return class_2446.method_32808((class_1935)p_176711_, (class_1856)p_176712_);
    }

    public static class_5797 trapdoorBuilder(class_1935 p_176721_, class_1856 p_176722_) {
        return class_2446.method_33553((class_1935)p_176721_, (class_1856)p_176722_);
    }

    public static class_5797 signBuilder(class_1935 p_176727_, class_1856 p_176728_) {
        return class_2446.method_33555((class_1935)p_176727_, (class_1856)p_176728_);
    }

    public static void coloredWoolFromWhiteWoolAndDye(Consumer<class_2444> p_126062_, class_1935 p_126063_, class_1935 p_126064_) {
        class_2446.method_24884(p_126062_, (class_1935)p_126063_, (class_1935)p_126064_);
    }

    public static void carpet(Consumer<class_2444> p_176717_, class_1935 p_176718_, class_1935 p_176719_) {
        class_2446.method_24885(p_176717_, (class_1935)p_176718_, (class_1935)p_176719_);
    }

    public static void coloredCarpetFromWhiteCarpetAndDye(Consumer<class_2444> p_126070_, class_1935 p_126071_, class_1935 p_126072_) {
        class_2446.method_24886(p_126070_, (class_1935)p_126071_, (class_1935)p_126072_);
    }

    public static void bedFromPlanksAndWool(Consumer<class_2444> p_126074_, class_1935 p_126075_, class_1935 p_126076_) {
        class_2446.method_24887(p_126074_, (class_1935)p_126075_, (class_1935)p_126076_);
    }

    public static void bedFromWhiteBedAndDye(Consumer<class_2444> p_126078_, class_1935 p_126079_, class_1935 p_126080_) {
        class_2446.method_24888(p_126078_, (class_1935)p_126079_, (class_1935)p_126080_);
    }

    public static void banner(Consumer<class_2444> p_126082_, class_1935 p_126083_, class_1935 p_126084_) {
        class_2446.method_24889(p_126082_, (class_1935)p_126083_, (class_1935)p_126084_);
    }

    public static void stainedGlassFromGlassAndDye(Consumer<class_2444> p_126086_, class_1935 p_126087_, class_1935 p_126088_) {
        class_2446.method_24890(p_126086_, (class_1935)p_126087_, (class_1935)p_126088_);
    }

    public static void stainedGlassPaneFromStainedGlass(Consumer<class_2444> p_126090_, class_1935 p_126091_, class_1935 p_126092_) {
        class_2446.method_24891(p_126090_, (class_1935)p_126091_, (class_1935)p_126092_);
    }

    public static void stainedGlassPaneFromGlassPaneAndDye(Consumer<class_2444> p_126094_, class_1935 p_126095_, class_1935 p_126096_) {
        class_2446.method_24892(p_126094_, (class_1935)p_126095_, (class_1935)p_126096_);
    }

    public static void coloredTerracottaFromTerracottaAndDye(Consumer<class_2444> p_126098_, class_1935 p_126099_, class_1935 p_126100_) {
        class_2446.method_24893(p_126098_, (class_1935)p_126099_, (class_1935)p_126100_);
    }

    public static void concretePowder(Consumer<class_2444> p_126102_, class_1935 p_126103_, class_1935 p_126104_) {
        class_2446.method_24894(p_126102_, (class_1935)p_126103_, (class_1935)p_126104_);
    }

    public static void stonecutterResultFromBase(Consumer<class_2444> p_176736_, class_1935 p_176737_, class_1935 p_176738_) {
        class_2446.method_33717(p_176736_, (class_1935)p_176737_, (class_1935)p_176738_);
    }

    public static void stonecutterResultFromBase(Consumer<class_2444> p_176547_, class_1935 p_176548_, class_1935 p_176549_, int p_176550_) {
        class_2446.method_33715(p_176547_, (class_1935)p_176548_, (class_1935)p_176549_, (int)p_176550_);
    }

    public static void smeltingResultFromBase(Consumer<class_2444> p_176740_, class_1935 p_176741_, class_1935 p_176742_) {
        class_2446.method_34662(p_176740_, (class_1935)p_176741_, (class_1935)p_176742_);
    }

    public static void nineBlockStorageRecipes(Consumer<class_2444> p_176744_, class_1935 p_176745_, class_1935 p_176746_) {
        class_2446.method_36325(p_176744_, (class_1935)p_176745_, (class_1935)p_176746_);
    }

    public static void nineBlockStorageRecipesWithCustomPacking(Consumer<class_2444> p_176563_, class_1935 p_176564_, class_1935 p_176565_, String p_176566_, String p_176567_) {
        class_2446.method_36446(p_176563_, (class_1935)p_176564_, (class_1935)p_176565_, (String)p_176566_, (String)p_176567_);
    }

    public static void nineBlockStorageRecipesRecipesWithCustomUnpacking(Consumer<class_2444> p_176617_, class_1935 p_176618_, class_1935 p_176619_, String p_176620_, String p_176621_) {
        class_2446.method_36449(p_176617_, (class_1935)p_176618_, (class_1935)p_176619_, (String)p_176620_, (String)p_176621_);
    }

    public static void cookRecipes(Consumer<class_2444> p_126007_, String p_126008_, class_3957<?> p_126009_, int p_126010_) {
        class_2446.method_17585(p_126007_, (String)p_126008_, p_126009_, (int)p_126010_);
    }

    public static void simpleCookingRecipe(Consumer<class_2444> p_176584_, String p_176585_, class_3957<?> p_176586_, int p_176587_, class_1935 p_176588_, class_1935 p_176589_, float p_176590_) {
        class_2446.method_36448(p_176584_, (String)p_176585_, p_176586_, (int)p_176587_, (class_1935)p_176588_, (class_1935)p_176589_, (float)p_176590_);
    }

    public static void waxRecipes(Consumer<class_2444> p_176611_) {
        class_2446.method_34854(p_176611_);
    }

    public static void generateRecipes(Consumer<class_2444> p_176581_, class_5794 p_176582_) {
        class_2446.method_33535(p_176581_, (class_5794)p_176582_);
    }

    public static class_2248 getBaseBlock(class_5794 p_176524_, class_5794.class_5796 p_176525_) {
        return class_2446.method_33533((class_5794)p_176524_, (class_5794.class_5796)p_176525_);
    }

    public static class_2037.class_2039 insideOf(class_2248 p_125980_) {
        return class_2446.method_10422((class_2248)p_125980_);
    }

    public static class_2066.class_2068 has(class_2096.class_2100 p_176521_, class_1935 p_176522_) {
        return class_2446.method_35914((class_2096.class_2100)p_176521_, (class_1935)p_176522_);
    }

    public static class_2066.class_2068 has(class_1935 p_125978_) {
        return class_2446.method_10426((class_1935)p_125978_);
    }

    public static class_2066.class_2068 has(class_6862<class_1792> p_206407_) {
        return class_2446.method_10420(p_206407_);
    }

    public static class_2066.class_2068 inventoryTrigger(class_2073 ... p_126012_) {
        return class_2446.method_10423((class_2073[])p_126012_);
    }

    public static String getHasName(class_1935 p_176603_) {
        return class_2446.method_32807((class_1935)p_176603_);
    }

    public static String getItemName(class_1935 p_176633_) {
        return class_2446.method_33716((class_1935)p_176633_);
    }

    public static String getSimpleRecipeName(class_1935 p_176645_) {
        return class_2446.method_36450((class_1935)p_176645_);
    }

    public static String getConversionRecipeName(class_1935 p_176518_, class_1935 p_176519_) {
        return class_2446.method_33714((class_1935)p_176518_, (class_1935)p_176519_);
    }

    public static String getSmeltingRecipeName(class_1935 p_176657_) {
        return class_2446.method_36451((class_1935)p_176657_);
    }

    public static String getBlastingRecipeName(class_1935 p_176669_) {
        return class_2446.method_36452((class_1935)p_176669_);
    }
}

