/*
 * Decompiled with CFR 0.152.
 */
package com.tterrag.registrate.providers.loot;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.tterrag.registrate.AbstractRegistrate;
import com.tterrag.registrate.fabric.NonNullTriFunction;
import com.tterrag.registrate.mixin.accessor.LootContextParamSetsAccessor;
import com.tterrag.registrate.mixin.accessor.LootTableProviderAccessor;
import com.tterrag.registrate.providers.ProviderType;
import com.tterrag.registrate.providers.RegistrateProvider;
import com.tterrag.registrate.providers.loot.RegistrateBlockLootTables;
import com.tterrag.registrate.providers.loot.RegistrateLootTables;
import com.tterrag.registrate.util.nullness.NonNullConsumer;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.minecraft.class_173;
import net.minecraft.class_176;
import net.minecraft.class_2403;
import net.minecraft.class_2405;
import net.minecraft.class_2408;
import net.minecraft.class_2438;
import net.minecraft.class_2960;
import net.minecraft.class_52;
import net.minecraft.class_58;
import net.minecraft.class_60;

public class RegistrateLootTableProvider
extends class_2438
implements RegistrateProvider {
    private static final Map<String, LootType<?>> LOOT_TYPES = new HashMap();
    private final AbstractRegistrate<?> parent;
    private final Multimap<LootType<?>, Consumer<? super RegistrateLootTables>> specialLootActions = HashMultimap.create();
    private final Multimap<class_176, Consumer<BiConsumer<class_2960, class_52.class_53>>> lootActions = HashMultimap.create();
    private final Set<RegistrateLootTables> currentLootCreators = new HashSet<RegistrateLootTables>();
    private static final BiMap<class_2960, class_176> SET_REGISTRY = LootContextParamSetsAccessor.getREGISTRY();

    public void method_10319(class_2408 pCache) {
        Path path = ((LootTableProviderAccessor)((Object)this)).getGenerator().method_10313();
        HashMap map = Maps.newHashMap();
        this.getTables().forEach(p_124458_ -> ((Consumer)((Supplier)p_124458_.getFirst()).get()).accept((p_176077_, p_176078_) -> {
            if (map.put(p_176077_, p_176078_.method_334((class_176)p_124458_.getSecond()).method_338()) != null) {
                throw new IllegalStateException("Duplicate loot table " + p_176077_);
            }
        }));
        class_58 validationcontext = new class_58(class_173.field_1177, p_124465_ -> null, map::get);
        this.validate(map, validationcontext);
        Multimap multimap = validationcontext.method_361();
        if (!multimap.isEmpty()) {
            multimap.forEach((p_124446_, p_124447_) -> LootTableProviderAccessor.getLOGGER().warn("Found validation problem in {}: {}", p_124446_, p_124447_));
            throw new IllegalStateException("Failed to validate loot tables, see logs");
        }
        map.forEach((p_124451_, p_124452_) -> {
            Path path1 = LootTableProviderAccessor.callCreatePath(path, p_124451_);
            try {
                class_2405.method_10320((Gson)LootTableProviderAccessor.getGSON(), (class_2408)pCache, (JsonElement)class_60.method_372((class_52)p_124452_), (Path)path1);
            }
            catch (IOException ioexception) {
                LootTableProviderAccessor.getLOGGER().error("Couldn't save loot table {}", (Object)path1, (Object)ioexception);
            }
        });
    }

    public RegistrateLootTableProvider(AbstractRegistrate<?> parent, class_2403 dataGeneratorIn) {
        super(dataGeneratorIn);
        this.parent = parent;
    }

    public String method_10321() {
        return "Loot tables";
    }

    @Override
    public EnvType getSide() {
        return EnvType.SERVER;
    }

    protected void validate(Map<class_2960, class_52> map, class_58 validationresults) {
        this.currentLootCreators.forEach(c -> c.validate(map, validationresults));
    }

    public <T extends RegistrateLootTables> void addLootAction(LootType<T> type, NonNullConsumer<? extends RegistrateLootTables> action) {
        this.specialLootActions.put(type, action);
    }

    public void addLootAction(class_176 set, Consumer<BiConsumer<class_2960, class_52.class_53>> action) {
        this.lootActions.put((Object)set, action);
    }

    private Supplier<Consumer<BiConsumer<class_2960, class_52.class_53>>> getLootCreator(AbstractRegistrate<?> parent, LootType<?> type) {
        return () -> {
            RegistrateLootTables creator = type.getLootCreator(parent, cons -> this.specialLootActions.get((Object)type).forEach(c -> c.accept(cons)), (FabricDataGenerator)((LootTableProviderAccessor)((Object)this)).getGenerator());
            this.currentLootCreators.add(creator);
            return creator;
        };
    }

    protected List<Pair<Supplier<Consumer<BiConsumer<class_2960, class_52.class_53>>>, class_176>> getTables() {
        this.parent.genData(ProviderType.LOOT, this);
        this.currentLootCreators.clear();
        ImmutableList.Builder builder = ImmutableList.builder();
        for (LootType<?> type : LOOT_TYPES.values()) {
            builder.add((Object)Pair.of(this.getLootCreator(this.parent, type), (Object)type.getLootSet()));
        }
        for (class_176 set : SET_REGISTRY.values()) {
            builder.add((Object)Pair.of(() -> callback -> this.lootActions.get((Object)set).forEach(a -> a.accept(callback)), (Object)set));
        }
        return builder.build();
    }

    public static interface LootType<T extends RegistrateLootTables> {
        public static final LootType<RegistrateBlockLootTables> BLOCK = LootType.register("block", class_173.field_1172, RegistrateBlockLootTables::new);

        public T getLootCreator(AbstractRegistrate<?> var1, Consumer<T> var2, FabricDataGenerator var3);

        public class_176 getLootSet();

        public static <T extends RegistrateLootTables> LootType<T> register(String name, final class_176 set, final NonNullTriFunction<AbstractRegistrate, Consumer<T>, FabricDataGenerator, T> factory) {
            LootType type = new LootType<T>(){

                @Override
                public T getLootCreator(AbstractRegistrate<?> parent, Consumer<T> callback, FabricDataGenerator generator) {
                    return (RegistrateLootTables)factory.apply(parent, callback, generator);
                }

                @Override
                public class_176 getLootSet() {
                    return set;
                }
            };
            LOOT_TYPES.put(name, type);
            return type;
        }
    }
}

