/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.controls.collection;

import java.util.ArrayList;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_3417;
import net.minecraft.class_4587;
import team.creative.creativecore.client.render.text.CompiledText;
import team.creative.creativecore.common.gui.GuiChildControl;
import team.creative.creativecore.common.gui.controls.collection.GuiComboBox;
import team.creative.creativecore.common.gui.controls.collection.GuiListBoxBase;
import team.creative.creativecore.common.gui.controls.simple.GuiLabel;
import team.creative.creativecore.common.util.math.geo.Rect;
import team.creative.creativecore.common.util.mc.ColorUtils;

public class GuiComboBoxExtension
extends GuiListBoxBase<GuiComboBoxEntry> {
    public GuiComboBox comboBox;

    public GuiComboBoxExtension(String name, GuiComboBox comboBox) {
        super(name, false, new ArrayList());
        this.comboBox = comboBox;
        ArrayList<GuiComboBoxEntry> entries = new ArrayList<GuiComboBoxEntry>();
        for (int i = 0; i < comboBox.lines.length; ++i) {
            entries.add(new GuiComboBoxEntry("" + i, i, i == comboBox.getIndex()).set(comboBox.lines[i].copy()));
        }
        this.addAllItems(entries);
    }

    @Override
    public void looseFocus() {
        this.comboBox.extensionLostFocus = true;
    }

    @Override
    public boolean mouseClicked(Rect rect, double x, double y, int button) {
        if (super.mouseClicked(rect, x, y, button)) {
            this.comboBox.extensionLostFocus = false;
            return true;
        }
        return false;
    }

    @Override
    public int getMaxHeight() {
        return 100;
    }

    public class GuiComboBoxEntry
    extends GuiLabel {
        public final int index;
        public final boolean selected;

        public GuiComboBoxEntry(String name, int index, boolean selected) {
            super(name);
            this.index = index;
            this.selected = selected;
            this.setExpandableX();
        }

        public GuiComboBoxEntry set(CompiledText text) {
            this.text = text;
            return this;
        }

        @Override
        @Environment(value=EnvType.CLIENT)
        protected void renderContent(class_4587 matrix, GuiChildControl control, Rect rect, int mouseX, int mouseY) {
            this.text.defaultColor = this.selected ? (rect.inside(mouseX, mouseY) ? ColorUtils.rgba(230, 230, 0, 255) : ColorUtils.rgba(200, 200, 0, 255)) : (rect.inside(mouseX, mouseY) ? -256 : -1);
            super.renderContent(matrix, control, rect, mouseX, mouseY);
            this.text.defaultColor = -1;
        }

        @Override
        public boolean mouseClicked(Rect rect, double x, double y, int button) {
            GuiComboBoxExtension.this.comboBox.select(this.index);
            GuiComboBoxExtension.this.comboBox.closeBox();
            GuiComboBoxEntry.playSound(class_3417.field_15015);
            return true;
        }
    }
}

