/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.util.math.box;

import net.minecraft.class_238;
import team.creative.creativecore.common.util.math.base.Axis;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.math.box.BoxCorner;
import team.creative.creativecore.common.util.math.collision.CollisionCoordinator;
import team.creative.creativecore.common.util.math.matrix.IVecOrigin;
import team.creative.creativecore.common.util.math.matrix.Matrix3;
import team.creative.creativecore.common.util.math.transformation.BooleanRotation;
import team.creative.creativecore.common.util.math.vec.Vec3d;

public class BoxUtils {
    public static boolean equals(double a, double b, double deviation) {
        return a == b ? true : Math.abs(a - b) < deviation;
    }

    public static boolean greaterEquals(double a, double b, double deviation) {
        return a >= (b > 0.0 ? b - deviation : b + deviation);
    }

    public static boolean insideRect(double one, double two, double minOne, double minTwo, double maxOne, double maxTwo) {
        return one > minOne && one < maxOne && two > minTwo && two < maxTwo;
    }

    public static Vec3d[] getCorners(class_238 box) {
        Vec3d[] corners = new Vec3d[BoxCorner.values().length];
        for (int i = 0; i < corners.length; ++i) {
            corners[i] = BoxCorner.values()[i].get(box);
        }
        return corners;
    }

    private static double lengthIgnoreAxis(Vec3d vec, Axis axis) {
        return switch (axis) {
            case Axis.X -> Math.sqrt(vec.y * vec.y + vec.z * vec.z);
            case Axis.Y -> Math.sqrt(vec.x * vec.x + vec.z * vec.z);
            case Axis.Z -> Math.sqrt(vec.x * vec.x + vec.y * vec.y);
            default -> 0.0;
        };
    }

    private static void includeMaxRotationInBox(IncludeBox box, Vec3d vec, Axis axis, CollisionCoordinator coordinator) {
        Facing facing;
        int quarterRotation;
        double rotation = coordinator.getRotationDegree(axis);
        if (rotation == 0.0) {
            return;
        }
        Matrix3 matrix = coordinator.getRotationMatrix(axis);
        Double length = null;
        BooleanRotation state = BooleanRotation.get(axis, vec);
        boolean positive = rotation > 0.0;
        if (rotation >= 90.0) {
            for (quarterRotation = 90; (double)quarterRotation <= Math.abs(rotation) && quarterRotation < 360; quarterRotation += 90) {
                Facing facing2 = facing = positive ? state.clockwiseMaxFacing() : state.counterMaxClockwiseFacing();
                if (length == null) {
                    length = BoxUtils.lengthIgnoreAxis(vec, axis);
                }
                box.include(facing, length);
                if (coordinator.translation != null) {
                    box.include(facing, length + coordinator.translation.get(facing.axis));
                }
                state = state.clockwise();
            }
        }
        matrix.transform(vec);
        box.include(vec);
        if (quarterRotation <= 360 && !state.is(vec)) {
            Facing facing3 = facing = positive ? state.clockwiseMaxFacing() : state.counterMaxClockwiseFacing();
            if (length == null) {
                length = BoxUtils.lengthIgnoreAxis(vec, axis);
            }
            box.include(facing, length);
            if (coordinator.translation != null) {
                box.include(facing, length + coordinator.translation.get(facing.axis));
            }
        }
    }

    public static class_238 getRotatedSurrounding(class_238 boundingBox, CollisionCoordinator coordinator) {
        Vec3d[] corners = BoxUtils.getRotatedCorners(boundingBox, coordinator.origin);
        IncludeBox bb = new IncludeBox();
        for (Vec3d vec : corners) {
            bb.include(vec);
            if (coordinator.hasOnlyTranslation()) {
                vec.add(coordinator.translation);
                bb.include(vec);
                continue;
            }
            BoxUtils.includeMaxRotationInBox(bb, new Vec3d(vec), Axis.X, coordinator);
            BoxUtils.includeMaxRotationInBox(bb, new Vec3d(vec), Axis.Y, coordinator);
            BoxUtils.includeMaxRotationInBox(bb, new Vec3d(vec), Axis.Z, coordinator);
            coordinator.transform(vec, 1.0);
            bb.include(vec);
        }
        return bb.getAxisBB();
    }

    public static Vec3d[] getRotatedCorners(class_238 box, IVecOrigin origin) {
        Vec3d[] corners;
        for (Vec3d vec : corners = BoxUtils.getCorners(box)) {
            origin.transformPointToWorld(vec);
        }
        return corners;
    }

    public static Vec3d[] getOuterCorner(Facing facing, IVecOrigin origin, class_238 box, double minOne, double minTwo, double maxOne, double maxTwo) {
        Vec3d[] corners = BoxUtils.getCorners(box);
        double value = 0.0;
        Enum selected = null;
        Axis axis = facing.axis;
        for (int i = 0; i < corners.length; ++i) {
            Vec3d vec = corners[i];
            origin.transformPointToWorld(vec);
            double vectorValue = vec.get(axis);
            if (selected != null && !(facing.positive ? vectorValue > value : vectorValue < value)) continue;
            selected = BoxCorner.values()[i];
            value = vectorValue;
        }
        return new Vec3d[]{corners[selected.ordinal()], corners[((BoxCorner)selected).neighborOne.ordinal()], corners[((BoxCorner)selected).neighborTwo.ordinal()], corners[((BoxCorner)selected).neighborThree.ordinal()]};
    }

    private static class IncludeBox {
        public double minX = Double.MAX_VALUE;
        public double minY = Double.MAX_VALUE;
        public double minZ = Double.MAX_VALUE;
        public double maxX = -1.7976931348623157E308;
        public double maxY = -1.7976931348623157E308;
        public double maxZ = -1.7976931348623157E308;

        public void include(Vec3d vec) {
            this.minX = Math.min(this.minX, vec.x);
            this.minY = Math.min(this.minY, vec.y);
            this.minZ = Math.min(this.minZ, vec.z);
            this.maxX = Math.max(this.maxX, vec.x);
            this.maxY = Math.max(this.maxY, vec.y);
            this.maxZ = Math.max(this.maxZ, vec.z);
        }

        public void include(Facing facing, double value) {
            switch (facing) {
                case EAST: {
                    this.maxX = Math.max(this.maxX, value);
                    break;
                }
                case WEST: {
                    this.minX = Math.min(this.minX, value);
                    break;
                }
                case UP: {
                    this.maxY = Math.max(this.maxY, value);
                    break;
                }
                case DOWN: {
                    this.minY = Math.min(this.minY, value);
                    break;
                }
                case SOUTH: {
                    this.maxZ = Math.max(this.maxZ, value);
                    break;
                }
                case NORTH: {
                    this.minZ = Math.min(this.minZ, value);
                }
            }
        }

        public class_238 getAxisBB() {
            return new class_238(this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
        }
    }
}

