/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.modmenu.util.mod;

import com.terraformersmc.modmenu.util.mod.fabric.FabricIconHandler;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_1043;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Mod {
    @NotNull
    public String getId();

    @NotNull
    public String getName();

    @NotNull
    public class_1043 getIcon(FabricIconHandler var1, int var2);

    @NotNull
    public String getSummary();

    @NotNull
    public String getDescription();

    @NotNull
    public String getVersion();

    @NotNull
    public String getPrefixedVersion();

    @NotNull
    public List<String> getAuthors();

    @NotNull
    public List<String> getContributors();

    @NotNull
    public List<String> getCredits();

    @NotNull
    public Set<Badge> getBadges();

    @Nullable
    public String getWebsite();

    @Nullable
    public String getIssueTracker();

    @Nullable
    public String getSource();

    @Nullable
    public String getParent();

    @NotNull
    public Set<String> getLicense();

    @NotNull
    public Map<String, String> getLinks();

    public boolean isReal();

    public static enum Badge {
        LIBRARY("modmenu.badge.library", -15698860, -16172759, "library"),
        CLIENT("modmenu.badge.clientsideOnly", -13939844, -15848875, null),
        DEPRECATED("modmenu.badge.deprecated", -8121306, -11334633, "deprecated"),
        PATCHWORK_FORGE("modmenu.badge.forge", -14734014, -15722719, null),
        MINECRAFT("modmenu.badge.minecraft", -9474966, -13553617, null);

        private final class_2561 text;
        private final int outlineColor;
        private final int fillColor;
        private final String key;
        private static final Map<String, Badge> KEY_MAP;

        private Badge(String translationKey, int outlineColor, int fillColor, String key) {
            this.text = new class_2588(translationKey);
            this.outlineColor = outlineColor;
            this.fillColor = fillColor;
            this.key = key;
        }

        public class_2561 getText() {
            return this.text;
        }

        public int getOutlineColor() {
            return this.outlineColor;
        }

        public int getFillColor() {
            return this.fillColor;
        }

        public static Set<Badge> convert(Set<String> badgeKeys) {
            return badgeKeys.stream().map(KEY_MAP::get).collect(Collectors.toSet());
        }

        static {
            KEY_MAP = new HashMap<String, Badge>();
            Arrays.stream(Badge.values()).forEach(badge -> KEY_MAP.put(badge.key, (Badge)((Object)badge)));
        }
    }
}

