/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.config;

import dev.architectury.platform.Platform;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.List;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.Comment;
import me.shedaniel.clothconfig2.api.Modifier;
import me.shedaniel.clothconfig2.api.ModifierKeyCode;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.config.entry.EntryStackProvider;
import me.shedaniel.rei.api.client.favorites.FavoriteEntry;
import me.shedaniel.rei.api.client.gui.config.AppearanceTheme;
import me.shedaniel.rei.api.client.gui.config.CheatingMode;
import me.shedaniel.rei.api.client.gui.config.ConfigButtonPosition;
import me.shedaniel.rei.api.client.gui.config.DisplayPanelLocation;
import me.shedaniel.rei.api.client.gui.config.DisplayScreenType;
import me.shedaniel.rei.api.client.gui.config.EntryPanelOrdering;
import me.shedaniel.rei.api.client.gui.config.EntryPanelOrderingConfig;
import me.shedaniel.rei.api.client.gui.config.FavoriteAddWidgetMode;
import me.shedaniel.rei.api.client.gui.config.ItemCheatingMode;
import me.shedaniel.rei.api.client.gui.config.ItemCheatingStyle;
import me.shedaniel.rei.api.client.gui.config.RecipeBorderType;
import me.shedaniel.rei.api.client.gui.config.SearchFieldLocation;
import me.shedaniel.rei.api.client.gui.config.SearchMode;
import me.shedaniel.rei.api.client.gui.config.SyntaxHighlightingMode;
import me.shedaniel.rei.impl.client.entry.filtering.FilteringRule;
import me.shedaniel.rei.impl.client.gui.widget.favorites.FavoritesEntriesManager;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1934;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3675;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@Config(name="roughlyenoughitems/config")
@ApiStatus.Internal
@Environment(value=EnvType.CLIENT)
public class ConfigObjectImpl
implements ConfigObject,
ConfigData {
    @ConfigEntry.Category(value="basics")
    @ConfigEntry.Gui.TransitiveObject
    @DontApplyFieldName
    public Basics basics = new Basics();
    @ConfigEntry.Category(value="appearance")
    @ConfigEntry.Gui.TransitiveObject
    @DontApplyFieldName
    private Appearance appearance = new Appearance();
    @ConfigEntry.Category(value="functionality")
    @ConfigEntry.Gui.TransitiveObject
    @DontApplyFieldName
    private Functionality functionality = new Functionality();
    @ConfigEntry.Category(value="advanced")
    @ConfigEntry.Gui.TransitiveObject
    @DontApplyFieldName
    public Advanced advanced = new Advanced();

    @Override
    public boolean isOverlayVisible() {
        return this.basics.overlayVisible;
    }

    @Override
    public void setOverlayVisible(boolean overlayVisible) {
        this.basics.overlayVisible = overlayVisible;
    }

    @Override
    public boolean isCheating() {
        return this.basics.cheating == CheatingMode.ON || this.basics.cheating == CheatingMode.WHEN_CREATIVE && class_310.method_1551().field_1761 != null && class_310.method_1551().field_1761.method_2920() == class_1934.field_9220;
    }

    @Override
    public void setCheating(boolean cheating) {
        this.basics.cheating = cheating ? CheatingMode.ON : CheatingMode.OFF;
    }

    @Override
    public CheatingMode getCheatingMode() {
        return this.basics.cheating;
    }

    @Override
    public EntryPanelOrdering getItemListOrdering() {
        return this.advanced.layout.entryPanelOrdering.getOrdering();
    }

    @Override
    public boolean isItemListAscending() {
        return this.advanced.layout.entryPanelOrdering.isAscending();
    }

    @Override
    public boolean isUsingDarkTheme() {
        return this.appearance.theme == AppearanceTheme.DARK;
    }

    public void setUsingDarkTheme(boolean dark) {
        this.appearance.theme = dark ? AppearanceTheme.DARK : AppearanceTheme.LIGHT;
    }

    @Override
    public boolean isGrabbingItems() {
        return this.basics.cheatingStyle == ItemCheatingStyle.GRAB;
    }

    @Override
    public boolean isFavoritesAnimated() {
        return this.basics.motion.favoritesAnimation;
    }

    @Override
    public boolean isToastDisplayedOnCopyIdentifier() {
        return this.advanced.accessibility.toastDisplayedOnCopyIdentifier;
    }

    @Override
    public boolean isEntryListWidgetScrolled() {
        return this.appearance.scrollingEntryListWidget;
    }

    public void setEntryListWidgetScrolled(boolean scrollingEntryListWidget) {
        this.appearance.scrollingEntryListWidget = scrollingEntryListWidget;
    }

    @Override
    public boolean shouldAppendModNames() {
        return this.advanced.tooltips.appendModNames;
    }

    @Override
    public DisplayScreenType getRecipeScreenType() {
        return this.appearance.recipeScreenType;
    }

    @Override
    public void setRecipeScreenType(DisplayScreenType displayScreenType) {
        this.appearance.recipeScreenType = displayScreenType;
    }

    @Override
    public SearchFieldLocation getSearchFieldLocation() {
        return this.appearance.layout.searchFieldLocation;
    }

    public void setSearchFieldLocation(SearchFieldLocation location) {
        this.appearance.layout.searchFieldLocation = location;
    }

    @Override
    public DisplayPanelLocation getDisplayPanelLocation() {
        return this.advanced.accessibility.displayPanelLocation;
    }

    public void setDisplayPanelLocation(DisplayPanelLocation location) {
        this.advanced.accessibility.displayPanelLocation = location;
    }

    @Override
    public boolean isCraftableFilterEnabled() {
        return this.appearance.layout.showCraftableOnlyButton;
    }

    public void setCraftableFilterEnabled(boolean enabled) {
        this.appearance.layout.showCraftableOnlyButton = enabled;
    }

    @Override
    public String getGamemodeCommand() {
        return this.advanced.commands.gamemodeCommand;
    }

    @Override
    public String getGiveCommand() {
        return this.advanced.commands.giveCommand;
    }

    @Override
    public String getWeatherCommand() {
        return this.advanced.commands.weatherCommand;
    }

    @Override
    public String getTimeCommand() {
        return this.advanced.commands.timeCommand;
    }

    @Override
    public int getMaxRecipePerPage() {
        return this.advanced.layout.maxRecipesPerPage;
    }

    @Override
    public int getMaxRecipesPageHeight() {
        return this.advanced.layout.maxRecipesPageHeight;
    }

    @Override
    @Nullable
    public class_2960 getInputMethodId() {
        return this.functionality.inputMethod;
    }

    public void setInputMethodId(@Nullable class_2960 id) {
        this.functionality.inputMethod = id;
    }

    @Override
    public boolean doesDisableRecipeBook() {
        return this.functionality.disableRecipeBook;
    }

    public void setDisableRecipeBook(boolean disableRecipeBook) {
        this.functionality.disableRecipeBook = disableRecipeBook;
    }

    @Override
    public boolean doesFixTabCloseContainer() {
        return this.functionality.disableRecipeBook;
    }

    @Override
    public boolean isLeftSideMobEffects() {
        return this.functionality.leftSideMobEffects;
    }

    public void setLeftSideMobEffects(boolean leftSideMobEffects) {
        this.functionality.leftSideMobEffects = leftSideMobEffects;
    }

    @Override
    public boolean areClickableRecipeArrowsEnabled() {
        return this.advanced.miscellaneous.clickableRecipeArrows;
    }

    @Override
    public RecipeBorderType getRecipeBorderType() {
        return this.appearance.recipeBorder;
    }

    @Override
    public boolean isCompositeScrollBarPermanent() {
        return this.advanced.accessibility.compositeScrollBarPermanent;
    }

    @Override
    public boolean doesRegisterRecipesInAnotherThread() {
        return this.advanced.miscellaneous.registerRecipesInAnotherThread;
    }

    @Override
    public boolean doesSnapToRows() {
        return false;
    }

    @Override
    public boolean isFavoritesEnabled() {
        return this.basics.favoritesEnabled;
    }

    @Override
    public boolean doDisplayFavoritesTooltip() {
        return this.isFavoritesEnabled() && this.advanced.tooltips.displayFavoritesTooltip;
    }

    @Override
    public boolean doesFastEntryRendering() {
        return this.advanced.miscellaneous.newFastEntryRendering;
    }

    @Override
    public boolean doesCacheEntryRendering() {
        return this.advanced.miscellaneous.cachingFastEntryRendering;
    }

    public void setDoesCacheEntryRendering(boolean doesCacheEntryRendering) {
        this.advanced.miscellaneous.cachingFastEntryRendering = doesCacheEntryRendering;
    }

    @Override
    public boolean doDebugRenderTimeRequired() {
        return this.advanced.layout.debugRenderTimeRequired;
    }

    @Override
    public boolean doMergeDisplayUnderOne() {
        return this.advanced.layout.mergeDisplayUnderOne;
    }

    @Override
    public FavoriteAddWidgetMode getFavoriteAddWidgetMode() {
        return this.advanced.layout.favoriteAddWidgetMode;
    }

    @Override
    public ModifierKeyCode getFavoriteKeyCode() {
        return this.basics.keyBindings.favoriteKeybind == null ? ModifierKeyCode.unknown() : this.basics.keyBindings.favoriteKeybind;
    }

    @Override
    public ModifierKeyCode getRecipeKeybind() {
        return this.basics.keyBindings.recipeKeybind == null ? ModifierKeyCode.unknown() : this.basics.keyBindings.recipeKeybind;
    }

    @Override
    public ModifierKeyCode getUsageKeybind() {
        return this.basics.keyBindings.usageKeybind == null ? ModifierKeyCode.unknown() : this.basics.keyBindings.usageKeybind;
    }

    @Override
    public ModifierKeyCode getHideKeybind() {
        return this.basics.keyBindings.hideKeybind == null ? ModifierKeyCode.unknown() : this.basics.keyBindings.hideKeybind;
    }

    @Override
    public ModifierKeyCode getPreviousPageKeybind() {
        return this.basics.keyBindings.previousPageKeybind == null ? ModifierKeyCode.unknown() : this.basics.keyBindings.previousPageKeybind;
    }

    @Override
    public ModifierKeyCode getNextPageKeybind() {
        return this.basics.keyBindings.nextPageKeybind == null ? ModifierKeyCode.unknown() : this.basics.keyBindings.nextPageKeybind;
    }

    @Override
    public ModifierKeyCode getFocusSearchFieldKeybind() {
        return this.basics.keyBindings.focusSearchFieldKeybind == null ? ModifierKeyCode.unknown() : this.basics.keyBindings.focusSearchFieldKeybind;
    }

    @Override
    public ModifierKeyCode getCopyRecipeIdentifierKeybind() {
        return this.basics.keyBindings.copyRecipeIdentifierKeybind == null ? ModifierKeyCode.unknown() : this.basics.keyBindings.copyRecipeIdentifierKeybind;
    }

    @Override
    public ModifierKeyCode getExportImageKeybind() {
        return this.basics.keyBindings.exportImageKeybind == null ? ModifierKeyCode.unknown() : this.basics.keyBindings.exportImageKeybind;
    }

    @Override
    public ModifierKeyCode getPreviousScreenKeybind() {
        return this.basics.keyBindings.previousScreenKeybind == null ? ModifierKeyCode.unknown() : this.basics.keyBindings.previousScreenKeybind;
    }

    @Override
    public double getEntrySize() {
        return this.advanced.accessibility.entrySize;
    }

    public boolean setEntrySize(double entrySize) {
        double original = this.advanced.accessibility.entrySize;
        this.advanced.accessibility.entrySize = class_3532.method_15350((double)entrySize, (double)0.25, (double)4.0);
        return this.advanced.accessibility.entrySize != original;
    }

    @Override
    public boolean isUsingCompactTabs() {
        return this.advanced.accessibility.useCompactTabs;
    }

    @Override
    public boolean isUsingCompactTabButtons() {
        return this.advanced.accessibility.useCompactTabButtons;
    }

    @Override
    public boolean isLowerConfigButton() {
        return this.appearance.layout.configButtonLocation == ConfigButtonPosition.LOWER;
    }

    @Override
    public List<FavoriteEntry> getFavoriteEntries() {
        return FavoritesEntriesManager.INSTANCE.asListView();
    }

    public List<FavoriteEntry> getConfigFavoriteEntries() {
        return this.basics.favorites;
    }

    public List<FavoriteEntry> getHiddenFavoriteEntries() {
        return this.basics.hiddenFavorites;
    }

    public List<class_2487> getDisplayHistory() {
        return this.basics.displayHistory;
    }

    @Override
    public List<EntryStackProvider<?>> getFilteredStackProviders() {
        return this.advanced.filtering.filteredStacks;
    }

    @Override
    @ApiStatus.Experimental
    public boolean shouldFilterDisplays() {
        return this.advanced.filtering.shouldFilterDisplays;
    }

    @ApiStatus.Internal
    public List<FilteringRule<?>> getFilteringRules() {
        return this.advanced.filtering.filteringRules;
    }

    @Override
    @ApiStatus.Experimental
    public boolean shouldAsyncSearch() {
        return this.advanced.search.asyncSearch;
    }

    @Override
    @ApiStatus.Experimental
    public int getAsyncSearchPartitionSize() {
        return this.advanced.search.asyncSearchPartitionSize;
    }

    @Override
    @ApiStatus.Experimental
    public boolean isPatchingAsyncThreadCrash() {
        return this.advanced.search.patchAsyncThreadCrash;
    }

    @Override
    @ApiStatus.Experimental
    public boolean doDebugSearchTimeRequired() {
        return this.advanced.search.debugSearchTimeRequired;
    }

    @Override
    public boolean isSubsetsEnabled() {
        return this.functionality.isSubsetsEnabled;
    }

    @Override
    public boolean isInventoryHighlightingAllowed() {
        return this.functionality.allowInventoryHighlighting;
    }

    @Override
    public ItemCheatingMode getItemCheatingMode() {
        return this.functionality.itemCheatingMode;
    }

    @Override
    @ApiStatus.Experimental
    public double getHorizontalEntriesBoundariesPercentage() {
        return class_3532.method_15350((double)this.appearance.horizontalEntriesBoundaries, (double)0.1, (double)1.0);
    }

    @Override
    @ApiStatus.Experimental
    public double getVerticalEntriesBoundariesPercentage() {
        return class_3532.method_15350((double)this.appearance.verticalEntriesBoundaries, (double)0.1, (double)1.0);
    }

    @Override
    @ApiStatus.Experimental
    public double getHorizontalEntriesBoundariesColumns() {
        return class_3532.method_15340((int)this.appearance.horizontalEntriesBoundariesColumns, (int)1, (int)1000);
    }

    @Override
    @ApiStatus.Experimental
    public double getVerticalEntriesBoundariesRows() {
        return class_3532.method_15340((int)this.appearance.verticalEntriesBoundariesRows, (int)1, (int)1000);
    }

    @Override
    @ApiStatus.Experimental
    public double getFavoritesHorizontalEntriesBoundariesPercentage() {
        return class_3532.method_15350((double)this.appearance.favoritesHorizontalEntriesBoundaries, (double)0.1, (double)1.0);
    }

    @Override
    public double getFavoritesHorizontalEntriesBoundariesColumns() {
        return class_3532.method_15340((int)this.appearance.favoritesHorizontalEntriesBoundariesColumns, (int)1, (int)1000);
    }

    @Override
    public SyntaxHighlightingMode getSyntaxHighlightingMode() {
        return this.appearance.syntaxHighlightingMode;
    }

    public void setSyntaxHighlightingMode(SyntaxHighlightingMode mode) {
        this.appearance.syntaxHighlightingMode = mode;
    }

    @Override
    public boolean isFocusModeZoomed() {
        return this.appearance.isFocusModeZoomed;
    }

    @Override
    public SearchMode getTooltipSearchMode() {
        return this.advanced.search.tooltipSearch;
    }

    @Override
    public SearchMode getTagSearchMode() {
        return this.advanced.search.tagSearch;
    }

    @Override
    public SearchMode getIdentifierSearchMode() {
        return this.advanced.search.identifierSearch;
    }

    @Override
    public SearchMode getModSearchMode() {
        return this.advanced.search.modSearch;
    }

    @Override
    public boolean isJEICompatibilityLayerEnabled() {
        return Platform.isForge() && this.advanced.enableJeiCompatibilityLayer;
    }

    public void setJEICompatibilityLayerEnabled(boolean value) {
        this.advanced.enableJeiCompatibilityLayer = value;
    }

    public static class Basics {
        @ConfigEntry.Gui.Excluded
        public List<FavoriteEntry> favorites = new ArrayList<FavoriteEntry>();
        @ConfigEntry.Gui.Excluded
        public List<FavoriteEntry> hiddenFavorites = new ArrayList<FavoriteEntry>();
        @ConfigEntry.Gui.Excluded
        public List<class_2487> displayHistory = new ArrayList<class_2487>();
        @Comment(value="Declares whether cheating mode is on.")
        @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
        private CheatingMode cheating = CheatingMode.OFF;
        private boolean favoritesEnabled = true;
        @ConfigEntry.Gui.CollapsibleObject(startExpanded=true)
        private KeyBindings keyBindings = new KeyBindings();
        @Comment(value="Declares whether REI is visible.")
        @ConfigEntry.Gui.Excluded
        private boolean overlayVisible = true;
        @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
        private ItemCheatingStyle cheatingStyle = ItemCheatingStyle.GRAB;
        @ConfigEntry.Gui.CollapsibleObject
        private Motion motion = new Motion();
    }

    public static class Appearance {
        @UseSpecialRecipeTypeScreen
        private DisplayScreenType recipeScreenType = DisplayScreenType.UNSET;
        @Comment(value="Declares the appearance of REI windows.")
        @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
        private AppearanceTheme theme = AppearanceTheme.LIGHT;
        @ConfigEntry.Gui.CollapsibleObject(startExpanded=true)
        private Layout layout = new Layout();
        @Comment(value="Declares the appearance of recipe's border.")
        @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
        private RecipeBorderType recipeBorder = RecipeBorderType.DEFAULT;
        @Comment(value="Declares whether entry panel is scrolled.")
        private boolean scrollingEntryListWidget = false;
        @UsePercentage(min=0.1, max=1.0, prefix="Limit: ")
        private double horizontalEntriesBoundaries = 1.0;
        @UsePercentage(min=0.1, max=1.0, prefix="Limit: ")
        private double verticalEntriesBoundaries = 1.0;
        private int horizontalEntriesBoundariesColumns = 50;
        private int verticalEntriesBoundariesRows = 1000;
        @UsePercentage(min=0.1, max=1.0, prefix="Limit: ")
        private double favoritesHorizontalEntriesBoundaries = 1.0;
        private int favoritesHorizontalEntriesBoundariesColumns = 50;
        @UseSpecialSearchFilterSyntaxHighlightingScreen
        private SyntaxHighlightingMode syntaxHighlightingMode = SyntaxHighlightingMode.COLORFUL;
        private boolean isFocusModeZoomed = false;

        public static class Layout {
            @Comment(value="Declares the position of the search field.")
            @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
            private SearchFieldLocation searchFieldLocation = SearchFieldLocation.CENTER;
            @Comment(value="Declares the position of the config button.")
            @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
            private ConfigButtonPosition configButtonLocation = ConfigButtonPosition.LOWER;
            @Comment(value="Declares whether the craftable filter button is enabled.")
            private boolean showCraftableOnlyButton = true;
        }
    }

    public static class Functionality {
        @ConfigEntry.Gui.Excluded
        @Nullable
        private class_2960 inputMethod = null;
        @Comment(value="Declares whether REI should remove the recipe book.")
        private boolean disableRecipeBook = false;
        @Comment(value="Declares whether mob effects should be on the left side instead of the right side.")
        private boolean leftSideMobEffects = false;
        @Comment(value="Declares whether subsets is enabled.")
        private boolean isSubsetsEnabled = false;
        private boolean allowInventoryHighlighting = true;
        @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
        private ItemCheatingMode itemCheatingMode = ItemCheatingMode.REI_LIKE;
    }

    public static class Advanced {
        @ConfigEntry.Gui.CollapsibleObject
        private Tooltips tooltips = new Tooltips();
        @ConfigEntry.Gui.CollapsibleObject
        private Layout layout = new Layout();
        @ConfigEntry.Gui.CollapsibleObject
        private Accessibility accessibility = new Accessibility();
        @ConfigEntry.Gui.CollapsibleObject
        private Search search = new Search();
        @ConfigEntry.Gui.CollapsibleObject
        private Commands commands = new Commands();
        @ConfigEntry.Gui.CollapsibleObject
        private Miscellaneous miscellaneous = new Miscellaneous();
        @ConfigEntry.Gui.CollapsibleObject(startExpanded=true)
        public Filtering filtering = new Filtering();
        @ConfigEntry.Gui.Excluded
        public boolean enableJeiCompatibilityLayer = true;

        public static class Tooltips {
            @Comment(value="Declares whether REI should append mod names to entries.")
            private boolean appendModNames = true;
            @Comment(value="Declares whether favorites tooltip should be displayed.")
            private boolean displayFavoritesTooltip = false;
        }

        public static class Layout {
            @Comment(value="The ordering of the items on the entry panel.")
            @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
            private EntryPanelOrderingConfig entryPanelOrdering = EntryPanelOrderingConfig.REGISTRY_ASCENDING;
            @Comment(value="Declares the maximum amount of recipes displayed in a page if possible.")
            @ConfigEntry.BoundedDiscrete(min=2L, max=99L)
            private int maxRecipesPerPage = 8;
            @Comment(value="Declares the maximum amount of recipes displayed in a page if possible.")
            @ConfigEntry.BoundedDiscrete(min=100L, max=1000L)
            private int maxRecipesPageHeight = 300;
            @Comment(value="Declares whether entry rendering time should be debugged.")
            private boolean debugRenderTimeRequired = false;
            @Comment(value="Merges displays with equal contents under 1 display.")
            private boolean mergeDisplayUnderOne = true;
            @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
            private FavoriteAddWidgetMode favoriteAddWidgetMode = FavoriteAddWidgetMode.ALWAYS_VISIBLE;
        }

        public static class Accessibility {
            @UsePercentage(min=0.25, max=4.0)
            private double entrySize = 1.0;
            @Comment(value="Declares the position of the entry panel.")
            @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
            private DisplayPanelLocation displayPanelLocation = DisplayPanelLocation.RIGHT;
            @Comment(value="Declares how the scrollbar in composite screen should act.")
            private boolean compositeScrollBarPermanent = false;
            private boolean toastDisplayedOnCopyIdentifier = true;
            @Comment(value="Declares whether REI should use compact tabs for categories.")
            private boolean useCompactTabs = true;
            @Comment(value="Declares whether REI should use compact tab buttons for categories.")
            private boolean useCompactTabButtons = true;
        }

        public static class Search {
            @Comment(value="Declares whether search time should be debugged.")
            private boolean debugSearchTimeRequired = false;
            @Comment(value="Declares whether REI should search async.")
            private boolean asyncSearch = true;
            @Comment(value="Declares how many entries should be grouped one async search.")
            @ConfigEntry.BoundedDiscrete(min=25L, max=400L)
            private int asyncSearchPartitionSize = 100;
            private boolean patchAsyncThreadCrash = true;
            @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
            private SearchMode tooltipSearch = SearchMode.ALWAYS;
            @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
            private SearchMode tagSearch = SearchMode.PREFIX;
            @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
            private SearchMode identifierSearch = SearchMode.ALWAYS;
            @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
            private SearchMode modSearch = SearchMode.PREFIX;
        }

        public static class Commands {
            @Comment(value="Declares the command used to change gamemode.")
            private String gamemodeCommand = "/gamemode {gamemode}";
            @Comment(value="Declares the command used in servers to cheat items.")
            private String giveCommand = "/give {player_name} {item_identifier}{nbt} {count}";
            @Comment(value="Declares the command used to change weather.")
            private String weatherCommand = "/weather {weather}";
            @Comment(value="Declares the command used to change time.")
            private String timeCommand = "/time set {time}";
        }

        public static class Miscellaneous {
            @Comment(value="Declares whether arrows in containers should be clickable.")
            private boolean clickableRecipeArrows = true;
            private boolean registerRecipesInAnotherThread = true;
            private boolean newFastEntryRendering = true;
            @ConfigEntry.Gui.PrefixText
            private boolean cachingFastEntryRendering = false;
        }

        public static class Filtering {
            @UseFilteringScreen
            private List<EntryStackProvider<?>> filteredStacks = new ArrayList();
            public boolean shouldFilterDisplays = true;
            @ConfigEntry.Gui.Excluded
            public List<FilteringRule<?>> filteringRules = new ArrayList();
        }
    }

    public static class Motion {
        private boolean favoritesAnimation = true;
    }

    public static class KeyBindings {
        private ModifierKeyCode recipeKeybind = ModifierKeyCode.of((class_3675.class_306)class_3675.class_307.field_1668.method_1447(82), (Modifier)Modifier.none());
        private ModifierKeyCode usageKeybind = ModifierKeyCode.of((class_3675.class_306)class_3675.class_307.field_1668.method_1447(85), (Modifier)Modifier.none());
        private ModifierKeyCode hideKeybind = ModifierKeyCode.of((class_3675.class_306)class_3675.class_307.field_1668.method_1447(79), (Modifier)Modifier.of((boolean)false, (boolean)true, (boolean)false));
        private ModifierKeyCode previousPageKeybind = ModifierKeyCode.unknown();
        private ModifierKeyCode nextPageKeybind = ModifierKeyCode.unknown();
        private ModifierKeyCode focusSearchFieldKeybind = ModifierKeyCode.unknown();
        private ModifierKeyCode copyRecipeIdentifierKeybind = ModifierKeyCode.of((class_3675.class_306)class_3675.class_307.field_1672.method_1447(2), (Modifier)Modifier.none());
        private ModifierKeyCode favoriteKeybind = ModifierKeyCode.of((class_3675.class_306)class_3675.class_307.field_1668.method_1447(65), (Modifier)Modifier.none());
        private ModifierKeyCode exportImageKeybind = ModifierKeyCode.of((class_3675.class_306)class_3675.class_307.field_1668.method_1447(297), (Modifier)Modifier.none());
        private ModifierKeyCode previousScreenKeybind = ModifierKeyCode.of((class_3675.class_306)class_3675.class_307.field_1668.method_1447(259), (Modifier)Modifier.none());
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    static @interface UsePercentage {
        public double min();

        public double max();

        public String prefix() default "Size: ";
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    static @interface UseFilteringScreen {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    static @interface UseSpecialSearchFilterSyntaxHighlightingScreen {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    static @interface UseSpecialRecipeTypeScreen {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    static @interface DontApplyFieldName {
    }
}

