/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization;

import aztech.modern_industrialization.MIBlock;
import aztech.modern_industrialization.MIBlockEntityTypes;
import aztech.modern_industrialization.MIFluids;
import aztech.modern_industrialization.MIIdentifier;
import aztech.modern_industrialization.MIItem;
import aztech.modern_industrialization.MITags;
import aztech.modern_industrialization.api.FluidFuelRegistry;
import aztech.modern_industrialization.api.ScrewdriverableBlockEntity;
import aztech.modern_industrialization.api.WrenchableBlockEntity;
import aztech.modern_industrialization.blocks.forgehammer.ForgeHammerScreenHandler;
import aztech.modern_industrialization.definition.BlockDefinition;
import aztech.modern_industrialization.definition.FluidDefinition;
import aztech.modern_industrialization.definition.ItemDefinition;
import aztech.modern_industrialization.inventory.ConfigurableInventoryPacketHandlers;
import aztech.modern_industrialization.inventory.ConfigurableInventoryPackets;
import aztech.modern_industrialization.items.armor.ArmorPackets;
import aztech.modern_industrialization.items.armor.MIArmorEffects;
import aztech.modern_industrialization.items.armor.MIKeyMap;
import aztech.modern_industrialization.machines.MachinePackets;
import aztech.modern_industrialization.machines.MachineScreenHandlers;
import aztech.modern_industrialization.machines.init.MIMachineRecipeTypes;
import aztech.modern_industrialization.machines.init.MultiblockHatches;
import aztech.modern_industrialization.machines.init.MultiblockMachines;
import aztech.modern_industrialization.machines.init.SingleBlockCraftingMachines;
import aztech.modern_industrialization.machines.init.SingleBlockSpecialMachines;
import aztech.modern_industrialization.machines.multiblocks.world.ChunkEventListeners;
import aztech.modern_industrialization.materials.MIMaterials;
import aztech.modern_industrialization.misc.autotest.MIAutoTesting;
import aztech.modern_industrialization.misc.guidebook.GuidebookEvents;
import aztech.modern_industrialization.nuclear.NuclearItem;
import aztech.modern_industrialization.pipes.MIPipes;
import aztech.modern_industrialization.proxy.CommonProxy;
import java.util.Comparator;
import java.util.Map;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.client.itemgroup.FabricItemGroupBuilder;
import net.fabricmc.fabric.api.entity.event.v1.ServerEntityWorldChangeEvents;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.network.ServerSidePacketRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.object.builder.v1.block.FabricMaterialBuilder;
import net.fabricmc.fabric.api.registry.FuelRegistry;
import net.fabricmc.fabric.api.screenhandler.v1.ScreenHandlerRegistry;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3614;
import net.minecraft.class_3620;
import net.minecraft.class_3917;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModernIndustrialization
implements ModInitializer {
    public static final String MOD_ID = "modern_industrialization";
    public static final Logger LOGGER = LogManager.getLogger((String)"Modern Industrialization");
    public static final class_3614 METAL_MATERIAL = new FabricMaterialBuilder(class_3620.field_16005).method_15813();
    public static final class_3614 STONE_MATERIAL = new FabricMaterialBuilder(class_3620.field_16023).method_15813();
    public static final class_1761 ITEM_GROUP = FabricItemGroupBuilder.build((class_2960)new class_2960("modern_industrialization", "general"), () -> new class_1799((class_1935)class_2378.field_11142.method_10223((class_2960)new MIIdentifier("forge_hammer"))));
    public static final class_3917<MachineScreenHandlers.Common> SCREEN_HANDLER_MACHINE = ScreenHandlerRegistry.registerExtended((class_2960)new MIIdentifier("machine"), MachineScreenHandlers::createClient);
    public static final class_3917<ForgeHammerScreenHandler> SCREEN_HANDLER_FORGE_HAMMER = ScreenHandlerRegistry.registerSimple((class_2960)new MIIdentifier("forge_hammer"), ForgeHammerScreenHandler::new);

    public void onInitialize() {
        MIMaterials.init();
        MIMachineRecipeTypes.init();
        SingleBlockCraftingMachines.init();
        SingleBlockSpecialMachines.init();
        MultiblockHatches.init();
        MultiblockMachines.init();
        NuclearItem.init();
        MIPipes.INSTANCE.setup();
        this.setupFluids();
        this.setupItems();
        this.setupBlocks();
        MIBlockEntityTypes.init();
        this.setupPackets();
        this.setupFuels();
        MIArmorEffects.init();
        this.setupWrench();
        ChunkEventListeners.init();
        ServerEntityWorldChangeEvents.AFTER_PLAYER_CHANGE_WORLD.register((player, oldWorld, newWorld) -> MIKeyMap.clear((class_1657)player));
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> MIKeyMap.clear((class_1657)handler.field_14140));
        GuidebookEvents.init();
        CommonProxy.initEvents();
        if (System.getProperty("modern_industrialization.autoTest") != null) {
            MIAutoTesting.init();
        }
        LOGGER.info("Modern Industrialization setup done!");
    }

    private void setupItems() {
        MIItem.ITEMS.entrySet().stream().sorted(Comparator.comparing(e -> ((ItemDefinition)e.getValue()).sortOrder)).forEach(entry -> {
            class_2378.method_10230((class_2378)class_2378.field_11142, (class_2960)((class_2960)entry.getKey()), ((ItemDefinition)entry.getValue()).method_8389());
            ((ItemDefinition)entry.getValue()).onRegister();
        });
    }

    private void setupBlocks() {
        for (Map.Entry<class_2960, BlockDefinition<?>> entry : MIBlock.BLOCKS.entrySet()) {
            class_2378.method_10230((class_2378)class_2378.field_11146, (class_2960)entry.getKey(), entry.getValue().asBlock());
            entry.getValue().onRegister();
        }
    }

    private void setupFluids() {
        for (Map.Entry<class_2960, FluidDefinition> entry : MIFluids.FLUIDS.entrySet()) {
            class_2378.method_10230((class_2378)class_2378.field_11146, (class_2960)entry.getKey(), (Object)((Object)entry.getValue().fluidBlock));
            class_2378.method_10230((class_2378)class_2378.field_11154, (class_2960)entry.getKey(), (Object)entry.getValue().asFluid());
        }
    }

    private void setupPackets() {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)ConfigurableInventoryPackets.SET_LOCKING_MODE, (ServerPlayNetworking.PlayChannelHandler)ConfigurableInventoryPacketHandlers.C2S.SET_LOCKING_MODE);
        ServerPlayNetworking.registerGlobalReceiver((class_2960)ConfigurableInventoryPackets.DO_SLOT_DRAGGING, (ServerPlayNetworking.PlayChannelHandler)ConfigurableInventoryPacketHandlers.C2S.DO_SLOT_DRAGGING);
        ServerPlayNetworking.registerGlobalReceiver((class_2960)ConfigurableInventoryPackets.ADJUST_SLOT_CAPACITY, (ServerPlayNetworking.PlayChannelHandler)ConfigurableInventoryPacketHandlers.C2S.ADJUST_SLOT_CAPACITY);
        ServerPlayNetworking.registerGlobalReceiver((class_2960)MachinePackets.C2S.SET_AUTO_EXTRACT, (ServerPlayNetworking.PlayChannelHandler)MachinePackets.C2S.ON_SET_AUTO_EXTRACT);
        ServerPlayNetworking.registerGlobalReceiver((class_2960)MachinePackets.C2S.REI_LOCK_SLOTS, (ServerPlayNetworking.PlayChannelHandler)MachinePackets.C2S.ON_REI_LOCK_SLOTS);
        ServerSidePacketRegistry.INSTANCE.register(ArmorPackets.UPDATE_KEYS, ArmorPackets.ON_UPDATE_KEYS);
        ServerSidePacketRegistry.INSTANCE.register(ArmorPackets.ACTIVATE_CHEST, ArmorPackets.ON_ACTIVATE_CHEST);
    }

    private static void addFuel(String id, int burnTicks) {
        class_1792 item = (class_1792)class_2378.field_11142.method_10223((class_2960)new MIIdentifier(id));
        if (item == class_1802.field_8162) {
            throw new IllegalArgumentException("Couldn't find item " + id);
        }
        FuelRegistry.INSTANCE.add((class_1935)item, (Object)burnTicks);
    }

    private void setupFuels() {
        ModernIndustrialization.addFuel("coke", 6400);
        ModernIndustrialization.addFuel("coke_dust", 6400);
        ModernIndustrialization.addFuel("coke_block", Short.MAX_VALUE);
        ModernIndustrialization.addFuel("coal_crushed_dust", 1600);
        FuelRegistry.INSTANCE.add(MITags.item("coal_dusts"), (Object)1600);
        ModernIndustrialization.addFuel("coal_tiny_dust", 160);
        ModernIndustrialization.addFuel("lignite_coal", 1600);
        ModernIndustrialization.addFuel("lignite_coal_block", 16000);
        ModernIndustrialization.addFuel("lignite_coal_crushed_dust", 1600);
        ModernIndustrialization.addFuel("lignite_coal_dust", 1600);
        ModernIndustrialization.addFuel("lignite_coal_tiny_dust", 160);
        ModernIndustrialization.addFuel("carbon_dust", 6400);
        ModernIndustrialization.addFuel("carbon_tiny_dust", 640);
        FluidFuelRegistry.register(MIFluids.HYDROGEN, 1);
        FluidFuelRegistry.register(MIFluids.DEUTERIUM, 1);
        FluidFuelRegistry.register(MIFluids.TRITIUM, 1);
        FluidFuelRegistry.register(MIFluids.CRUDE_OIL, 16);
        FluidFuelRegistry.register(MIFluids.SYNTHETIC_OIL, 16);
        FluidFuelRegistry.register(MIFluids.NAPHTHA, 80);
        FluidFuelRegistry.register(MIFluids.CREOSOTE, 160);
        FluidFuelRegistry.register(MIFluids.LIGHT_FUEL, 160);
        FluidFuelRegistry.register(MIFluids.HEAVY_FUEL, 240);
        FluidFuelRegistry.register(MIFluids.DIESEL, 400);
        FluidFuelRegistry.register(MIFluids.BOOSTED_DIESEL, 800);
    }

    private void setupWrench() {
        UseBlockCallback.EVENT.register((player, world, hand, hitResult) -> {
            if (player.method_7325() || !world.method_8505(player, hitResult.method_17777())) {
                return class_1269.field_5811;
            }
            boolean isWrench = player.method_5998(hand).method_31573(MITags.WRENCHES);
            boolean isScrewdriver = player.method_5998(hand).method_31573(MITags.SCREWDRIVERS);
            if (isWrench || isScrewdriver) {
                ScrewdriverableBlockEntity screwdriverable;
                WrenchableBlockEntity wrenchable;
                class_2586 entity = world.method_8321(hitResult.method_17777());
                if (isWrench && entity instanceof WrenchableBlockEntity && (wrenchable = (WrenchableBlockEntity)entity).useWrench(player, hand, hitResult)) {
                    return class_1269.method_29236((boolean)world.method_8608());
                }
                if (isScrewdriver && entity instanceof ScrewdriverableBlockEntity && (screwdriverable = (ScrewdriverableBlockEntity)entity).useScrewdriver(player, hand, hitResult)) {
                    return class_1269.method_29236((boolean)world.method_8608());
                }
            }
            return class_1269.field_5811;
        });
    }
}

