/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.blocks.storage;

import aztech.modern_industrialization.api.FastBlockEntity;
import aztech.modern_industrialization.api.WrenchableBlockEntity;
import aztech.modern_industrialization.blocks.storage.AbstractStorageBlock;
import java.util.Iterator;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StoragePreconditions;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.ResourceAmount;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleViewIterator;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3965;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractStorageBlockEntity<T extends TransferVariant<?>>
extends FastBlockEntity
implements Storage<T>,
StorageView<T>,
WrenchableBlockEntity {
    protected T resource;
    protected long amount;
    private long version;
    private final ResourceParticipant participant = new ResourceParticipant();

    public AbstractStorageBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        this.resource = this.getBlankResource();
    }

    public void onChanged() {
        ++this.version;
        this.method_5431();
        if (!this.field_11863.field_9236) {
            this.sync();
        }
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887() {
        return this.method_38244();
    }

    @Override
    public boolean useWrench(class_1657 player, class_1268 hand, class_3965 hit) {
        if (player.method_5715()) {
            AbstractStorageBlock block = (AbstractStorageBlock)this.method_11010().method_26204();
            this.field_11863.method_8649((class_1297)new class_1542(this.field_11863, hit.method_17784().field_1352, hit.method_17784().field_1351, hit.method_17784().field_1350, block.getStack(this)));
            this.field_11863.method_8501(this.field_11867, class_2246.field_10124.method_9564());
            return true;
        }
        return false;
    }

    public boolean supportsExtraction() {
        return true;
    }

    public long insert(T resource, long maxAmount, TransactionContext transaction) {
        StoragePreconditions.notBlankNotNegative(resource, (long)maxAmount);
        if (this.resource.isBlank() || this.resource.equals(resource)) {
            long inserted = Math.min(maxAmount, this.getCapacityForResource(resource) - this.amount);
            if (inserted > 0L) {
                this.participant.updateSnapshots(transaction);
                this.amount += inserted;
                this.resource = resource;
            }
            return inserted;
        }
        return 0L;
    }

    public long extract(T resource, long maxAmount, TransactionContext transaction) {
        StoragePreconditions.notBlankNotNegative(resource, (long)maxAmount);
        if (resource.equals(this.resource)) {
            long extracted = Math.min(maxAmount, this.amount);
            if (extracted > 0L) {
                this.participant.updateSnapshots(transaction);
                this.amount -= extracted;
                if (this.amount == 0L) {
                    this.resource = this.getBlankResource();
                }
            }
            return extracted;
        }
        return 0L;
    }

    public boolean isResourceBlank() {
        return this.getResource().isBlank();
    }

    public abstract T getBlankResource();

    public T getResource() {
        return this.resource;
    }

    public long getAmount() {
        return this.amount;
    }

    public boolean isEmpty() {
        return this.amount == 0L;
    }

    public long getVersion() {
        return this.version;
    }

    public long getCapacity() {
        return this.getCapacityForResource(this.resource);
    }

    public abstract long getCapacityForResource(T var1);

    public Iterator<StorageView<T>> iterator(TransactionContext transaction) {
        return SingleViewIterator.create((StorageView)this, (TransactionContext)transaction);
    }

    private class ResourceParticipant
    extends SnapshotParticipant<ResourceAmount<T>> {
        private ResourceParticipant() {
        }

        protected ResourceAmount<T> createSnapshot() {
            return new ResourceAmount(AbstractStorageBlockEntity.this.resource, AbstractStorageBlockEntity.this.amount);
        }

        protected void readSnapshot(ResourceAmount<T> snapshot) {
            AbstractStorageBlockEntity.this.resource = (TransferVariant)snapshot.resource();
            AbstractStorageBlockEntity.this.amount = snapshot.amount();
        }

        protected void onFinalCommit() {
            AbstractStorageBlockEntity.this.onChanged();
        }
    }
}

