/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.compat.rei.machines;

import aztech.modern_industrialization.MIIdentifier;
import aztech.modern_industrialization.compat.rei.Rectangle;
import aztech.modern_industrialization.compat.rei.machines.MachineCategoryParams;
import aztech.modern_industrialization.machines.MachineScreenHandlers;
import aztech.modern_industrialization.machines.multiblocks.ShapeTemplate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Predicate;
import net.minecraft.class_2960;
import net.minecraft.class_3545;

public class ReiMachineRecipes {
    public static final Map<String, MachineCategoryParams> categories = new TreeMap<String, MachineCategoryParams>();
    static final Map<String, List<ClickAreaCategory>> machineToClickAreaCategory = new HashMap<String, List<ClickAreaCategory>>();
    static final Map<String, Rectangle> machineToClickArea = new HashMap<String, Rectangle>();
    static final List<class_3545<String, ShapeTemplate>> multiblockShapes = new ArrayList<class_3545<String, ShapeTemplate>>();

    public static void registerCategory(String machine, MachineCategoryParams params) {
        if (categories.put(machine, params) != null) {
            throw new IllegalStateException("Machine was already registered: " + machine);
        }
    }

    public static void registerWorkstation(String machine, String item) {
        MachineCategoryParams params = categories.get(machine);
        if (params == null) {
            throw new NullPointerException("Machine params may not be null for machine " + machine);
        }
        params.workstations.add(item);
    }

    public static void registerRecipeCategoryForMachine(String machine, String category) {
        ReiMachineRecipes.registerRecipeCategoryForMachine(machine, category, screen -> true);
    }

    public static void registerRecipeCategoryForMachine(String machine, String category, Predicate<MachineScreenHandlers.ClientScreen> screenPredicate) {
        machineToClickAreaCategory.computeIfAbsent(machine, k -> new ArrayList()).add(new ClickAreaCategory(new MIIdentifier(category), screenPredicate));
    }

    public static void registerMachineClickArea(String machine, Rectangle clickArea) {
        machineToClickArea.put(machine, clickArea);
    }

    public static void registerMultiblockShape(String machine, ShapeTemplate shapeTemplate) {
        multiblockShapes.add((class_3545<String, ShapeTemplate>)new class_3545((Object)machine, (Object)shapeTemplate));
    }

    static class ClickAreaCategory {
        public final class_2960 category;
        public final Predicate<MachineScreenHandlers.ClientScreen> predicate;

        ClickAreaCategory(class_2960 category, Predicate<MachineScreenHandlers.ClientScreen> predicate) {
            this.category = category;
            this.predicate = predicate;
        }
    }
}

