/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.inventory;

import aztech.modern_industrialization.inventory.ChangeListener;
import aztech.modern_industrialization.inventory.IConfigurableSlot;
import aztech.modern_industrialization.inventory.SlotConfig;
import aztech.modern_industrialization.util.Simulation;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.fabricmc.fabric.api.transfer.v1.storage.StoragePreconditions;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.ResourceAmount;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;

public abstract class AbstractConfigurableStack<T, K extends TransferVariant<T>>
extends SnapshotParticipant<ResourceAmount<K>>
implements StorageView<K>,
IConfigurableSlot {
    private final Map<ChangeListener, Object> listeners = new IdentityHashMap<ChangeListener, Object>();
    protected K key = this.getBlankVariant();
    protected long amount = 0L;
    protected T lockedInstance = null;
    protected boolean playerLocked = false;
    protected boolean machineLocked = false;
    protected boolean playerLockable = true;
    protected boolean playerInsert = false;
    protected boolean playerExtract = true;
    protected boolean pipesInsert = false;
    protected boolean pipesExtract = false;

    public AbstractConfigurableStack() {
    }

    public AbstractConfigurableStack(AbstractConfigurableStack<T, K> other) {
        this.key = other.key;
        this.amount = other.amount;
        this.lockedInstance = other.lockedInstance;
        this.playerLocked = other.playerLocked;
        this.machineLocked = other.machineLocked;
        this.playerLockable = other.playerLockable;
        this.playerInsert = other.playerInsert;
        this.playerExtract = other.playerExtract;
        this.pipesInsert = other.pipesInsert;
        this.pipesExtract = other.pipesExtract;
    }

    public AbstractConfigurableStack(class_2487 tag) {
        this.key = this.readVariantFromNbt(tag.method_10562("key"));
        this.amount = tag.method_10537("amount");
        if (tag.method_10545("locked")) {
            this.lockedInstance = this.getRegistry().method_10223(new class_2960(tag.method_10558("locked")));
        }
        this.machineLocked = tag.method_10577("machineLocked");
        this.playerLocked = tag.method_10577("playerLocked");
        this.playerLockable = tag.method_10577("playerLockable");
        this.playerInsert = tag.method_10577("playerInsert");
        this.playerExtract = tag.method_10577("playerExtract");
        this.pipesInsert = tag.method_10577("pipesInsert");
        this.pipesExtract = tag.method_10577("pipesExtract");
    }

    protected void notifyListeners() {
        ChangeListener.notify(this.listeners);
    }

    public void addListener(ChangeListener listener, Object token) {
        this.listeners.put(listener, token);
    }

    public void removeListener(ChangeListener listener) {
        this.listeners.remove(listener);
    }

    protected abstract T getEmptyInstance();

    protected abstract K getBlankVariant();

    protected abstract class_2378<T> getRegistry();

    protected abstract K readVariantFromNbt(class_2487 var1);

    protected abstract long getRemainingCapacityFor(K var1);

    @Override
    public SlotConfig getConfig() {
        return new SlotConfig(this.playerLockable, this.playerInsert, this.playerExtract, this.pipesInsert, this.pipesExtract);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractConfigurableStack that = (AbstractConfigurableStack)o;
        return this.amount == that.amount && this.playerLocked == that.playerLocked && this.machineLocked == that.machineLocked && this.playerLockable == that.playerLockable && this.playerInsert == that.playerInsert && this.playerExtract == that.playerExtract && this.pipesInsert == that.pipesInsert && this.pipesExtract == that.pipesExtract && this.key.equals(that.key) && this.lockedInstance == that.lockedInstance;
    }

    public int hashCode() {
        return Objects.hash(this.key, this.amount, this.lockedInstance, this.playerLocked, this.machineLocked, this.playerLockable, this.playerInsert, this.playerExtract, this.pipesInsert, this.pipesExtract);
    }

    public void setAmount(long amount) {
        this.amount = amount;
        if (amount == 0L) {
            this.key = this.getBlankVariant();
        }
        this.notifyListeners();
    }

    public void empty() {
        this.setAmount(0L);
    }

    public void increment(long amount) {
        this.setAmount(this.amount + amount);
    }

    public void decrement(long amount) {
        this.increment(-amount);
    }

    public void setKey(K key) {
        this.key = key;
        this.notifyListeners();
    }

    public boolean isResourceAllowedByLock(T instance) {
        return this.lockedInstance == null || this.lockedInstance == instance;
    }

    public boolean isResourceAllowedByLock(K key) {
        return this.isResourceAllowedByLock((K)key.getObject());
    }

    public boolean canPlayerInsert() {
        return this.playerInsert;
    }

    public boolean canPlayerExtract() {
        return this.playerExtract;
    }

    public boolean isPlayerLocked() {
        return this.playerLocked;
    }

    public boolean isMachineLocked() {
        return this.machineLocked;
    }

    public void enableMachineLock(T lockedInstance) {
        if (this.lockedInstance != null && lockedInstance != this.lockedInstance) {
            throw new RuntimeException("Trying to override locked instance");
        }
        this.machineLocked = true;
        this.lockedInstance = lockedInstance;
        this.notifyListeners();
    }

    public void disableMachineLock() {
        this.machineLocked = false;
        this.updatedLockedInstance();
    }

    public T getLockedInstance() {
        return this.lockedInstance;
    }

    public boolean isLockedTo(T otherInstance) {
        return this.getLockedInstance() == otherInstance;
    }

    public void togglePlayerLock() {
        if (this.playerLockable) {
            this.playerLocked = !this.playerLocked;
            this.updatedLockedInstance();
        }
    }

    public void togglePlayerLock(T cursorInstance) {
        if (this.playerLockable) {
            if (this.playerLocked && this.lockedInstance == this.getEmptyInstance() && cursorInstance != this.getEmptyInstance()) {
                this.lockedInstance = cursorInstance;
            } else {
                this.playerLocked = !this.playerLocked;
            }
            this.updatedLockedInstance();
        }
    }

    private void updatedLockedInstance() {
        if (!this.machineLocked && !this.playerLocked) {
            this.lockedInstance = null;
        } else if (this.lockedInstance == null) {
            this.lockedInstance = this.key.getObject();
        }
        this.notifyListeners();
    }

    public boolean canPlayerLock() {
        return this.playerLockable;
    }

    public static <T, K extends TransferVariant<T>> void playerLockNoOverride(T instance, List<? extends AbstractConfigurableStack<T, K>> stacks) {
        for (int iter = 0; iter < 2; ++iter) {
            boolean allowEmptyStacks = iter == 1;
            for (AbstractConfigurableStack<T, K> stack : stacks) {
                if (stack.lockedInstance != null || !stack.key.isOf(instance) && (!stack.isResourceBlank() || !allowEmptyStacks)) continue;
                stack.lockedInstance = instance;
                stack.playerLocked = true;
                return;
            }
        }
    }

    public boolean playerLock(T instance, Simulation simulation) {
        if (this.key.isBlank() || this.key.getObject() == instance) {
            if (simulation.isActing()) {
                this.lockedInstance = instance;
                this.playerLocked = true;
            }
            return true;
        }
        return false;
    }

    public boolean canPipesExtract() {
        return this.pipesExtract;
    }

    public boolean canPipesInsert() {
        return this.pipesInsert;
    }

    public long extract(K key, long maxAmount, TransactionContext transaction) {
        if (this.pipesExtract) {
            return this.extractDirect(key, maxAmount, transaction);
        }
        return 0L;
    }

    public long extractDirect(K key, long maxAmount, TransactionContext transaction) {
        StoragePreconditions.notBlankNotNegative(key, (long)maxAmount);
        if (key.equals(this.key)) {
            long extracted = Math.min(this.amount, maxAmount);
            this.updateSnapshots(transaction);
            this.decrement(extracted);
            return extracted;
        }
        return 0L;
    }

    public boolean isResourceBlank() {
        return this.key.isBlank();
    }

    public boolean isEmpty() {
        return this.isResourceBlank();
    }

    public K getResource() {
        return this.key;
    }

    public long getAmount() {
        return this.amount;
    }

    public ResourceAmount<K> createSnapshot() {
        return new ResourceAmount(this.key, this.amount);
    }

    public void readSnapshot(ResourceAmount<K> ra) {
        this.amount = ra.amount();
        this.key = (TransferVariant)ra.resource();
    }

    protected void onFinalCommit() {
        this.notifyListeners();
    }

    public class_2487 toNbt() {
        class_2487 tag = new class_2487();
        tag.method_10566("key", (class_2520)this.key.toNbt());
        tag.method_10544("amount", this.amount);
        if (this.lockedInstance != null) {
            tag.method_10582("locked", this.getRegistry().method_10221(this.lockedInstance).toString());
        }
        tag.method_10556("machineLocked", this.machineLocked);
        tag.method_10556("playerLocked", this.playerLocked);
        tag.method_10556("playerLockable", this.playerLockable);
        tag.method_10556("playerInsert", this.playerInsert);
        tag.method_10556("playerExtract", this.playerExtract);
        tag.method_10556("pipesInsert", this.pipesInsert);
        tag.method_10556("pipesExtract", this.pipesExtract);
        return tag;
    }
}

