/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.components;

import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.MITooltips;
import aztech.modern_industrialization.api.FluidFuelRegistry;
import aztech.modern_industrialization.inventory.ConfigurableFluidStack;
import aztech.modern_industrialization.inventory.ConfigurableItemStack;
import aztech.modern_industrialization.machines.IComponent;
import aztech.modern_industrialization.machines.components.SteamHeaterComponent;
import aztech.modern_industrialization.machines.components.TemperatureComponent;
import aztech.modern_industrialization.machines.components.TooltipProvider;
import aztech.modern_industrialization.util.ItemStackHelper;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.impl.content.registry.FuelRegistryImpl;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2561;

public class FuelBurningComponent
implements IComponent,
TooltipProvider {
    public final long maxEuProduction;
    public final long euPerDegree;
    public final TemperatureComponent temperature;
    private final long burningEuMultiplier;
    public static final int EU_PER_BURN_TICK = 20;
    private long burningEuBuffer;

    public FuelBurningComponent(TemperatureComponent temperature, long maxEuProduction, long euPerDegree, long burningEuMultiplier) {
        this.temperature = temperature;
        this.maxEuProduction = maxEuProduction;
        this.euPerDegree = euPerDegree;
        this.burningEuMultiplier = burningEuMultiplier;
    }

    public FuelBurningComponent(TemperatureComponent temperature, long maxEuProduction, long euPerDegree) {
        this(temperature, maxEuProduction, euPerDegree, 1L);
    }

    public FuelBurningComponent(SteamHeaterComponent steamHeater, long burningEuMultiplier) {
        this(steamHeater, steamHeater.maxEuProduction, steamHeater.euPerDegree, burningEuMultiplier);
    }

    public FuelBurningComponent(SteamHeaterComponent steamHeater) {
        this(steamHeater, steamHeater.maxEuProduction, steamHeater.euPerDegree, 1L);
    }

    public boolean isBurning() {
        return this.burningEuBuffer > 0L;
    }

    public void disable() {
        this.burningEuBuffer = 0L;
    }

    public double getBurningProgress() {
        return Math.min(1.0, (double)this.burningEuBuffer / (double)(100L * this.maxEuProduction));
    }

    public void tick(List<ConfigurableItemStack> itemInputs, List<ConfigurableFluidStack> fluidInputs) {
        long maxEuInsertion = Math.min(this.burningEuBuffer, this.maxEuProduction);
        if ((maxEuInsertion = Math.min(maxEuInsertion, (long)Math.floor((double)this.euPerDegree * (this.temperature.temperatureMax - this.temperature.getTemperature())))) > 0L) {
            this.burningEuBuffer -= maxEuInsertion;
            this.temperature.increaseTemperature((double)maxEuInsertion / (double)this.euPerDegree);
        } else if (this.burningEuBuffer == 0L) {
            this.temperature.decreaseTemperature(1.0);
        }
        block0: while (this.burningEuBuffer == 0L) {
            for (ConfigurableItemStack configurableItemStack : itemInputs) {
                Integer fuelTime;
                class_1792 fuel = ((ItemVariant)configurableItemStack.getResource()).getItem();
                if (!ItemStackHelper.consumeFuel(configurableItemStack, true) || (fuelTime = (Integer)FuelRegistryImpl.INSTANCE.get((class_1935)fuel)) == null || fuelTime <= 0) continue;
                this.burningEuBuffer += (long)(fuelTime * 20) * this.burningEuMultiplier;
                ItemStackHelper.consumeFuel(configurableItemStack, false);
                continue block0;
            }
        }
        block2: while (this.burningEuBuffer < 100L * this.maxEuProduction) {
            for (ConfigurableFluidStack configurableFluidStack : fluidInputs) {
                long mbConsumedMax;
                long mbConsumed;
                long euPerMb;
                if (configurableFluidStack.isEmpty() || (euPerMb = (long)FluidFuelRegistry.getEu(((FluidVariant)configurableFluidStack.getResource()).getFluid()) * this.burningEuMultiplier) == 0L || (mbConsumed = Math.min(mbConsumedMax = (100L * this.maxEuProduction - this.burningEuBuffer) / euPerMb, configurableFluidStack.getAmount() / 81L)) <= 0L) continue;
                configurableFluidStack.decrement(mbConsumed * 81L);
                this.burningEuBuffer += mbConsumed * euPerMb;
                continue block2;
            }
        }
    }

    @Override
    public void writeNbt(class_2487 tag) {
        tag.method_10544("burningEuBuffer", this.burningEuBuffer);
    }

    @Override
    public void readNbt(class_2487 tag) {
        this.burningEuBuffer = tag.method_10537("burningEuBuffer");
    }

    @Override
    public List<class_2561> getTooltips() {
        ArrayList<class_2561> returnList = new ArrayList<class_2561>();
        returnList.add(new MITooltips.Line(MIText.MaxEuProduction).arg(this.maxEuProduction, MITooltips.EU_PER_TICK_PARSER).build());
        if (this.burningEuMultiplier == 2L) {
            returnList.add(new MITooltips.Line(MIText.DoubleFluidFuelEfficiency).build());
        }
        return returnList;
    }
}

