/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.components.sync;

import aztech.modern_industrialization.MIIdentifier;
import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.compat.rei.nuclear.NeutronInteractionCategory;
import aztech.modern_industrialization.machines.MachineScreenHandlers;
import aztech.modern_industrialization.machines.SyncedComponent;
import aztech.modern_industrialization.machines.SyncedComponents;
import aztech.modern_industrialization.machines.gui.ClientComponentRenderer;
import aztech.modern_industrialization.nuclear.INuclearTileData;
import aztech.modern_industrialization.nuclear.NeutronType;
import aztech.modern_industrialization.nuclear.NuclearComponentItem;
import aztech.modern_industrialization.nuclear.NuclearFuel;
import aztech.modern_industrialization.util.FluidHelper;
import aztech.modern_industrialization.util.RenderHelper;
import aztech.modern_industrialization.util.TextHelper;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

public class NuclearReactorGui {
    private static final double neutronsMax = 8192.0;

    public static double neutronColorScheme(double neutronNumber) {
        neutronNumber = Math.min(neutronNumber, 8192.0);
        return Math.log(1.0 + 10.0 * neutronNumber) / Math.log(81921.0);
    }

    public record Data(boolean valid, int gridSizeX, int gridSizeY, Optional<INuclearTileData>[] tilesData, double euProduction, double euFuelConsumption) {
        public int toIndex(int x, int y) {
            return Data.toIndex(x, y, this.gridSizeY);
        }

        public static int toIndex(int x, int y, int sizeY) {
            return x * sizeY + y;
        }
    }

    public static class Client
    implements SyncedComponent.Client {
        private Data data;

        public Client(class_2540 buf) {
            this.read(buf);
        }

        @Override
        public void read(class_2540 buf) {
            boolean valid = buf.readBoolean();
            if (valid) {
                int sizeX = buf.readInt();
                int sizeY = buf.readInt();
                Optional[] tilesData = new Optional[sizeX * sizeY];
                for (int i = 0; i < sizeX * sizeY; ++i) {
                    tilesData[i] = INuclearTileData.read(buf);
                }
                double euProduction = buf.readDouble();
                double euFuelConsumption = buf.readDouble();
                this.data = new Data(true, sizeX, sizeY, tilesData, euProduction, euFuelConsumption);
            } else {
                this.data = new Data(false, 0, 0, null, 0.0, 0.0);
            }
        }

        @Override
        public ClientComponentRenderer createRenderer() {
            return new Renderer();
        }

        public class Renderer
        implements ClientComponentRenderer {
            final int centerX = 88;
            final int centerY = 88;
            Mode currentMode = Mode.NUCLEAR_FUEL;
            NeutronType neutronMode = NeutronType.BOTH;
            class_1799 fuelStack = new class_1799((class_1935)class_2378.field_11142.method_10223((class_2960)new MIIdentifier("uranium_fuel_rod")), 1);
            private final class_2960 COLORBAR = new MIIdentifier("textures/gui/colorbar.png");
            class_2561[] modeTooltip = new class_2561[]{MIText.NuclearFuelMode.text(), MIText.TemperatureMode.text(), MIText.NeutronAbsorptionMode.text(), MIText.NeutronFluxMode.text(), MIText.NeutronGenerationMode.text(), MIText.EuGenerationMode.text()};
            class_2561[] neutronModeTooltip = new class_2561[]{MIText.FastNeutron.text(), MIText.ThermalNeutron.text(), MIText.Both.text()};

            @Override
            public void renderBackground(class_332 helper, class_4587 matrices, int x, int y) {
                if (Client.this.data.valid) {
                    for (int i = 0; i < Client.this.data.gridSizeX; ++i) {
                        for (int j = 0; j < Client.this.data.gridSizeY; ++j) {
                            class_1792 class_17922;
                            ItemVariant itemVariant;
                            int index = Client.this.data.toIndex(i, j);
                            Optional<INuclearTileData> tile = Client.this.data.tilesData()[index];
                            if (!tile.isPresent()) continue;
                            INuclearTileData tileData = tile.get();
                            RenderSystem.setShaderTexture((int)0, (class_2960)MachineScreenHandlers.SLOT_ATLAS);
                            int px = x + 88 - Client.this.data.gridSizeX * 9 + i * 18;
                            int py = y + 88 - Client.this.data.gridSizeY * 9 + j * 18;
                            if (tileData.isFluid()) {
                                helper.method_25302(matrices, px, py, 18, 0, 18, 18);
                            } else {
                                helper.method_25302(matrices, px, py, 0, 0, 18, 18);
                            }
                            TransferVariant variant = tile.get().getVariant();
                            long variantAmount = tile.get().getVariantAmount();
                            if (variantAmount > 0L & !variant.isBlank()) {
                                if (variant instanceof ItemVariant) {
                                    itemVariant = (ItemVariant)variant;
                                    ((MachineScreenHandlers.ClientScreen)helper).renderItemInGui(itemVariant.toStack((int)variantAmount), px + 1, py + 1);
                                } else if (variant instanceof FluidVariant) {
                                    FluidVariant fluidVariant = (FluidVariant)variant;
                                    RenderSystem.disableBlend();
                                    RenderHelper.drawFluidInGui(matrices, fluidVariant, px + 1, py + 1);
                                }
                            }
                            if (this.currentMode != Mode.NUCLEAR_FUEL) {
                                int u;
                                int v;
                                if (this.currentMode == Mode.TEMPERATURE) {
                                    v = 30;
                                    u = (int)(299.0 * tileData.getTemperature() / 3250.0);
                                } else if (this.currentMode == Mode.EU_GENERATION) {
                                    v = 30;
                                    u = (int)(299.0 * Math.min(1.0, tileData.getMeanEuGeneration() / 16384.0));
                                } else {
                                    double neutronRate;
                                    double factor;
                                    double d = factor = this.neutronMode == NeutronType.BOTH ? 2.0 : 1.0;
                                    if (this.currentMode == Mode.NEUTRON_ABSORPTION) {
                                        neutronRate = 5.0 * tileData.getMeanNeutronAbsorption(this.neutronMode);
                                    } else if (this.currentMode == Mode.NEUTRON_FLUX) {
                                        neutronRate = tileData.getMeanNeutronFlux(this.neutronMode);
                                    } else if (this.currentMode == Mode.NEUTRON_GENERATION) {
                                        if (this.neutronMode == NeutronType.THERMAL) {
                                            neutronRate = 0.0;
                                        } else {
                                            neutronRate = tileData.getMeanNeutronGeneration();
                                            factor = 1.0;
                                        }
                                    } else {
                                        neutronRate = 0.0;
                                    }
                                    v = 0;
                                    u = (int)(299.0 * NuclearReactorGui.neutronColorScheme(factor * neutronRate));
                                }
                                RenderSystem.setShaderTexture((int)0, (class_2960)this.COLORBAR);
                                RenderSystem.disableDepthTest();
                                RenderSystem.enableBlend();
                                matrices.method_22904((double)px, (double)py, 0.0);
                                matrices.method_22905(18.0f, 18.0f, 1.0f);
                                class_332.method_25290((class_4587)matrices, (int)0, (int)0, (float)u, (float)v, (int)1, (int)1, (int)300, (int)60);
                                matrices.method_22905(0.055555556f, 0.055555556f, 1.0f);
                                matrices.method_22904((double)(-px), (double)(-py), 0.0);
                            }
                            if (this.currentMode != Mode.TEMPERATURE || variant.isBlank() || !(variant instanceof ItemVariant) || !((class_17922 = (itemVariant = (ItemVariant)variant).getItem()) instanceof NuclearComponentItem)) continue;
                            NuclearComponentItem item = (NuclearComponentItem)class_17922;
                            if (!(tileData.getTemperature() + 100.0 > (double)item.getMaxTemperature())) continue;
                            RenderSystem.setShaderTexture((int)0, (class_2960)MachineScreenHandlers.SLOT_ATLAS);
                            RenderSystem.enableBlend();
                            RenderSystem.disableDepthTest();
                            if (System.currentTimeMillis() % 1000L <= 500L) continue;
                            helper.method_25302(matrices, px + 1, py + 1, 22, 58, 16, 16);
                        }
                    }
                    if (Client.this.data.euFuelConsumption > 0.0 && this.currentMode == Mode.EU_GENERATION) {
                        class_327 renderer = class_310.method_1551().field_1772;
                        matrices.method_22904(0.0, 0.0, 256.0);
                        renderer.method_30883(matrices, this.getEfficiencyText(), (float)(x + 8), (float)(y + 16), 0xFFFFFF);
                        matrices.method_22904(0.0, 0.0, -256.0);
                    }
                } else {
                    class_327 renderer = class_310.method_1551().field_1772;
                    class_5250 text = MIText.MultiblockShapeInvalid.text().method_10862(TextHelper.RED.method_10982(Boolean.valueOf(true)));
                    int width = renderer.method_27525((class_5348)text);
                    renderer.method_30883(matrices, (class_2561)text, (float)(x + 88) - (float)width / 2.0f, (float)(y + 88), 0xFFFFFF);
                }
            }

            @Override
            public void renderTooltip(MachineScreenHandlers.ClientScreen screen, class_4587 matrices, int x, int y, int cursorX, int cursorY) {
                int index;
                Optional<INuclearTileData> tile;
                int i = (cursorX - (x + 88 - Client.this.data.gridSizeX * 9)) / 18;
                int j = (cursorY - (y + 88 - Client.this.data.gridSizeY * 9)) / 18;
                if (Client.this.data.valid && i >= 0 && j >= 0 && i < Client.this.data.gridSizeX && j < Client.this.data.gridSizeY && (tile = Client.this.data.tilesData[index = Client.this.data.toIndex(i, j)]).isPresent()) {
                    INuclearTileData tileData = tile.get();
                    TransferVariant variant = tileData.getVariant();
                    if (this.currentMode == Mode.NUCLEAR_FUEL) {
                        long variantAmount = tile.get().getVariantAmount();
                        if (variantAmount > 0L & !variant.isBlank()) {
                            if (variant instanceof ItemVariant) {
                                ItemVariant itemVariant = (ItemVariant)variant;
                                screen.method_30901(matrices, screen.method_25408(itemVariant.toStack((int)variantAmount)), cursorX, cursorY);
                            } else if (variant instanceof FluidVariant) {
                                FluidVariant fluidVariant = (FluidVariant)variant;
                                screen.method_30901(matrices, FluidHelper.getTooltipForFluidStorage(fluidVariant, variantAmount, 5184000L, false), cursorX, cursorY);
                            }
                        }
                    } else {
                        Object neutronRateThermalString;
                        double neutronRateThermal;
                        double neutronRateFast;
                        if (this.currentMode == Mode.TEMPERATURE) {
                            ItemVariant itemVariant;
                            class_1792 class_17922;
                            int temperature = (int)tileData.getTemperature();
                            ArrayList<class_5250> tooltip = new ArrayList<class_5250>();
                            tooltip.add(MIText.Temperature.text(temperature));
                            if (!variant.isBlank() && variant instanceof ItemVariant && (class_17922 = (itemVariant = (ItemVariant)variant).getItem()) instanceof NuclearComponentItem) {
                                NuclearComponentItem item = (NuclearComponentItem)class_17922;
                                tooltip.add(MIText.MaxTemp.text(item.getMaxTemperature()).method_10862(TextHelper.YELLOW));
                            }
                            screen.method_30901(matrices, tooltip, cursorX, cursorY);
                            return;
                        }
                        if (this.currentMode == Mode.EU_GENERATION) {
                            double euGeneration = tileData.getMeanEuGeneration();
                            screen.method_25424(matrices, TextHelper.getEuTextTick(euGeneration, true), cursorX, cursorY);
                            return;
                        }
                        if (this.currentMode == Mode.NEUTRON_ABSORPTION) {
                            neutronRateFast = tileData.getMeanNeutronAbsorption(NeutronType.FAST);
                            neutronRateThermal = tileData.getMeanNeutronAbsorption(NeutronType.THERMAL);
                        } else if (this.currentMode == Mode.NEUTRON_FLUX) {
                            neutronRateFast = tileData.getMeanNeutronFlux(NeutronType.FAST);
                            neutronRateThermal = tileData.getMeanNeutronFlux(NeutronType.THERMAL);
                        } else if (this.currentMode == Mode.NEUTRON_GENERATION) {
                            neutronRateFast = tileData.getMeanNeutronGeneration();
                            neutronRateThermal = 0.0;
                        } else {
                            neutronRateFast = 0.0;
                            neutronRateThermal = 0.0;
                        }
                        double neutronRate = 0.0;
                        if (this.neutronMode == NeutronType.BOTH) {
                            neutronRate = neutronRateFast + neutronRateThermal;
                        } else if (this.neutronMode == NeutronType.FAST) {
                            neutronRate = neutronRateFast;
                        } else if (this.neutronMode == NeutronType.THERMAL) {
                            neutronRate = neutronRateThermal;
                        }
                        String neutronRateString = String.format("%.1f", neutronRate);
                        ArrayList<class_5250> tooltips = new ArrayList<class_5250>();
                        tooltips.add(MIText.NeutronsRate.text(neutronRateString));
                        if (this.neutronMode == NeutronType.BOTH && neutronRate > 0.0 && this.currentMode != Mode.NEUTRON_GENERATION) {
                            String neutronRateFastString = String.format("%.1f", neutronRateFast);
                            neutronRateThermalString = String.format("%.1f", neutronRateThermal);
                            String neutronRateFastFractionString = String.format(" (%.1f %%)", 100.0 * neutronRateFast / neutronRate);
                            String neutronRateThermalFractionString = String.format(" (%.1f %%)", 100.0 * neutronRateThermal / neutronRate);
                            if (neutronRateFast > 0.0) {
                                tooltips.add(new class_2585(MIText.FastNeutron.text().getString() + " : " + MIText.NeutronsRate.text(neutronRateFastString).getString() + neutronRateFastFractionString).method_10862(TextHelper.GRAY_TEXT));
                            }
                            if (neutronRateThermal > 0.0) {
                                tooltips.add(new class_2585(MIText.ThermalNeutron.text().getString() + " : " + MIText.NeutronsRate.text(neutronRateThermalString).getString() + neutronRateThermalFractionString).method_10862(TextHelper.GRAY_TEXT));
                            }
                        }
                        if (this.currentMode == Mode.NEUTRON_GENERATION && tileData.getComponent().isPresent() && (neutronRateThermalString = tileData.getComponent().get()) instanceof NuclearFuel) {
                            NuclearFuel fuel = (NuclearFuel)neutronRateThermalString;
                            double efficiencyFactor = fuel.efficiencyFactor(tileData.getTemperature());
                            tooltips.add(MIText.ThermalEfficiency.text(String.format("%.1f", efficiencyFactor * 100.0)).method_10862(TextHelper.YELLOW));
                        }
                        screen.method_30901(matrices, tooltips, cursorX, cursorY);
                        return;
                    }
                }
                if (Client.this.data.euFuelConsumption > 0.0 && this.currentMode == Mode.EU_GENERATION) {
                    class_327 renderer = class_310.method_1551().field_1772;
                    int width = renderer.method_1727(this.getEfficiencyText().getString());
                    if (cursorX > x + 8 && cursorX < x + 8 + width && cursorY >= y + 15 && cursorY < y + 24) {
                        class_2561 euProduction = TextHelper.getEuTextTick(Client.this.data.euProduction, true);
                        class_2561 euFuelConsumption = TextHelper.getEuTextTick(Client.this.data.euFuelConsumption, true);
                        class_5250 tooltip = MIText.NuclearFuelEfficiencyTooltip.text(euProduction, euFuelConsumption);
                        screen.method_25424(matrices, (class_2561)tooltip, cursorX, cursorY);
                        return;
                    }
                }
            }

            public class_2561 getEfficiencyText() {
                String eff = String.format("%.1f", 100.0 * Client.this.data.euProduction / Client.this.data.euFuelConsumption);
                return MIText.EfficiencyNuclear.text(eff).method_10862(TextHelper.RED);
            }

            private boolean drawButton() {
                return Client.this.data.valid;
            }

            private boolean drawNeutronButton() {
                return Client.this.data.valid && (this.currentMode == Mode.NEUTRON_FLUX || this.currentMode == Mode.NEUTRON_ABSORPTION);
            }

            private NeutronType nextNeutronMode() {
                return NeutronType.TYPES[(this.neutronMode.index + 1) % NeutronType.TYPES.length];
            }

            @Override
            public void addButtons(ClientComponentRenderer.ButtonContainer container) {
                if (this.drawButton()) {
                    container.addButton(152, 4, 20, 20, (class_2561)new class_2585(""), i -> {
                        this.currentMode = Mode.values()[(this.currentMode.index + 1) % Mode.values().length];
                    }, () -> List.of(this.modeTooltip[this.currentMode.index], MIText.ClickToSwitch.text(this.modeTooltip[(this.currentMode.index + 1) % Mode.values().length]).method_10862(TextHelper.GRAY_TEXT)), (screen, button, matrices, mouseX, mouseY, delta) -> {
                        button.renderVanilla(matrices, mouseX, mouseY, delta);
                        if (this.currentMode == Mode.NUCLEAR_FUEL) {
                            ((MachineScreenHandlers.ClientScreen)screen).renderItemInGui(this.fuelStack, button.field_22760 + 1, button.field_22761 + 1);
                        } else if (this.currentMode == Mode.EU_GENERATION) {
                            RenderSystem.setShaderTexture((int)0, (class_2960)MachineScreenHandlers.SLOT_ATLAS);
                            screen.method_25302(matrices, button.field_22760 + 4, button.field_22761 + 2, 243, 1, 13, 17);
                        } else {
                            RenderSystem.setShaderTexture((int)0, (class_2960)MachineScreenHandlers.SLOT_ATLAS);
                            screen.method_25302(matrices, button.field_22760, button.field_22761, 124 + this.currentMode.index * 20, 0, 20, 20);
                        }
                        if (button.method_25367()) {
                            button.method_25352(matrices, mouseX, mouseY);
                        }
                    });
                    container.addButton(152, 150, 20, 20, (class_2561)new class_2585(""), i -> {
                        this.neutronMode = this.nextNeutronMode();
                    }, () -> List.of(this.neutronModeTooltip[this.neutronMode.index], MIText.ClickToSwitch.text(this.neutronModeTooltip[this.nextNeutronMode().index]).method_10862(TextHelper.GRAY_TEXT)), (screen, button, matrices, mouseX, mouseY, delta) -> {
                        button.renderVanilla(matrices, mouseX, mouseY, delta);
                        RenderSystem.setShaderTexture((int)0, (class_2960)NeutronInteractionCategory.TEXTURE_ATLAS);
                        if (this.neutronMode == NeutronType.FAST) {
                            screen.method_25302(matrices, button.field_22760 + 2, button.field_22761 + 2, 0, 240, 16, 16);
                        } else if (this.neutronMode == NeutronType.THERMAL) {
                            screen.method_25302(matrices, button.field_22760 + 2, button.field_22761 + 2, 160, 240, 16, 16);
                        } else if (this.neutronMode == NeutronType.BOTH) {
                            screen.method_25302(matrices, button.field_22760 + 2, button.field_22761 + 2, 80, 240, 16, 16);
                        }
                        if (button.method_25367()) {
                            button.method_25352(matrices, mouseX, mouseY);
                        }
                    }, this::drawNeutronButton);
                }
            }

            private static enum Mode {
                NUCLEAR_FUEL(0),
                TEMPERATURE(1),
                NEUTRON_ABSORPTION(2),
                NEUTRON_FLUX(3),
                NEUTRON_GENERATION(4),
                EU_GENERATION(5);

                final int index;

                private Mode(int index) {
                    this.index = index;
                }
            }
        }
    }

    public record Server(Supplier<Data> dataSupplier) implements SyncedComponent.Server<Data>
    {
        @Override
        public Data copyData() {
            return this.dataSupplier.get();
        }

        @Override
        public boolean needsSync(Data cachedData) {
            Data data = this.copyData();
            if (data.valid != cachedData.valid || data.gridSizeX != cachedData.gridSizeX || data.gridSizeY != cachedData.gridSizeY || data.euProduction != cachedData.euProduction || data.euFuelConsumption != cachedData.euFuelConsumption) {
                return true;
            }
            for (int i = 0; i < data.gridSizeY * data.gridSizeX; ++i) {
                if (!INuclearTileData.areEquals(data.tilesData[i], cachedData.tilesData[i])) continue;
                return true;
            }
            return false;
        }

        @Override
        public void writeInitialData(class_2540 buf) {
            this.writeCurrentData(buf);
        }

        @Override
        public void writeCurrentData(class_2540 buf) {
            Data data = this.copyData();
            buf.writeBoolean(data.valid);
            if (data.valid) {
                buf.writeInt(data.gridSizeX);
                buf.writeInt(data.gridSizeY);
                for (Optional<INuclearTileData> tiles : data.tilesData) {
                    INuclearTileData.write(tiles, buf);
                }
                buf.writeDouble(data.euProduction);
                buf.writeDouble(data.euFuelConsumption);
            }
        }

        @Override
        public class_2960 getId() {
            return SyncedComponents.NUCLEAR_REACTOR_GUI;
        }
    }
}

