/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.components.sync;

import aztech.modern_industrialization.MIIdentifier;
import aztech.modern_industrialization.machines.SyncedComponent;
import aztech.modern_industrialization.machines.SyncedComponents;
import aztech.modern_industrialization.machines.gui.ClientComponentRenderer;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.Supplier;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_4587;

public class ProgressBar {

    public static class Parameters {
        public final int renderX;
        public final int renderY;
        public final String progressBarType;
        public final boolean isVertical;

        public Parameters(int renderX, int renderY, String progressBarType) {
            this(renderX, renderY, progressBarType, false);
        }

        public Parameters(int renderX, int renderY, String progressBarType, boolean isVertical) {
            this.renderX = renderX;
            this.renderY = renderY;
            this.progressBarType = progressBarType;
            this.isVertical = isVertical;
        }

        public class_2960 getTextureId() {
            return new MIIdentifier("textures/gui/progress_bar/" + this.progressBarType + ".png");
        }
    }

    public static class RenderHelper {
        public static void renderProgress(class_332 helper, class_4587 matrices, int x, int y, Parameters params, float progress) {
            RenderHelper.renderProgress(helper.method_25305(), matrices, x, y, params, progress);
        }

        public static void renderProgress(int zoffset, class_4587 matrices, int x, int y, Parameters params, float progress) {
            RenderSystem.setShaderTexture((int)0, (class_2960)params.getTextureId());
            class_332.method_25291((class_4587)matrices, (int)(x + params.renderX), (int)(y + params.renderY), (int)zoffset, (float)0.0f, (float)0.0f, (int)20, (int)20, (int)20, (int)40);
            int foregroundPixels = (int)(progress * 20.0f);
            if (foregroundPixels > 0) {
                if (!params.isVertical) {
                    class_332.method_25291((class_4587)matrices, (int)(x + params.renderX), (int)(y + params.renderY), (int)zoffset, (float)0.0f, (float)20.0f, (int)foregroundPixels, (int)20, (int)20, (int)40);
                } else {
                    class_332.method_25291((class_4587)matrices, (int)(x + params.renderX), (int)(y + params.renderY + 20 - foregroundPixels), (int)zoffset, (float)0.0f, (float)(40 - foregroundPixels), (int)20, (int)foregroundPixels, (int)20, (int)40);
                }
            }
        }
    }

    public static class Client
    implements SyncedComponent.Client {
        public final Parameters params;
        public float progress;

        public Client(class_2540 buf) {
            this.params = new Parameters(buf.readInt(), buf.readInt(), buf.method_19772(), buf.readBoolean());
            this.read(buf);
        }

        @Override
        public void read(class_2540 buf) {
            this.progress = buf.readFloat();
        }

        @Override
        public ClientComponentRenderer createRenderer() {
            return new Renderer();
        }

        public class Renderer
        implements ClientComponentRenderer {
            @Override
            public void renderBackground(class_332 helper, class_4587 matrices, int x, int y) {
                RenderHelper.renderProgress(helper, matrices, x, y, Client.this.params, Client.this.progress);
            }
        }
    }

    public static class Server
    implements SyncedComponent.Server<Float> {
        private final Parameters params;
        private final Supplier<Float> progressSupplier;

        public Server(Parameters params, Supplier<Float> progressSupplier) {
            this.params = params;
            this.progressSupplier = progressSupplier;
        }

        @Override
        public Float copyData() {
            return this.progressSupplier.get();
        }

        @Override
        public boolean needsSync(Float cachedData) {
            return !cachedData.equals(this.progressSupplier.get());
        }

        @Override
        public void writeInitialData(class_2540 buf) {
            buf.writeInt(this.params.renderX);
            buf.writeInt(this.params.renderY);
            buf.method_10814(this.params.progressBarType);
            buf.writeBoolean(this.params.isVertical);
            this.writeCurrentData(buf);
        }

        @Override
        public void writeCurrentData(class_2540 buf) {
            buf.writeFloat(this.progressSupplier.get().floatValue());
        }

        @Override
        public class_2960 getId() {
            return SyncedComponents.PROGRESS_BAR;
        }
    }
}

