/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.init;

import aztech.modern_industrialization.MIBlock;
import aztech.modern_industrialization.MIFluids;
import aztech.modern_industrialization.MIIdentifier;
import aztech.modern_industrialization.compat.rei.Rectangle;
import aztech.modern_industrialization.compat.rei.machines.MachineCategoryParams;
import aztech.modern_industrialization.compat.rei.machines.ReiMachineRecipes;
import aztech.modern_industrialization.compat.rei.machines.SteamMode;
import aztech.modern_industrialization.definition.BlockDefinition;
import aztech.modern_industrialization.inventory.SlotPositions;
import aztech.modern_industrialization.machines.BEP;
import aztech.modern_industrialization.machines.MachineScreenHandlers;
import aztech.modern_industrialization.machines.SyncedComponent;
import aztech.modern_industrialization.machines.blockentities.multiblocks.DistillationTowerBlockEntity;
import aztech.modern_industrialization.machines.blockentities.multiblocks.ElectricBlastFurnaceBlockEntity;
import aztech.modern_industrialization.machines.blockentities.multiblocks.ElectricCraftingMultiblockBlockEntity;
import aztech.modern_industrialization.machines.blockentities.multiblocks.EnergyFromFluidMultiblockBlockEntity;
import aztech.modern_industrialization.machines.blockentities.multiblocks.FusionReactorBlockEntity;
import aztech.modern_industrialization.machines.blockentities.multiblocks.LargeTankMultiblockBlockEntity;
import aztech.modern_industrialization.machines.blockentities.multiblocks.NuclearReactorMultiblockBlockEntity;
import aztech.modern_industrialization.machines.blockentities.multiblocks.SteamBoilerMultiblockBlockEntity;
import aztech.modern_industrialization.machines.blockentities.multiblocks.SteamCraftingMultiblockBlockEntity;
import aztech.modern_industrialization.machines.components.FluidConsumerComponent;
import aztech.modern_industrialization.machines.components.sync.CraftingMultiblockGui;
import aztech.modern_industrialization.machines.components.sync.ProgressBar;
import aztech.modern_industrialization.machines.init.MIMachineRecipeTypes;
import aztech.modern_industrialization.machines.init.MachineRegistrationHelper;
import aztech.modern_industrialization.machines.models.MachineCasing;
import aztech.modern_industrialization.machines.models.MachineCasings;
import aztech.modern_industrialization.machines.models.MachineModels;
import aztech.modern_industrialization.machines.multiblocks.HatchFlags;
import aztech.modern_industrialization.machines.multiblocks.HatchType;
import aztech.modern_industrialization.machines.multiblocks.MultiblockMachineBER;
import aztech.modern_industrialization.machines.multiblocks.MultiblockTankBER;
import aztech.modern_industrialization.machines.multiblocks.ShapeTemplate;
import aztech.modern_industrialization.machines.multiblocks.SimpleMember;
import aztech.modern_industrialization.machines.recipe.MachineRecipe;
import aztech.modern_industrialization.machines.recipe.MachineRecipeType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.client.rendering.v1.BlockEntityRendererRegistry;
import net.minecraft.class_2246;
import net.minecraft.class_2591;

public class MultiblockMachines {
    public static class_2591 COKE_OVEN;
    public static class_2591 STEAM_BLAST_FURNACE;
    public static class_2591 STEAM_QUARRY;
    public static class_2591 ELECTRIC_BLAST_FURNACE;
    public static class_2591 LARGE_STEAM_BOILER;
    public static class_2591 ADVANCED_LARGE_STEAM_BOILER;
    public static class_2591 HIGH_PRESSURE_LARGE_STEAM_BOILER;
    public static class_2591 HIGH_PRESSURE_ADVANCED_LARGE_STEAM_BOILER;
    public static class_2591 ELECTRIC_QUARRY;
    public static class_2591 OIL_DRILLING_RIG;
    public static class_2591 VACUUM_FREEZER;
    public static class_2591 DISTILLATION_TOWER;
    public static class_2591 LARGE_DIESEL_GENERATOR;
    public static class_2591 LARGE_STEAM_TURBINE;
    public static class_2591 HEAT_EXCHANGER;
    public static class_2591 PRESSURIZER;
    public static class_2591 IMPLOSION_COMPRESSOR;
    public static class_2591 NUCLEAR_REACTOR;
    public static class_2591 LARGE_TANK;
    public static class_2591 FUSION_REACTOR;
    public static class_2591 PLASMA_TURBINE;
    private static SimpleMember invarCasings;
    private static SimpleMember bronzePlatedBricks;
    private static SimpleMember bronzePipe;
    private static SimpleMember frostproofMachineCasing;
    private static SimpleMember stainlessSteelClean;
    private static SimpleMember stainlessSteelPipe;
    private static SimpleMember titaniumCasing;
    private static SimpleMember titaniumPipe;
    private static SimpleMember blastProofCasing;
    private static SimpleMember highlyAdvancedHull;
    private static SimpleMember fusionChamber;
    private static SimpleMember plasmaHandlingIridium;
    private static SimpleMember iridiumPipe;
    private static final HatchFlags fluidInputs;
    private static final HatchFlags energyOutput;
    private static final HatchFlags energyInput;
    private static final Rectangle CRAFTING_GUI;

    private static void cokeOven() {
        SimpleMember bricks = SimpleMember.forBlock(class_2246.field_10104);
        HatchFlags cokeOvenHatches = new HatchFlags.Builder().with(HatchType.ITEM_INPUT).with(HatchType.ITEM_OUTPUT).with(HatchType.FLUID_INPUT).with(HatchType.FLUID_OUTPUT).build();
        ShapeTemplate cokeOvenShape = new ShapeTemplate.Builder(MachineCasings.BRICKS).add3by3Levels(-1, 1, bricks, cokeOvenHatches).build();
        COKE_OVEN = MachineRegistrationHelper.registerMachine("Coke Oven", "coke_oven", bet -> new SteamCraftingMultiblockBlockEntity((BEP)bet, "coke_oven", cokeOvenShape, MIMachineRecipeTypes.COKE_OVEN), new Consumer[0]);
        ReiMachineRecipes.registerMultiblockShape("coke_oven", cokeOvenShape);
    }

    private static void steamBlastFurnace() {
        SimpleMember fireclayBricks = SimpleMember.forBlock(MIBlock.BLOCK_FIRE_CLAY_BRICKS.asBlock());
        HatchFlags sbfHatches = new HatchFlags.Builder().with(HatchType.ITEM_INPUT, HatchType.ITEM_OUTPUT, HatchType.FLUID_INPUT, HatchType.FLUID_OUTPUT).build();
        ShapeTemplate sbfShape = new ShapeTemplate.Builder(MachineCasings.FIREBRICKS).add3by3Levels(-1, 2, fireclayBricks, sbfHatches).build();
        STEAM_BLAST_FURNACE = MachineRegistrationHelper.registerMachine("Steam Blast Furnace", "steam_blast_furnace", bet -> new SteamCraftingMultiblockBlockEntity((BEP)bet, "steam_blast_furnace", sbfShape, MIMachineRecipeTypes.BLAST_FURNACE), new Consumer[0]);
        ReiMachineRecipes.registerMultiblockShape("steam_blast_furnace", sbfShape);
    }

    private static void electricBlastFurnace() {
        ELECTRIC_BLAST_FURNACE = MachineRegistrationHelper.registerMachine("Electric Blast Furnace", "electric_blast_furnace", ElectricBlastFurnaceBlockEntity::new, new Consumer[0]);
        ElectricBlastFurnaceBlockEntity.registerReiShapes();
    }

    private static void steamBoilers() {
        HatchFlags slbHatchFlags = new HatchFlags.Builder().with(HatchType.ITEM_INPUT, HatchType.FLUID_INPUT, HatchType.FLUID_OUTPUT).build();
        ShapeTemplate largeSteamBoilerShape = new ShapeTemplate.Builder(MachineCasings.HEATPROOF).add3by3(-1, invarCasings, false, slbHatchFlags).add3by3(0, bronzePlatedBricks, true, null).add3by3(1, bronzePlatedBricks, true, null).add3by3(2, bronzePlatedBricks, false, null).add(0, 0, 1, bronzePipe, null).add(0, 1, 1, bronzePipe, null).build();
        LARGE_STEAM_BOILER = MachineRegistrationHelper.registerMachine("Large Steam Boiler", "large_steam_boiler", bet -> new SteamBoilerMultiblockBlockEntity((BEP)bet, largeSteamBoilerShape, "large_steam_boiler", 256L, false), new Consumer[0]);
        ReiMachineRecipes.registerMultiblockShape("large_steam_boiler", largeSteamBoilerShape);
        ShapeTemplate advancedLargeSteamBoilerShape = new ShapeTemplate.Builder(MachineCasings.HEATPROOF).add3by3(-2, invarCasings, false, slbHatchFlags).add3by3(-1, bronzePlatedBricks, true, null).add3by3(0, bronzePlatedBricks, true, null).add3by3(1, bronzePlatedBricks, true, null).add3by3(2, bronzePlatedBricks, false, null).add(0, -1, 1, bronzePipe, null).add(0, 0, 1, bronzePipe, null).add(0, 1, 1, bronzePipe, null).build();
        ADVANCED_LARGE_STEAM_BOILER = MachineRegistrationHelper.registerMachine("Advanced Large Steam Boiler", "advanced_large_steam_boiler", bet -> new SteamBoilerMultiblockBlockEntity((BEP)bet, advancedLargeSteamBoilerShape, "advanced_large_steam_boiler", 1024L, false), new Consumer[0]);
        ReiMachineRecipes.registerMultiblockShape("advanced_large_steam_boiler", advancedLargeSteamBoilerShape);
        ShapeTemplate highPressureLargeSteamBoilerShape = new ShapeTemplate.Builder(MachineCasings.HEATPROOF).add3by3(-1, invarCasings, false, slbHatchFlags).add3by3(0, stainlessSteelClean, true, null).add3by3(1, stainlessSteelClean, true, null).add3by3(2, stainlessSteelClean, false, null).add(0, 0, 1, stainlessSteelPipe, null).add(0, 1, 1, stainlessSteelPipe, null).build();
        HIGH_PRESSURE_LARGE_STEAM_BOILER = MachineRegistrationHelper.registerMachine("High Pressure Large Steam Boiler", "high_pressure_large_steam_boiler", bet -> new SteamBoilerMultiblockBlockEntity((BEP)bet, highPressureLargeSteamBoilerShape, "high_pressure_large_steam_boiler", 2048L, true), new Consumer[0]);
        ReiMachineRecipes.registerMultiblockShape("high_pressure_large_steam_boiler", highPressureLargeSteamBoilerShape);
        ShapeTemplate highPressureAdvancedLargeSteamBoilerShape = new ShapeTemplate.Builder(MachineCasings.HEATPROOF).add3by3(-2, invarCasings, false, slbHatchFlags).add3by3(-1, stainlessSteelClean, true, null).add3by3(0, stainlessSteelClean, true, null).add3by3(1, stainlessSteelClean, true, null).add3by3(2, stainlessSteelClean, false, null).add(0, -1, 1, stainlessSteelPipe, null).add(0, 0, 1, stainlessSteelPipe, null).add(0, 1, 1, stainlessSteelPipe, null).build();
        HIGH_PRESSURE_ADVANCED_LARGE_STEAM_BOILER = MachineRegistrationHelper.registerMachine("High Pressure Advanced Large Steam Boiler", "high_pressure_advanced_large_steam_boiler", bet -> new SteamBoilerMultiblockBlockEntity((BEP)bet, highPressureAdvancedLargeSteamBoilerShape, "high_pressure_advanced_large_steam_boiler", 8192L, true), new Consumer[0]);
        ReiMachineRecipes.registerMultiblockShape("high_pressure_advanced_large_steam_boiler", highPressureAdvancedLargeSteamBoilerShape);
    }

    private static void quarries() {
        SimpleMember steelCasing = SimpleMember.forBlock(((BlockDefinition)MIBlock.BLOCKS.get((Object)new MIIdentifier("steel_machine_casing"))).asBlock());
        SimpleMember steelPipe = SimpleMember.forBlock(((BlockDefinition)MIBlock.BLOCKS.get((Object)new MIIdentifier("steel_machine_casing_pipe"))).asBlock());
        HatchFlags quarryHatchFlags = new HatchFlags.Builder().with(HatchType.ITEM_INPUT, HatchType.FLUID_INPUT, HatchType.ITEM_OUTPUT).build();
        HatchFlags quarryElectricHatchFlags = new HatchFlags.Builder().with(HatchType.ITEM_INPUT, HatchType.ITEM_OUTPUT, HatchType.ENERGY_INPUT).build();
        ShapeTemplate.Builder quarryShapeBuilder = new ShapeTemplate.Builder(MachineCasings.STEEL).add3by3(0, steelCasing, true, quarryHatchFlags).add3by3(1, steelCasing, true, quarryHatchFlags);
        ShapeTemplate.Builder quarryElectricShapeBuilder = new ShapeTemplate.Builder(MachineCasings.STEEL).add3by3(0, steelCasing, true, quarryElectricHatchFlags).add3by3(1, steelCasing, true, quarryElectricHatchFlags);
        for (int y = 2; y <= 4; ++y) {
            quarryShapeBuilder.add(-1, y, 1, steelPipe, null);
            quarryShapeBuilder.add(1, y, 1, steelPipe, null);
            quarryElectricShapeBuilder.add(-1, y, 1, steelPipe, null);
            quarryElectricShapeBuilder.add(1, y, 1, steelPipe, null);
        }
        quarryShapeBuilder.add(0, 4, 1, steelCasing, null);
        quarryElectricShapeBuilder.add(0, 4, 1, steelCasing, null);
        SimpleMember chain = SimpleMember.verticalChain();
        for (int y = 0; y <= 3; ++y) {
            quarryShapeBuilder.add(0, y, 1, chain, null);
            quarryElectricShapeBuilder.add(0, y, 1, chain, null);
        }
        ShapeTemplate quarryShape = quarryShapeBuilder.build();
        ShapeTemplate quarryElectricShape = quarryElectricShapeBuilder.build();
        STEAM_QUARRY = MachineRegistrationHelper.registerMachine("Steam Quarry", "steam_quarry", bet -> new SteamCraftingMultiblockBlockEntity((BEP)bet, "steam_quarry", quarryShape, MIMachineRecipeTypes.QUARRY), new Consumer[0]);
        ReiMachineRecipes.registerMultiblockShape("steam_quarry", quarryShape);
        ELECTRIC_QUARRY = MachineRegistrationHelper.registerMachine("Electric Quarry", "electric_quarry", bet -> new ElectricCraftingMultiblockBlockEntity((BEP)bet, "electric_quarry", quarryElectricShape, MIMachineRecipeTypes.QUARRY), new Consumer[0]);
        ReiMachineRecipes.registerMultiblockShape("electric_quarry", quarryElectricShape);
    }

    private static void oilDrillingRig() {
        int x;
        int y;
        ShapeTemplate.Builder oilDrillingRigShapeBuilder = new ShapeTemplate.Builder(MachineCasings.STEEL);
        SimpleMember steelCasing = SimpleMember.forBlock(((BlockDefinition)MIBlock.BLOCKS.get((Object)new MIIdentifier("steel_machine_casing"))).asBlock());
        SimpleMember steelPipe = SimpleMember.forBlock(((BlockDefinition)MIBlock.BLOCKS.get((Object)new MIIdentifier("steel_machine_casing_pipe"))).asBlock());
        SimpleMember chain = SimpleMember.verticalChain();
        HatchFlags hatchFlags = new HatchFlags.Builder().with(HatchType.ITEM_INPUT).with(HatchType.FLUID_OUTPUT).with(HatchType.ENERGY_INPUT).build();
        for (y = -4; y <= -2; ++y) {
            oilDrillingRigShapeBuilder.add(-2, y, -1, steelCasing, null);
            oilDrillingRigShapeBuilder.add(2, y, -1, steelCasing, null);
            oilDrillingRigShapeBuilder.add(-2, y, 3, steelCasing, null);
            oilDrillingRigShapeBuilder.add(2, y, 3, steelCasing, null);
        }
        for (x = -2; x <= 2; ++x) {
            for (int z = -1; z <= 3; ++z) {
                if (x != 2 && x != -2 && z != -1 && z != 3) continue;
                oilDrillingRigShapeBuilder.add(x, -1, z, steelCasing, null);
            }
        }
        for (y = -4; y <= 4; ++y) {
            oilDrillingRigShapeBuilder.add(-1, y, 1, chain, null);
            oilDrillingRigShapeBuilder.add(1, y, 1, chain, null);
            if (y < -1) continue;
            oilDrillingRigShapeBuilder.add(0, y, 1, steelPipe, null);
        }
        for (x = -2; x <= 2; ++x) {
            oilDrillingRigShapeBuilder.add(x, 5, 1, steelCasing, null);
        }
        oilDrillingRigShapeBuilder.add(-1, 0, 0, steelCasing, hatchFlags);
        oilDrillingRigShapeBuilder.add(1, 0, 0, steelCasing, hatchFlags);
        oilDrillingRigShapeBuilder.add(-1, 0, 2, steelCasing, hatchFlags);
        oilDrillingRigShapeBuilder.add(0, 0, 2, steelCasing, hatchFlags);
        oilDrillingRigShapeBuilder.add(1, 0, 2, steelCasing, hatchFlags);
        ShapeTemplate oilDrillingRigShape = oilDrillingRigShapeBuilder.build();
        OIL_DRILLING_RIG = MachineRegistrationHelper.registerMachine("Oil Drilling Rig", "oil_drilling_rig", bet -> new ElectricCraftingMultiblockBlockEntity((BEP)bet, "oil_drilling_rig", oilDrillingRigShape, MIMachineRecipeTypes.OIL_DRILLING_RIG), new Consumer[0]);
        ReiMachineRecipes.registerMultiblockShape("oil_drilling_rig", oilDrillingRigShape);
    }

    private static void vacuumFreezer() {
        HatchFlags vacuumFreezerHatches = new HatchFlags.Builder().with(HatchType.ITEM_INPUT).with(HatchType.ITEM_OUTPUT).with(HatchType.FLUID_INPUT).with(HatchType.FLUID_OUTPUT).with(HatchType.ENERGY_INPUT).build();
        ShapeTemplate vacuumFreezerShape = new ShapeTemplate.Builder(MachineCasings.FROSTPROOF).add3by3LevelsRoofed(-1, 2, frostproofMachineCasing, vacuumFreezerHatches).build();
        VACUUM_FREEZER = MachineRegistrationHelper.registerMachine("Vacuum Freezer", "vacuum_freezer", bet -> new ElectricCraftingMultiblockBlockEntity((BEP)bet, "vacuum_freezer", vacuumFreezerShape, MIMachineRecipeTypes.VACUUM_FREEZER), new Consumer[0]);
        ReiMachineRecipes.registerMultiblockShape("vacuum_freezer", vacuumFreezerShape);
    }

    private static void distillationTower() {
        DISTILLATION_TOWER = MachineRegistrationHelper.registerMachine("Distillation Tower", "distillation_tower", DistillationTowerBlockEntity::new, new Consumer[0]);
        DistillationTowerBlockEntity.registerReiShapes();
    }

    private static void largeDieselGenerator() {
        int x;
        ShapeTemplate.Builder largeDieselGeneratorShapeBuilder = new ShapeTemplate.Builder(MachineCasings.SOLID_TITANIUM);
        for (int z = 1; z < 4; ++z) {
            largeDieselGeneratorShapeBuilder.add(0, 0, z, z < 3 ? titaniumPipe : titaniumCasing, z == 3 ? energyOutput : null);
            for (x = -1; x < 2; ++x) {
                largeDieselGeneratorShapeBuilder.add(x, 1, z, titaniumCasing, null);
                largeDieselGeneratorShapeBuilder.add(x, -1, z, titaniumCasing, null);
                if (x == 0) continue;
                largeDieselGeneratorShapeBuilder.add(x, 0, z, titaniumCasing, z < 3 ? fluidInputs : null);
            }
        }
        for (int y = -1; y <= 1; ++y) {
            for (x = -1; x <= 1; ++x) {
                if (x == 0 && y == 0) continue;
                largeDieselGeneratorShapeBuilder.add(x, y, 0, titaniumPipe, null);
            }
        }
        ShapeTemplate largeDieselGeneratorShape = largeDieselGeneratorShapeBuilder.build();
        LARGE_DIESEL_GENERATOR = MachineRegistrationHelper.registerMachine("Large Diesel Generator", "large_diesel_generator", bet -> new EnergyFromFluidMultiblockBlockEntity((BEP)bet, "large_diesel_generator", largeDieselGeneratorShape, FluidConsumerComponent.ofFluidFuels(16384L)), new Consumer[0]);
        ReiMachineRecipes.registerMultiblockShape("large_diesel_generator", largeDieselGeneratorShape);
    }

    private static ShapeTemplate largeTurbineShape(MachineCasing mainCasing, SimpleMember casing, SimpleMember pipe) {
        ShapeTemplate.Builder largeTurbineBuilder = new ShapeTemplate.Builder(mainCasing);
        for (int z = 0; z < 4; ++z) {
            for (int x = -1; x <= 1; ++x) {
                for (int y = -1; y <= 1; ++y) {
                    if (z == 0) {
                        if (x == 0 && y == 0) continue;
                        largeTurbineBuilder.add(x, y, z, casing, fluidInputs);
                        continue;
                    }
                    if (z == 3) {
                        largeTurbineBuilder.add(x, y, z, casing, x == 0 && y == 0 ? energyOutput : null);
                        continue;
                    }
                    largeTurbineBuilder.add(x, y, z, pipe, null);
                }
            }
        }
        return largeTurbineBuilder.build();
    }

    private static void largeSteamTurbine() {
        ShapeTemplate largeSteamTurbineShape = MultiblockMachines.largeTurbineShape(MachineCasings.CLEAN_STAINLESS_STEEL, stainlessSteelClean, stainlessSteelPipe);
        LARGE_STEAM_TURBINE = MachineRegistrationHelper.registerMachine("Large Steam Turbine", "large_steam_turbine", bet -> new EnergyFromFluidMultiblockBlockEntity((BEP)bet, "large_steam_turbine", largeSteamTurbineShape, FluidConsumerComponent.of(16384L, f -> f == MIFluids.STEAM.asFluid() || f == MIFluids.HIGH_PRESSURE_STEAM.asFluid() || f == MIFluids.HIGH_PRESSURE_HEAVY_WATER_STEAM.asFluid() || f == MIFluids.HEAVY_WATER_STEAM.asFluid(), f -> f == MIFluids.STEAM.asFluid() || f == MIFluids.HEAVY_WATER_STEAM.asFluid() ? 1 : 8)), new Consumer[0]);
        ReiMachineRecipes.registerMultiblockShape("large_steam_turbine", largeSteamTurbineShape);
    }

    private static void heathExchanger() {
        ShapeTemplate.Builder heatExchangerShapeBuilder = new ShapeTemplate.Builder(MachineCasings.STAINLESS_STEEL_PIPE);
        for (int z = 0; z < 5; ++z) {
            for (int x = -1; x <= 1; ++x) {
                for (int y = -1; y <= 1; ++y) {
                    if (z > 0 && z < 4) {
                        heatExchangerShapeBuilder.add(x, y, z, x == -1 ? invarCasings : (x == 0 ? stainlessSteelPipe : frostproofMachineCasing), y == 1 && x == 0 && z == 2 ? energyInput : null);
                        continue;
                    }
                    if (z == 0 && x == 0 && y == 0) continue;
                    HatchFlags flag = null;
                    if (y == -1 && x == 0) {
                        flag = new HatchFlags.Builder().with(z == 0 ? HatchType.ITEM_INPUT : HatchType.ITEM_OUTPUT).build();
                    } else if (y == 0 && x != 0) {
                        boolean fluidOutput = x == -1 ^ z == 0;
                        flag = new HatchFlags.Builder().with(fluidOutput ? HatchType.FLUID_OUTPUT : HatchType.FLUID_INPUT).build();
                    }
                    heatExchangerShapeBuilder.add(x, y, z, stainlessSteelPipe, flag);
                }
            }
        }
        ShapeTemplate heatExchangerShape = heatExchangerShapeBuilder.build();
        HEAT_EXCHANGER = MachineRegistrationHelper.registerMachine("Heat Exchanger", "heat_exchanger", bet -> new ElectricCraftingMultiblockBlockEntity((BEP)bet, "heat_exchanger", heatExchangerShape, MIMachineRecipeTypes.HEAT_EXCHANGER), new Consumer[0]);
        ReiMachineRecipes.registerMultiblockShape("heat_exchanger", heatExchangerShape);
    }

    private static void pressurizer() {
        ShapeTemplate.Builder pressurizeShapeBuilder = new ShapeTemplate.Builder(MachineCasings.TITANIUM);
        for (int y = -1; y < 3; ++y) {
            SimpleMember member = y == -1 || y == 2 ? titaniumCasing : titaniumPipe;
            HatchFlags flag = null;
            if (y == -1) {
                flag = new HatchFlags.Builder().with(HatchType.ENERGY_INPUT, HatchType.FLUID_OUTPUT).build();
            } else if (y == 2) {
                flag = new HatchFlags.Builder().with(HatchType.FLUID_INPUT, HatchType.ITEM_INPUT).build();
            }
            pressurizeShapeBuilder.add(-1, y, 1, member, flag);
            pressurizeShapeBuilder.add(0, y, 1, member, flag);
            pressurizeShapeBuilder.add(1, y, 1, member, flag);
            pressurizeShapeBuilder.add(0, y, 2, member, flag);
            if (y == 0) continue;
            pressurizeShapeBuilder.add(0, y, 0, member, flag);
        }
        ShapeTemplate pressurizerShape = pressurizeShapeBuilder.build();
        PRESSURIZER = MachineRegistrationHelper.registerMachine("Pressurizer", "pressurizer", bet -> new ElectricCraftingMultiblockBlockEntity((BEP)bet, "pressurizer", pressurizerShape, MIMachineRecipeTypes.PRESSURIZER), new Consumer[0]);
        ReiMachineRecipes.registerMultiblockShape("pressurizer", pressurizerShape);
    }

    private static void implosionCompressor() {
        ShapeTemplate.Builder implosionCompressorShapeBuilder = new ShapeTemplate.Builder(MachineCasings.TITANIUM);
        HatchFlags hatchs = new HatchFlags.Builder().with(HatchType.ITEM_OUTPUT, HatchType.ITEM_INPUT, HatchType.ENERGY_INPUT).build();
        implosionCompressorShapeBuilder.add3by3(0, titaniumCasing, false, hatchs);
        implosionCompressorShapeBuilder.add3by3(1, blastProofCasing, true, null);
        implosionCompressorShapeBuilder.add3by3(2, blastProofCasing, true, null);
        implosionCompressorShapeBuilder.add3by3(3, titaniumCasing, false, null);
        ShapeTemplate implosionCompressorShape = implosionCompressorShapeBuilder.build();
        IMPLOSION_COMPRESSOR = MachineRegistrationHelper.registerMachine("Implosion Compressor", "implosion_compressor", bet -> new ElectricCraftingMultiblockBlockEntity((BEP)bet, "implosion_compressor", implosionCompressorShape, MIMachineRecipeTypes.IMPLOSION_COMPRESSOR), new Consumer[0]);
        ReiMachineRecipes.registerMultiblockShape("implosion_compressor", implosionCompressorShape);
    }

    private static void nuclearReactor() {
        NUCLEAR_REACTOR = MachineRegistrationHelper.registerMachine("Nuclear Reactor", "nuclear_reactor", NuclearReactorMultiblockBlockEntity::new, new Consumer[0]);
        NuclearReactorMultiblockBlockEntity.registerReiShapes();
    }

    private static void largeTank() {
        LARGE_TANK = MachineRegistrationHelper.registerMachine("Large Tank", "large_tank", LargeTankMultiblockBlockEntity::new, new Consumer[0]);
        LargeTankMultiblockBlockEntity.registerFluidAPI(LARGE_TANK);
    }

    private static void fusionReactor() {
        ShapeTemplate.Builder fusionReactorShapeBuilder = new ShapeTemplate.Builder(MachineCasings.EV);
        int[][] shapeEdge = new int[][]{{6, 1, 0, 0}, {4, 3, 0, 0}, {3, 3, 0, 0}, {2, 2, 0, 0}, {1, 2, 0, 0}, {1, 2, 0, 0}, {0, 2, 0, 0}};
        int[][] shapeCenter = new int[][]{{5, 2, 0, 0}, {3, 2, 2, 0}, {2, 1, 2, 2}, {1, 1, 2, 1}, {1, 1, 1, 1}, {0, 1, 1, 1}, {0, 1, 1, 1}};
        for (int y = -1; y <= 1; ++y) {
            int[][] shape = y == 0 ? shapeCenter : shapeEdge;
            for (int i = 0; i < 7; ++i) {
                int x = i + 1;
                for (int k = 0; k < 4; ++k) {
                    int[] placement = shape[6 - i];
                    int z0 = placement[0];
                    int z1 = z0 + placement[1];
                    int z2 = z1 + placement[2];
                    int z3 = z2 + placement[3];
                    for (int z = z0; z < z3; ++z) {
                        if (z < z1 || z >= z2) {
                            fusionReactorShapeBuilder.add(x, y, z, highlyAdvancedHull);
                            fusionReactorShapeBuilder.add(-x, y, z, highlyAdvancedHull);
                            fusionReactorShapeBuilder.add(x, y, 14 - z, highlyAdvancedHull);
                            fusionReactorShapeBuilder.add(-x, y, 14 - z, highlyAdvancedHull);
                            continue;
                        }
                        if (z < z1) continue;
                        fusionReactorShapeBuilder.add(x, y, z, fusionChamber);
                        fusionReactorShapeBuilder.add(-x, y, z, fusionChamber);
                        fusionReactorShapeBuilder.add(x, y, 14 - z, fusionChamber);
                        fusionReactorShapeBuilder.add(-x, y, 14 - z, fusionChamber);
                    }
                }
            }
            HatchFlags flags = new HatchFlags.Builder().with(HatchType.FLUID_INPUT, HatchType.FLUID_OUTPUT, HatchType.ENERGY_INPUT).build();
            for (int l = 0; l < (y == 0 ? 3 : 2); ++l) {
                if (y != 0 || l != 1) {
                    HatchFlags currentFlag;
                    HatchFlags hatchFlags = currentFlag = l == 0 ? flags : null;
                    if (l != 0 || y != 0) {
                        fusionReactorShapeBuilder.add(0, y, l, highlyAdvancedHull, currentFlag);
                    }
                    fusionReactorShapeBuilder.add(0, y, 14 - l, highlyAdvancedHull, currentFlag);
                    fusionReactorShapeBuilder.add(-7 + l, y, 7, highlyAdvancedHull, currentFlag);
                    fusionReactorShapeBuilder.add(7 - l, y, 7, highlyAdvancedHull, currentFlag);
                    continue;
                }
                fusionReactorShapeBuilder.add(0, y, l, fusionChamber);
                fusionReactorShapeBuilder.add(0, y, 14 - l, fusionChamber);
                fusionReactorShapeBuilder.add(-7 + l, y, 7, fusionChamber);
                fusionReactorShapeBuilder.add(7 - l, y, 7, fusionChamber);
            }
        }
        ShapeTemplate fusionReactorShape = fusionReactorShapeBuilder.build();
        FUSION_REACTOR = MachineRegistrationHelper.registerMachine("Fusion Reactor", "fusion_reactor", bet -> new FusionReactorBlockEntity((BEP)bet, "fusion_reactor", fusionReactorShape), new Consumer[0]);
        ReiMachineRecipes.registerMultiblockShape("fusion_reactor", fusionReactorShape);
    }

    private static void plasmaTurbine() {
        ShapeTemplate plasmaTurbineShape = MultiblockMachines.largeTurbineShape(MachineCasings.PLASMA_HANDLING_IRIDIUM, plasmaHandlingIridium, iridiumPipe);
        PLASMA_TURBINE = MachineRegistrationHelper.registerMachine("Plasma Turbine", "plasma_turbine", bet -> new EnergyFromFluidMultiblockBlockEntity((BEP)bet, "plasma_turbine", plasmaTurbineShape, FluidConsumerComponent.of(0x100000L, MIFluids.HELIUM_PLASMA.asFluid(), 100000L)), new Consumer[0]);
        ReiMachineRecipes.registerMultiblockShape("plasma_turbine", plasmaTurbineShape);
    }

    public static void init() {
        invarCasings = SimpleMember.forBlock(((BlockDefinition)MIBlock.BLOCKS.get((Object)new MIIdentifier("heatproof_machine_casing"))).asBlock());
        bronzePlatedBricks = SimpleMember.forBlock(((BlockDefinition)MIBlock.BLOCKS.get((Object)new MIIdentifier("bronze_plated_bricks"))).asBlock());
        bronzePipe = SimpleMember.forBlock(((BlockDefinition)MIBlock.BLOCKS.get((Object)new MIIdentifier("bronze_machine_casing_pipe"))).asBlock());
        frostproofMachineCasing = SimpleMember.forBlock(((BlockDefinition)MIBlock.BLOCKS.get((Object)new MIIdentifier("frostproof_machine_casing"))).asBlock());
        stainlessSteelClean = SimpleMember.forBlock(((BlockDefinition)MIBlock.BLOCKS.get((Object)new MIIdentifier("clean_stainless_steel_machine_casing"))).asBlock());
        stainlessSteelPipe = SimpleMember.forBlock(((BlockDefinition)MIBlock.BLOCKS.get((Object)new MIIdentifier("stainless_steel_machine_casing_pipe"))).asBlock());
        titaniumCasing = SimpleMember.forBlock(((BlockDefinition)MIBlock.BLOCKS.get((Object)new MIIdentifier("solid_titanium_machine_casing"))).asBlock());
        titaniumPipe = SimpleMember.forBlock(((BlockDefinition)MIBlock.BLOCKS.get((Object)new MIIdentifier("titanium_machine_casing_pipe"))).asBlock());
        blastProofCasing = SimpleMember.forBlock(((BlockDefinition)MIBlock.BLOCKS.get((Object)new MIIdentifier("blastproof_casing"))).asBlock());
        highlyAdvancedHull = SimpleMember.forBlock(((BlockDefinition)MIBlock.BLOCKS.get((Object)new MIIdentifier("highly_advanced_machine_hull"))).asBlock());
        fusionChamber = SimpleMember.forBlock(((BlockDefinition)MIBlock.BLOCKS.get((Object)new MIIdentifier("fusion_chamber"))).asBlock());
        plasmaHandlingIridium = SimpleMember.forBlock(((BlockDefinition)MIBlock.BLOCKS.get((Object)new MIIdentifier("plasma_handling_iridium_machine_casing"))).asBlock());
        iridiumPipe = SimpleMember.forBlock(((BlockDefinition)MIBlock.BLOCKS.get((Object)new MIIdentifier("iridium_machine_casing_pipe"))).asBlock());
        MultiblockMachines.cokeOven();
        MultiblockMachines.steamBlastFurnace();
        MultiblockMachines.electricBlastFurnace();
        MultiblockMachines.steamBoilers();
        MultiblockMachines.quarries();
        MultiblockMachines.oilDrillingRig();
        MultiblockMachines.vacuumFreezer();
        MultiblockMachines.distillationTower();
        MultiblockMachines.largeDieselGenerator();
        MultiblockMachines.largeSteamTurbine();
        MultiblockMachines.heathExchanger();
        MultiblockMachines.pressurizer();
        MultiblockMachines.implosionCompressor();
        MultiblockMachines.nuclearReactor();
        MultiblockMachines.largeTank();
        MultiblockMachines.fusionReactor();
        MultiblockMachines.plasmaTurbine();
    }

    public static void clientInit() {
        MachineModels.addTieredMachine("coke_oven", "coke_oven", MachineCasings.BRICKS, true, false, false);
        BlockEntityRendererRegistry.register((class_2591)COKE_OVEN, MultiblockMachineBER::new);
        new Rei("Coke Oven", "coke_oven", MIMachineRecipeTypes.COKE_OVEN, new ProgressBar.Parameters(77, 33, "arrow")).items(inputs -> inputs.addSlot(56, 35), outputs -> outputs.addSlot(102, 35)).fluids(inputs -> {}, outputs -> outputs.addSlot(102, 53)).steam(true).register();
        MachineModels.addTieredMachine("steam_blast_furnace", "steam_blast_furnace", MachineCasings.FIREBRICKS, true, false, false);
        BlockEntityRendererRegistry.register((class_2591)STEAM_BLAST_FURNACE, MultiblockMachineBER::new);
        new Rei("Steam Blast Furnace", "steam_blast_furnace", MIMachineRecipeTypes.BLAST_FURNACE, new ProgressBar.Parameters(77, 33, "arrow")).items(inputs -> inputs.addSlots(56, 35, 2, 1), outputs -> outputs.addSlots(102, 35, 1, 1)).fluids(fluids -> fluids.addSlots(36, 35, 1, 1), outputs -> outputs.addSlots(122, 35, 1, 1)).workstations("steam_blast_furnace", "electric_blast_furnace").extraTest(recipe -> recipe.eu <= 4).steam(false).register();
        MachineModels.addTieredMachine("electric_blast_furnace", "electric_blast_furnace", MachineCasings.HEATPROOF, true, false, false);
        BlockEntityRendererRegistry.register((class_2591)ELECTRIC_BLAST_FURNACE, MultiblockMachineBER::new);
        MachineModels.addTieredMachine("large_steam_boiler", "large_boiler", MachineCasings.BRONZE_PLATED_BRICKS, true, false, false);
        BlockEntityRendererRegistry.register((class_2591)LARGE_STEAM_BOILER, MultiblockMachineBER::new);
        MachineModels.addTieredMachine("advanced_large_steam_boiler", "large_boiler", MachineCasings.BRONZE_PLATED_BRICKS, true, false, false);
        BlockEntityRendererRegistry.register((class_2591)ADVANCED_LARGE_STEAM_BOILER, MultiblockMachineBER::new);
        MachineModels.addTieredMachine("high_pressure_large_steam_boiler", "large_boiler", MachineCasings.CLEAN_STAINLESS_STEEL, true, false, false);
        BlockEntityRendererRegistry.register((class_2591)HIGH_PRESSURE_LARGE_STEAM_BOILER, MultiblockMachineBER::new);
        MachineModels.addTieredMachine("high_pressure_advanced_large_steam_boiler", "large_boiler", MachineCasings.CLEAN_STAINLESS_STEEL, true, false, false);
        BlockEntityRendererRegistry.register((class_2591)HIGH_PRESSURE_ADVANCED_LARGE_STEAM_BOILER, MultiblockMachineBER::new);
        MachineModels.addTieredMachine("steam_quarry", "quarry", MachineCasings.STEEL, true, false, false);
        BlockEntityRendererRegistry.register((class_2591)STEAM_QUARRY, MultiblockMachineBER::new);
        new Rei("Steam Quarry", "steam_quarry", MIMachineRecipeTypes.QUARRY, new ProgressBar.Parameters(77, 33, "arrow")).items(inputs -> inputs.addSlot(56, 35), outputs -> outputs.addSlots(102, 35, 4, 4)).workstations("steam_quarry", "electric_quarry").extraTest(recipe -> recipe.eu <= 4).steam(false).register();
        new Rei("Electric Quarry", "electric_quarry", MIMachineRecipeTypes.QUARRY, new ProgressBar.Parameters(77, 33, "arrow")).items(inputs -> inputs.addSlot(56, 35), outputs -> outputs.addSlots(102, 35, 4, 4)).workstations("electric_quarry").extraTest(recipe -> recipe.eu > 4).register();
        MachineModels.addTieredMachine("electric_quarry", "quarry", MachineCasings.STEEL, true, false, false);
        BlockEntityRendererRegistry.register((class_2591)ELECTRIC_QUARRY, MultiblockMachineBER::new);
        MachineModels.addTieredMachine("vacuum_freezer", "vacuum_freezer", MachineCasings.FROSTPROOF, true, false, false);
        BlockEntityRendererRegistry.register((class_2591)VACUUM_FREEZER, MultiblockMachineBER::new);
        new Rei("Vacuum Freezer", "vacuum_freezer", MIMachineRecipeTypes.VACUUM_FREEZER, new ProgressBar.Parameters(77, 33, "arrow")).items(inputs -> inputs.addSlots(56, 35, 2, 1), outputs -> outputs.addSlot(102, 35)).fluids(inputs -> inputs.addSlots(36, 35, 2, 1), outputs -> outputs.addSlot(122, 35)).register();
        MachineModels.addTieredMachine("oil_drilling_rig", "oil_drilling_rig", MachineCasings.STEEL, true, false, false);
        BlockEntityRendererRegistry.register((class_2591)OIL_DRILLING_RIG, MultiblockMachineBER::new);
        new Rei("Oil Drilling Rig", "oil_drilling_rig", MIMachineRecipeTypes.OIL_DRILLING_RIG, new ProgressBar.Parameters(77, 33, "arrow")).items(inputs -> inputs.addSlot(36, 35), outputs -> {}).fluids(inputs -> {}, outputs -> outputs.addSlot(122, 35)).register();
        MachineModels.addTieredMachine("distillation_tower", "distillation_tower", MachineCasings.CLEAN_STAINLESS_STEEL, true, false, false);
        BlockEntityRendererRegistry.register((class_2591)DISTILLATION_TOWER, MultiblockMachineBER::new);
        new Rei("Distillation Tower", "distillation_tower", MIMachineRecipeTypes.DISTILLATION_TOWER, new ProgressBar.Parameters(77, 33, "arrow")).fluids(inputs -> inputs.addSlot(56, 35), outputs -> outputs.addSlots(102, 35, 1, 8)).register();
        MachineModels.addTieredMachine("large_diesel_generator", "diesel_generator", MachineCasings.SOLID_TITANIUM, true, false, false);
        BlockEntityRendererRegistry.register((class_2591)LARGE_DIESEL_GENERATOR, MultiblockMachineBER::new);
        MachineModels.addTieredMachine("large_steam_turbine", "steam_turbine", MachineCasings.CLEAN_STAINLESS_STEEL, true, false, false);
        BlockEntityRendererRegistry.register((class_2591)LARGE_STEAM_TURBINE, MultiblockMachineBER::new);
        MachineModels.addTieredMachine("heat_exchanger", "heat_exchanger", MachineCasings.STAINLESS_STEEL_PIPE, true, false, false);
        BlockEntityRendererRegistry.register((class_2591)HEAT_EXCHANGER, MultiblockMachineBER::new);
        new Rei("Heat Exchanger", "heat_exchanger", MIMachineRecipeTypes.HEAT_EXCHANGER, new ProgressBar.Parameters(77, 42, "arrow")).items(inputs -> inputs.addSlot(36, 35), outputs -> outputs.addSlot(122, 35)).fluids(inputs -> inputs.addSlots(56, 35, 2, 1), outputs -> outputs.addSlots(102, 35, 2, 1)).register();
        MachineModels.addTieredMachine("pressurizer", "pressurizer", MachineCasings.TITANIUM_PIPE, true, false, false);
        BlockEntityRendererRegistry.register((class_2591)PRESSURIZER, MultiblockMachineBER::new);
        new Rei("Pressurizer", "pressurizer", MIMachineRecipeTypes.PRESSURIZER, new ProgressBar.Parameters(77, 33, "arrow")).items(inputs -> inputs.addSlot(38, 35), outputs -> {}).fluids(inputs -> inputs.addSlot(56, 35), outputs -> outputs.addSlot(102, 35)).register();
        MachineModels.addTieredMachine("implosion_compressor", "compressor", MachineCasings.SOLID_TITANIUM, true, false, false);
        BlockEntityRendererRegistry.register((class_2591)IMPLOSION_COMPRESSOR, MultiblockMachineBER::new);
        new Rei("Implosion Compressor", "implosion_compressor", MIMachineRecipeTypes.IMPLOSION_COMPRESSOR, new ProgressBar.Parameters(77, 42, "compress")).items(inputs -> inputs.addSlots(36, 35, 2, 2), outputs -> outputs.addSlot(102, 42)).register();
        MachineModels.addTieredMachine("nuclear_reactor", "nuclear_reactor", MachineCasings.NUCLEAR, true, false, false, true);
        BlockEntityRendererRegistry.register((class_2591)NUCLEAR_REACTOR, MultiblockMachineBER::new);
        MachineModels.addTieredMachine("large_tank", "large_tank", MachineCasings.STEEL, true, false, false, false);
        BlockEntityRendererRegistry.register((class_2591)LARGE_TANK, MultiblockTankBER::new);
        MachineModels.addTieredMachine("fusion_reactor", "fusion_reactor", MachineCasings.EV, true, false, false, true);
        BlockEntityRendererRegistry.register((class_2591)FUSION_REACTOR, MultiblockMachineBER::new);
        new Rei("Fusion Reactor", "fusion_reactor", MIMachineRecipeTypes.FUSION_REACTOR, new ProgressBar.Parameters(66, 33, "arrow")).fluids(inputs -> inputs.addSlots(26, 35, 1, 2), outputs -> outputs.addSlots(92, 35, 1, 3)).register();
        MachineModels.addTieredMachine("plasma_turbine", "steam_turbine", MachineCasings.PLASMA_HANDLING_IRIDIUM, true, false, false);
        BlockEntityRendererRegistry.register((class_2591)PLASMA_TURBINE, MultiblockMachineBER::new);
    }

    static {
        fluidInputs = new HatchFlags.Builder().with(HatchType.FLUID_INPUT).build();
        energyOutput = new HatchFlags.Builder().with(HatchType.ENERGY_OUTPUT).build();
        energyInput = new HatchFlags.Builder().with(HatchType.ENERGY_INPUT).build();
        CRAFTING_GUI = new Rectangle(4, 16, 166, 80);
    }

    public static class Rei {
        private final String englishName;
        private final String category;
        private final MachineRecipeType recipeType;
        private final ProgressBar.Parameters progressBarParams;
        private final List<String> workstations;
        private Predicate<MachineRecipe> extraTest = recipe -> true;
        private SlotPositions itemInputs = SlotPositions.empty();
        private SlotPositions itemOutputs = SlotPositions.empty();
        private SlotPositions fluidInputs = SlotPositions.empty();
        private SlotPositions fluidOutputs = SlotPositions.empty();
        private SteamMode steamMode = SteamMode.ELECTRIC_ONLY;
        private static final Predicate<MachineScreenHandlers.ClientScreen> SHAPE_VALID_PREDICATE = screen -> {
            for (SyncedComponent.Client client : ((MachineScreenHandlers.Client)screen.method_17577()).components) {
                if (!(client instanceof CraftingMultiblockGui.Client)) continue;
                CraftingMultiblockGui.Client cmGui = (CraftingMultiblockGui.Client)client;
                if (!cmGui.isShapeValid) continue;
                return true;
            }
            return false;
        };

        public Rei(String englishName, String category, MachineRecipeType recipeType, ProgressBar.Parameters progressBarParams) {
            this.englishName = englishName;
            this.category = category;
            this.recipeType = recipeType;
            this.progressBarParams = progressBarParams;
            this.workstations = new ArrayList<String>();
            this.workstations.add(category);
        }

        public Rei items(Consumer<SlotPositions.Builder> inputs, Consumer<SlotPositions.Builder> outputs) {
            this.itemInputs = new SlotPositions.Builder().buildWithConsumer(inputs);
            this.itemOutputs = new SlotPositions.Builder().buildWithConsumer(outputs);
            return this;
        }

        public Rei fluids(Consumer<SlotPositions.Builder> inputs, Consumer<SlotPositions.Builder> outputs) {
            this.fluidInputs = new SlotPositions.Builder().buildWithConsumer(inputs);
            this.fluidOutputs = new SlotPositions.Builder().buildWithConsumer(outputs);
            return this;
        }

        public Rei extraTest(Predicate<MachineRecipe> extraTest) {
            this.extraTest = extraTest;
            return this;
        }

        public Rei workstations(String ... workstations) {
            this.workstations.clear();
            this.workstations.addAll(Arrays.asList(workstations));
            return this;
        }

        public Rei steam(boolean steamOnly) {
            this.steamMode = steamOnly ? SteamMode.STEAM_ONLY : SteamMode.BOTH;
            return this;
        }

        public final void register() {
            ReiMachineRecipes.registerCategory(this.category, new MachineCategoryParams(this.englishName, this.category, this.itemInputs, this.itemOutputs, this.fluidInputs, this.fluidOutputs, this.progressBarParams, recipe -> recipe.method_17716() == this.recipeType && this.extraTest.test((MachineRecipe)recipe), true, this.steamMode));
            for (String workstation : this.workstations) {
                ReiMachineRecipes.registerWorkstation(this.category, workstation);
                ReiMachineRecipes.registerRecipeCategoryForMachine(workstation, this.category, SHAPE_VALID_PREDICATE);
                ReiMachineRecipes.registerMachineClickArea(workstation, CRAFTING_GUI);
            }
        }
    }
}

