/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.init;

import aztech.modern_industrialization.MIFluids;
import aztech.modern_industrialization.api.energy.CableTier;
import aztech.modern_industrialization.machines.BEP;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.blockentities.AbstractStorageMachineBlockEntity;
import aztech.modern_industrialization.machines.blockentities.BoilerMachineBlockEntity;
import aztech.modern_industrialization.machines.blockentities.ConfigurableChestMachineBlockEntity;
import aztech.modern_industrialization.machines.blockentities.ElectricWaterPumpBlockEntity;
import aztech.modern_industrialization.machines.blockentities.EnergyFromFluidMachineBlockEntity;
import aztech.modern_industrialization.machines.blockentities.ReplicatorMachineBlockEntity;
import aztech.modern_industrialization.machines.blockentities.SteamWaterPumpBlockEntity;
import aztech.modern_industrialization.machines.blockentities.StorageMachineBlockEntity;
import aztech.modern_industrialization.machines.blockentities.TransformerMachineBlockEntity;
import aztech.modern_industrialization.machines.components.FluidConsumerComponent;
import aztech.modern_industrialization.machines.init.MachineRegistrationHelper;
import aztech.modern_industrialization.machines.models.MachineCasing;
import aztech.modern_industrialization.machines.models.MachineCasings;
import aztech.modern_industrialization.machines.models.MachineModels;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;

public class SingleBlockSpecialMachines {
    public static void init() {
        MachineRegistrationHelper.registerMachine("Bronze Boiler", "bronze_boiler", bet -> new BoilerMachineBlockEntity((BEP)bet, true), MachineBlockEntity::registerFluidApi, MachineBlockEntity::registerItemApi);
        MachineRegistrationHelper.registerMachine("Steel Boiler", "steel_boiler", bet -> new BoilerMachineBlockEntity((BEP)bet, false), MachineBlockEntity::registerFluidApi, MachineBlockEntity::registerItemApi);
        MachineRegistrationHelper.registerMachine("Bronze Water Pump", "bronze_water_pump", bet -> new SteamWaterPumpBlockEntity((BEP)bet, true), MachineBlockEntity::registerFluidApi);
        MachineRegistrationHelper.registerMachine("Steel Water Pump", "steel_water_pump", bet -> new SteamWaterPumpBlockEntity((BEP)bet, false), MachineBlockEntity::registerFluidApi);
        MachineRegistrationHelper.registerMachine("Electric Water Pump", "electric_water_pump", ElectricWaterPumpBlockEntity::new, MachineBlockEntity::registerFluidApi, ElectricWaterPumpBlockEntity::registerEnergyApi);
        SingleBlockSpecialMachines.registerTransformers();
        SingleBlockSpecialMachines.registerSteamTurbines(32, 128, 512);
        SingleBlockSpecialMachines.registerEUStorage();
        MachineRegistrationHelper.registerMachine("Diesel Generator", "diesel_generator", bet -> new EnergyFromFluidMachineBlockEntity((BEP)bet, "diesel_generator", CableTier.MV, 12000L, 32000L, FluidConsumerComponent.ofFluidFuels(256L)), MachineBlockEntity::registerFluidApi, EnergyFromFluidMachineBlockEntity::registerEnergyApi);
        MachineRegistrationHelper.registerMachine("Turbo Diesel Generator", "turbo_diesel_generator", bet -> new EnergyFromFluidMachineBlockEntity((BEP)bet, "turbo_diesel_generator", CableTier.HV, 60000L, 64000L, FluidConsumerComponent.ofFluidFuels(1024L)), MachineBlockEntity::registerFluidApi, EnergyFromFluidMachineBlockEntity::registerEnergyApi);
        MachineRegistrationHelper.registerMachine("Configurable Chest", "configurable_chest", ConfigurableChestMachineBlockEntity::new, MachineBlockEntity::registerItemApi);
        MachineRegistrationHelper.registerMachine("Replicator", "replicator", ReplicatorMachineBlockEntity::new, MachineBlockEntity::registerFluidApi, MachineBlockEntity::registerItemApi);
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            MachineModels.addTieredMachineTiers("water_pump", true, true, true, "bronze", "steel", "electric");
            MachineModels.addTieredMachine("bronze_boiler", "boiler", MachineCasings.BRICKED_BRONZE, true, false, false);
            MachineModels.addTieredMachine("steel_boiler", "boiler", MachineCasings.BRICKED_STEEL, true, false, false);
            MachineModels.addTieredMachine("diesel_generator", "diesel_generator", MachineCasings.MV, true, true, true);
            MachineModels.addTieredMachine("turbo_diesel_generator", "diesel_generator", MachineCasings.HV, true, true, true);
            MachineModels.addTieredMachine("configurable_chest", "", MachineCasings.STEEL_CRATE, false, false, false, false);
            MachineModels.addTieredMachine("replicator", "replicator", MachineCasings.SUPERCONDUCTOR, true, false, true, true);
        }
    }

    private static void registerTransformers() {
        CableTier[] tiers = CableTier.values();
        for (int i = 0; i < tiers.length - 1; ++i) {
            CableTier low = tiers[i];
            CableTier up = tiers[i + 1];
            String lowToUp = TransformerMachineBlockEntity.getTransformerName(low, up);
            String lowToUpName = TransformerMachineBlockEntity.getTransformerEnglishName(low, up);
            MachineRegistrationHelper.registerMachine(lowToUpName, lowToUp, bet -> new TransformerMachineBlockEntity((BEP)bet, low, up), AbstractStorageMachineBlockEntity::registerEnergyApi);
            String upToLow = TransformerMachineBlockEntity.getTransformerName(up, low);
            String upToLowName = TransformerMachineBlockEntity.getTransformerEnglishName(up, low);
            MachineRegistrationHelper.registerMachine(upToLowName, upToLow, bet -> new TransformerMachineBlockEntity((BEP)bet, up, low), AbstractStorageMachineBlockEntity::registerEnergyApi);
            if (FabricLoader.getInstance().getEnvironmentType() != EnvType.CLIENT) continue;
            MachineModels.addTieredMachine(lowToUp, "transformer", SingleBlockSpecialMachines.getTransformerCasingFromTier(low, up), true, true, true, false);
            MachineModels.addTieredMachine(upToLow, "transformer", SingleBlockSpecialMachines.getTransformerCasingFromTier(up, low), true, true, true, false);
        }
    }

    public static MachineCasing getTransformerCasingFromTier(CableTier from, CableTier to) {
        return MachineCasings.casingFromCableTier(from.eu > to.eu ? to : from);
    }

    private static void registerSteamTurbines(int ... maxConsumption) {
        for (int i = 0; i < maxConsumption.length; ++i) {
            CableTier tier = CableTier.values()[i];
            String id = tier.name + "_steam_turbine";
            String englishName = tier.englishName + " Steam Turbine";
            int eu = maxConsumption[i];
            int fluidCapacity = 16000 * (1 << i);
            MachineRegistrationHelper.registerMachine(englishName, id, bet -> new EnergyFromFluidMachineBlockEntity((BEP)bet, id, tier, (long)eu * 100L, (long)fluidCapacity, eu, MIFluids.STEAM.asFluid(), 1L), MachineBlockEntity::registerFluidApi, EnergyFromFluidMachineBlockEntity::registerEnergyApi);
            if (FabricLoader.getInstance().getEnvironmentType() != EnvType.CLIENT) continue;
            MachineModels.addTieredMachine(id, "steam_turbine", MachineCasings.casingFromCableTier(tier), true, false, false);
        }
    }

    private static void registerEUStorage() {
        for (CableTier tier : CableTier.values()) {
            String id = tier.name + "_storage_unit";
            String englishName = tier.englishName + " Storage Unit";
            MachineRegistrationHelper.registerMachine(englishName, id, bet -> new StorageMachineBlockEntity((BEP)bet, tier, id, 6000L * tier.eu), AbstractStorageMachineBlockEntity::registerEnergyApi);
            if (FabricLoader.getInstance().getEnvironmentType() != EnvType.CLIENT) continue;
            MachineModels.addTieredMachine(id, "electric_storage", MachineCasings.casingFromCableTier(tier), true, false, true, false);
        }
    }
}

