/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.materials.part;

import aztech.modern_industrialization.items.SortOrder;
import aztech.modern_industrialization.materials.part.BuildablePart;
import aztech.modern_industrialization.materials.part.RegularPart;
import aztech.modern_industrialization.materials.part.UnbuildablePart;
import aztech.modern_industrialization.materials.set.MaterialBlockSet;
import aztech.modern_industrialization.textures.TextureHelper;
import java.io.IOException;
import net.minecraft.class_1011;

public class BlockPart
extends UnbuildablePart<MaterialBlockSet> {
    public BlockPart() {
        super("block");
    }

    @Override
    public BuildablePart of(MaterialBlockSet set) {
        return new RegularPart("Block of %s", this.key).asBlock(SortOrder.STORAGE_BLOCKS).withTextureRegister((mtm, partContext, part, itemPath) -> {
            String template = String.format("modern_industrialization:textures/materialsets/blocks/%s.png", set.name);
            try {
                class_1011 image = mtm.getAssetAsTexture(template);
                TextureHelper.colorize(image, partContext.getColoramp());
                String texturePath = String.format("modern_industrialization:textures/block/%s.png", itemPath);
                mtm.addTexture(texturePath, image);
                image.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }
}

