/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.materials.part;

import aztech.modern_industrialization.MIBlock;
import aztech.modern_industrialization.MIIdentifier;
import aztech.modern_industrialization.MITags;
import aztech.modern_industrialization.blocks.storage.tank.TankBlock;
import aztech.modern_industrialization.blocks.storage.tank.TankBlockEntity;
import aztech.modern_industrialization.blocks.storage.tank.TankItem;
import aztech.modern_industrialization.datagen.tag.TagsToGenerate;
import aztech.modern_industrialization.definition.BlockDefinition;
import aztech.modern_industrialization.items.SortOrder;
import aztech.modern_industrialization.materials.part.RegularPart;
import aztech.modern_industrialization.materials.part.UnbuildablePart;
import aztech.modern_industrialization.proxy.CommonProxy;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.fabricmc.fabric.api.object.builder.v1.block.entity.FabricBlockEntityTypeBuilder;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2343;
import net.minecraft.class_2378;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_4910;
import net.minecraft.class_4942;
import net.minecraft.class_4944;
import net.minecraft.class_4945;
import org.apache.commons.lang3.mutable.MutableObject;

public class TankPart
extends UnbuildablePart<Long> {
    public static final BiConsumer<class_2248, class_4910> MODEL_GENERATOR = (block, gen) -> {
        class_4945 textureSlot = class_4945.method_27043((String)"0");
        class_4944 mapping = class_4944.method_25883((class_4945)textureSlot, (class_2960)new MIIdentifier("block/" + class_2378.field_11146.method_10221(block).method_12832()));
        gen.method_25540(block);
        gen.method_35868(block, mapping, new class_4942(Optional.of(new MIIdentifier("base/tank")), Optional.empty(), new class_4945[]{textureSlot}));
    };

    public TankPart() {
        super("tank");
    }

    public RegularPart of(int bucketCapacity) {
        return this.of("Tank", Long.valueOf(bucketCapacity));
    }

    public RegularPart of(String englishNameFormatter, int bucketCapacity) {
        return this.of(englishNameFormatter, Long.valueOf(bucketCapacity));
    }

    public RegularPart of(Long bucketCapacity) {
        return this.of("Tank", bucketCapacity);
    }

    public RegularPart of(String englishNameFormatter, Long bucketCapacity) {
        MutableObject bet = new MutableObject();
        long capacity = 81000L * bucketCapacity;
        return new RegularPart(englishNameFormatter, this.key).asBlock(SortOrder.TANKS).withRegister((partContext, part, itemPath, itemId, itemTag) -> {
            class_2343 factory = (pos, state) -> new TankBlockEntity((class_2591)bet.getValue(), pos, state, capacity);
            String englishName = RegularPart.getEnglishName(englishNameFormatter, partContext.getEnglishName());
            BlockDefinition<TankBlock> blockDefinition = MIBlock.block(englishName, itemPath, MIBlock.BlockDefinitionParams.of().withBlockConstructor(s -> new TankBlock(factory)).withBlockItemConstructor((b, s) -> new TankItem((class_2248)b, capacity)).withModel(MODEL_GENERATOR).noLootTable().sortOrder(SortOrder.TANKS.and((Comparable)((Object)partContext.getMaterialName()))));
            TankBlock block = blockDefinition.asBlock();
            TankItem item = (TankItem)blockDefinition.method_8389();
            TagsToGenerate.generateTag(MITags.TANKS, (class_1792)item);
            bet.setValue((Object)((class_2591)class_2378.method_10226((class_2378)class_2378.field_11137, (String)itemId, (Object)FabricBlockEntityTypeBuilder.create((arg_0, arg_1) -> ((class_2343)block.factory).method_10123(arg_0, arg_1), (class_2248[])new class_2248[]{block}).build(null))));
            FluidStorage.SIDED.registerSelf(new class_2591[]{(class_2591)bet.getValue()});
            item.registerItemApi();
            CommonProxy.INSTANCE.registerPartTankClient(block, partContext.getMaterialName(), itemPath, (class_2591<class_2586>)((class_2591)bet.getValue()));
        });
    }
}

