/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.materials.recipe.builder;

import aztech.modern_industrialization.machines.recipe.MachineRecipeType;
import aztech.modern_industrialization.materials.MaterialBuilder;
import aztech.modern_industrialization.materials.part.MaterialPart;
import aztech.modern_industrialization.materials.part.Part;
import aztech.modern_industrialization.materials.recipe.builder.MaterialRecipeBuilder;
import aztech.modern_industrialization.recipe.json.MIRecipeJson;
import com.google.gson.Gson;
import java.util.function.Consumer;
import net.minecraft.class_2444;

public class MIRecipeBuilder
extends MIRecipeJson<MIRecipeBuilder>
implements MaterialRecipeBuilder {
    private static final Gson GSON = new Gson();
    public final transient String recipeId;
    private final transient MaterialBuilder.RecipeContext context;
    private transient boolean canceled = false;

    public MIRecipeBuilder(MaterialBuilder.RecipeContext context, MachineRecipeType type, String recipeSuffix, int eu, int duration) {
        super(type, eu, duration);
        this.recipeId = type.getPath() + "/" + recipeSuffix;
        this.context = context;
        context.addRecipe(this);
    }

    public MIRecipeBuilder(MaterialBuilder.RecipeContext context, String recipeSuffix, MIRecipeJson<?> otherWithSameRecipeData) {
        super(otherWithSameRecipeData);
        this.recipeId = this.machineRecipeType.getPath() + "/" + recipeSuffix;
        this.context = context;
        context.addRecipe(this);
    }

    public MIRecipeBuilder(MaterialBuilder.RecipeContext context, MachineRecipeType type, String recipeSuffix) {
        this(context, type, recipeSuffix, 2, (int)(200.0 * context.getHardness().timeFactor));
    }

    public MIRecipeBuilder(MaterialBuilder.RecipeContext context, MachineRecipeType type, Part recipeSuffix) {
        this(context, type, recipeSuffix.key);
    }

    public MIRecipeBuilder addPartInput(Part part, int amount) {
        return this.addPartInput(this.context.getPart(part), amount);
    }

    public MIRecipeBuilder addTaggedPartInput(Part part, int amount) {
        return this.addTaggedPartInput(this.context.getPart(part), amount);
    }

    public MIRecipeBuilder addPartInput(MaterialPart part, int amount) {
        if (part == null) {
            this.canceled = true;
        } else {
            this.addItemInput(part.getItemId(), amount);
        }
        return this;
    }

    public MIRecipeBuilder addTaggedPartInput(MaterialPart part, int amount) {
        if (part == null) {
            this.canceled = true;
        } else {
            this.addItemInput(part.getTaggedItemId(), amount);
        }
        return this;
    }

    public MIRecipeBuilder addPartOutput(Part part, int amount) {
        return this.addPartOutput(this.context.getPart(part), amount);
    }

    public MIRecipeBuilder addPartOutput(MaterialPart part, int amount) {
        if (part != null) {
            return (MIRecipeBuilder)this.addItemOutput(part.getItemId(), amount);
        }
        this.canceled = true;
        return this;
    }

    public MIRecipeBuilder addPartOutput(Part part, int amount, double probability) {
        return this.addPartOutput(this.context.getPart(part), amount, probability);
    }

    public MIRecipeBuilder addPartOutput(MaterialPart part, int amount, double probability) {
        if (part != null) {
            return (MIRecipeBuilder)this.addItemOutput(part.getItemId(), amount, probability);
        }
        this.canceled = true;
        return this;
    }

    @Override
    public boolean isCanceled() {
        return this.canceled;
    }

    @Override
    public String getRecipeId() {
        return this.recipeId;
    }

    @Override
    public void cancel() {
        this.canceled = true;
    }

    @Override
    public void save(Consumer<class_2444> consumer) {
        if (!this.canceled) {
            String fullId = "materials/" + this.context.getMaterialName() + "/" + this.recipeId;
            this.offerTo(consumer, fullId);
        }
    }
}

