/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.nuclear;

import aztech.modern_industrialization.nuclear.NeutronInteraction;
import aztech.modern_industrialization.nuclear.NeutronType;
import aztech.modern_industrialization.nuclear.NuclearConstant;
import com.google.common.base.Preconditions;

public interface INeutronBehaviour {
    public static final INeutronBehaviour NO_INTERACTION = new INeutronBehaviour(){

        @Override
        public double neutronSlowingProbability() {
            return 0.5;
        }

        @Override
        public double interactionTotalProbability(NeutronType type) {
            return 0.0;
        }

        @Override
        public double interactionRelativeProbability(NeutronType type, NeutronInteraction interaction) {
            return 0.5;
        }
    };

    public double neutronSlowingProbability();

    public double interactionTotalProbability(NeutronType var1);

    public double interactionRelativeProbability(NeutronType var1, NeutronInteraction var2);

    public static INeutronBehaviour of(final NuclearConstant.ScatteringType scatteringType, final double thermalNeutronAbsorptionBarn, final double fastNeutronAbsorptionBarn, final double thermalNeutronScatteringBarn, final double fastNeutronScatteringBarn, final double size) {
        return new INeutronBehaviour(){
            final double thermalProbability;
            final double fastProbability;
            {
                this.thermalProbability = INeutronBehaviour.probaFromCrossSection((thermalNeutronAbsorptionBarn + thermalNeutronScatteringBarn) * Math.sqrt(size));
                this.fastProbability = INeutronBehaviour.probaFromCrossSection((fastNeutronAbsorptionBarn + fastNeutronScatteringBarn) * Math.sqrt(size));
            }

            @Override
            public double neutronSlowingProbability() {
                return scatteringType.slowFraction;
            }

            @Override
            public double interactionTotalProbability(NeutronType type) {
                Preconditions.checkArgument((type != NeutronType.BOTH ? 1 : 0) != 0);
                if (type == NeutronType.FAST) {
                    return this.fastProbability;
                }
                if (type == NeutronType.THERMAL) {
                    return this.thermalProbability;
                }
                return 0.0;
            }

            @Override
            public double interactionRelativeProbability(NeutronType type, NeutronInteraction interaction) {
                Preconditions.checkArgument((type != NeutronType.BOTH ? 1 : 0) != 0);
                if (type == NeutronType.THERMAL) {
                    if (interaction == NeutronInteraction.SCATTERING) {
                        return thermalNeutronScatteringBarn / (thermalNeutronAbsorptionBarn + thermalNeutronScatteringBarn);
                    }
                    if (interaction == NeutronInteraction.ABSORPTION) {
                        return thermalNeutronAbsorptionBarn / (thermalNeutronAbsorptionBarn + thermalNeutronScatteringBarn);
                    }
                } else if (type == NeutronType.FAST) {
                    if (interaction == NeutronInteraction.SCATTERING) {
                        return fastNeutronScatteringBarn / (fastNeutronAbsorptionBarn + fastNeutronScatteringBarn);
                    }
                    if (interaction == NeutronInteraction.ABSORPTION) {
                        return fastNeutronAbsorptionBarn / (fastNeutronAbsorptionBarn + fastNeutronScatteringBarn);
                    }
                }
                return 0.0;
            }
        };
    }

    public static double crossSectionFromProba(double proba) {
        return -Math.log(1.0 - proba);
    }

    public static double probaFromCrossSection(double crossSection) {
        return 1.0 - Math.exp(-crossSection);
    }

    public static INeutronBehaviour of(NuclearConstant.ScatteringType scatteringType, NuclearConstant.IsotopeParams params, double size) {
        return INeutronBehaviour.of(scatteringType, params.thermalAbsorption, params.fastAbsorption, params.thermalScattering, params.fastScattering, size);
    }

    public static double reduceCrossProba(double proba, double crossSectionFactor) {
        return INeutronBehaviour.probaFromCrossSection(INeutronBehaviour.crossSectionFromProba(proba) * crossSectionFactor);
    }
}

