/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.recipe.json;

import aztech.modern_industrialization.definition.FluidLike;
import aztech.modern_industrialization.machines.recipe.MachineRecipeType;
import aztech.modern_industrialization.recipe.json.RecipeJson;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3611;

public class MIRecipeJson<T extends MIRecipeJson<?>>
extends RecipeJson {
    protected final transient MachineRecipeType machineRecipeType;
    protected final String type;
    protected final int eu;
    protected final int duration;
    @SerializedName(value="fluid_inputs")
    private List<MIFluidInput> fluidInputs;
    @SerializedName(value="fluid_outputs")
    private List<MIFluidOutput> fluidOutputs;
    @SerializedName(value="item_inputs")
    private List<MIItemInput> itemInputs;
    @SerializedName(value="item_outputs")
    private List<MIItemOutput> itemOutputs;

    protected MIRecipeJson(MachineRecipeType machineRecipeType, int eu, int duration) {
        this.type = class_2378.field_17598.method_10221((Object)machineRecipeType).toString();
        this.eu = eu;
        this.duration = duration;
        this.machineRecipeType = machineRecipeType;
    }

    protected MIRecipeJson(MIRecipeJson<?> otherWithSameData) {
        this.type = otherWithSameData.type;
        this.eu = otherWithSameData.eu;
        this.duration = otherWithSameData.duration;
        this.machineRecipeType = otherWithSameData.machineRecipeType;
        this.fluidInputs = otherWithSameData.fluidInputs;
        this.fluidOutputs = otherWithSameData.fluidOutputs;
        this.itemInputs = otherWithSameData.itemInputs;
        this.itemOutputs = otherWithSameData.itemOutputs;
    }

    public static MIRecipeJson<MIRecipeJson<?>> create(MachineRecipeType machineRecipeType, int eu, int duration) {
        return new MIRecipeJson(machineRecipeType, eu, duration);
    }

    public T addItemInput(String maybeTag, int amount) {
        return this.addItemInput(maybeTag, amount, 1.0);
    }

    public T addItemInput(class_1935 item, int amount, double probability) {
        return this.addItemInput(class_2378.field_11142.method_10221((Object)item.method_8389()).toString(), amount, probability);
    }

    public T addItemInput(class_1935 item, int amount) {
        return this.addItemInput((class_1935)item.method_8389(), amount, 1.0);
    }

    public T addItemInput(String maybeTag, int amount, double probability) {
        MIItemInput input = probability == 1.0 ? new MIItemInput() : new MIItemInputProbability(probability);
        input.amount = amount;
        if (maybeTag.startsWith("#")) {
            input.tag = maybeTag.substring(1);
        } else {
            input.item = maybeTag;
        }
        if (this.itemInputs == null) {
            this.itemInputs = new ArrayList<MIItemInput>();
        }
        this.itemInputs.add(input);
        return (T)this;
    }

    public T addItemOutput(String itemId, int amount) {
        return this.addItemOutput(itemId, amount, 1.0);
    }

    public T addItemOutput(String itemId, int amount, double probability) {
        MIItemOutput output = new MIItemOutputProbability(probability);
        if (probability == 1.0) {
            output = new MIItemOutput();
        }
        output.item = itemId;
        output.amount = amount;
        if (this.itemOutputs == null) {
            this.itemOutputs = new ArrayList<MIItemOutput>();
        }
        this.itemOutputs.add(output);
        return (T)this;
    }

    public T addItemOutput(class_1935 item, int amount, double probability) {
        return this.addItemOutput(class_2378.field_11142.method_10221((Object)item.method_8389()).toString(), amount, probability);
    }

    public T addItemOutput(class_1935 item, int amount) {
        return this.addItemOutput(class_2378.field_11142.method_10221((Object)item.method_8389()).toString(), amount);
    }

    public T addItemOutput(class_1792 item, int amount) {
        return this.addItemOutput((class_1935)item, amount, 1.0);
    }

    public T addFluidInput(String fluid, int amount) {
        return this.addFluidInput(fluid, amount, 1.0);
    }

    public T addFluidInput(String fluid, int amount, double probability) {
        MIFluidInput input = new MIFluidInputProbability(probability);
        if (probability == 1.0) {
            input = new MIFluidInput();
        }
        input.fluid = fluid;
        input.amount = amount;
        if (this.fluidInputs == null) {
            this.fluidInputs = new ArrayList<MIFluidInput>();
        }
        this.fluidInputs.add(input);
        return (T)this;
    }

    public T addFluidInput(class_3611 fluid, int amount, double probability) {
        class_2960 id = class_2378.field_11154.method_10221((Object)fluid);
        if (id.equals((Object)class_2378.field_11154.method_10137())) {
            throw new RuntimeException("Could not find id for fluid " + fluid);
        }
        return this.addFluidInput(id.toString(), amount, probability);
    }

    public T addFluidInput(FluidLike fluid, int amount, double probability) {
        return this.addFluidInput(fluid.asFluid(), amount, probability);
    }

    public T addFluidInput(FluidLike fluid, int amount) {
        return this.addFluidInput(fluid.asFluid(), amount);
    }

    public T addFluidInput(class_3611 fluid, int amount) {
        return this.addFluidInput(fluid, amount, 1.0);
    }

    public T addFluidOutput(String fluid, int amount) {
        return this.addFluidOutput(fluid, amount, 1.0);
    }

    public T addFluidOutput(FluidLike fluid, int amount) {
        return this.addFluidOutput(fluid.asFluid(), amount);
    }

    public T addFluidOutput(String fluid, int amount, double probability) {
        MIFluidOutput output = new MIFluidOutputProbability(probability);
        if (probability == 1.0) {
            output = new MIFluidOutput();
        }
        output.fluid = fluid;
        output.amount = amount;
        if (this.fluidOutputs == null) {
            this.fluidOutputs = new ArrayList<MIFluidOutput>();
        }
        this.fluidOutputs.add(output);
        return (T)this;
    }

    public T addFluidOutput(class_3611 fluid, int amount) {
        return this.addFluidOutput(fluid, amount, 1.0);
    }

    public T addFluidOutput(class_3611 fluid, int amount, double probability) {
        return this.addFluidOutput(class_2378.field_11154.method_10221((Object)fluid).toString(), amount, probability);
    }

    private static class MIItemInput {
        String item;
        String tag;
        int amount;

        private MIItemInput() {
        }
    }

    private static class MIItemInputProbability
    extends MIItemInput {
        double probability;

        MIItemInputProbability(double probability) {
            this.probability = probability;
        }
    }

    private static class MIItemOutputProbability
    extends MIItemOutput {
        double probability;

        MIItemOutputProbability(double probability) {
            this.probability = probability;
        }
    }

    private static class MIItemOutput {
        String item;
        int amount;

        private MIItemOutput() {
        }
    }

    private static class MIFluidInputProbability
    extends MIFluidInput {
        double probability;

        MIFluidInputProbability(double probability) {
            this.probability = probability;
        }
    }

    private static class MIFluidInput {
        String fluid;
        int amount;

        private MIFluidInput() {
        }
    }

    private static class MIFluidOutputProbability
    extends MIFluidOutput {
        double probability;

        MIFluidOutputProbability(double probability) {
            this.probability = probability;
        }
    }

    private static class MIFluidOutput {
        String fluid;
        int amount;

        private MIFluidOutput() {
        }
    }
}

