/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.recipe.json;

import aztech.modern_industrialization.machines.recipe.MachineRecipeType;
import aztech.modern_industrialization.recipe.json.MIRecipeJson;
import aztech.modern_industrialization.recipe.json.RecipeJson;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ShapelessRecipeJson
extends RecipeJson {
    private final String type;
    private final List<Ingredient> ingredients = new ArrayList<Ingredient>();
    private final Result result = new Result();

    public ShapelessRecipeJson(String result, int count) {
        this.type = "minecraft:crafting_shapeless";
        this.result.item = result;
        this.result.count = count;
    }

    public void addIngredient(Ingredient ingredient) {
        this.ingredients.add(ingredient);
    }

    public MIRecipeJson exportToMachine(MachineRecipeType machine, int eu, int duration) {
        return this.exportToMachine(machine, eu, duration, 1);
    }

    public MIRecipeJson exportToMachine(MachineRecipeType machine, int eu, int duration, int division) {
        int count;
        if (this.result.count % division != 0) {
            throw new IllegalArgumentException("Output must be divisible by division");
        }
        MIRecipeJson<?> machineJson = MIRecipeJson.create(machine, eu, duration).addItemOutput(this.result.item, this.result.count / division);
        HashMap<String, Integer> tags = new HashMap<String, Integer>();
        HashMap<String, Integer> items = new HashMap<String, Integer>();
        for (Ingredient i : this.ingredients) {
            if (i.item != null) {
                items.put(i.item, items.getOrDefault(i.item, 0) + 1);
                continue;
            }
            if (i.tag == null) continue;
            tags.put(i.tag, tags.getOrDefault(i.tag, 0) + 1);
        }
        for (String tag : tags.keySet()) {
            count = (Integer)tags.get(tag);
            if (count % division != 0) {
                throw new IllegalArgumentException("Input must be divisible by division");
            }
            machineJson.addItemInput("#" + tag, count / division);
        }
        for (String item : items.keySet()) {
            count = (Integer)items.get(item);
            if (count % division != 0) {
                throw new IllegalArgumentException("Input must be divisible by division");
            }
            machineJson.addItemInput(item, count / division);
        }
        return machineJson;
    }

    private static class Result {
        String item;
        int count;

        private Result() {
        }
    }

    public static class Ingredient {
        public String item;
        public String tag;
    }
}

