/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.util;

import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.util.FluidTextHelper;
import aztech.modern_industrialization.util.TextHelper;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.transfer.v1.client.fluid.FluidVariantRendering;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributes;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2585;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5251;

public class FluidHelper {
    public static class_2561 getFluidName(FluidVariant fluid, boolean grayIfEmpty) {
        if (fluid.isBlank()) {
            class_2583 style = grayIfEmpty ? class_2583.field_24360.method_27703(class_5251.method_27717((int)0xA9A9A9)).method_10978(Boolean.valueOf(false)) : class_2583.field_24360;
            return MIText.Empty.text().method_10862(style);
        }
        return FluidVariantAttributes.getName((FluidVariant)fluid);
    }

    public static List<class_2561> getTooltip(FluidVariant fluid, boolean grayIfEmpty) {
        if (fluid.isBlank()) {
            ArrayList<class_2561> list = new ArrayList<class_2561>();
            list.add(FluidHelper.getFluidName(fluid, grayIfEmpty));
            return list;
        }
        return FluidVariantRendering.getTooltip((FluidVariant)fluid, (class_1836)(class_310.method_1551().field_1690.field_1827 ? class_1836.class_1837.field_8935 : class_1836.class_1837.field_8934));
    }

    public static List<class_2561> getTooltipForFluidStorage(FluidVariant fluid, long amount, long capacity, boolean grayIfEmpty) {
        List<class_2561> tooltip = FluidHelper.getTooltip(fluid, grayIfEmpty);
        tooltip.add((class_2561)FluidHelper.getFluidAmount(amount, capacity));
        return tooltip;
    }

    public static List<class_2561> getTooltipForFluidStorage(FluidVariant fluid, long amount, long capacity) {
        return FluidHelper.getTooltipForFluidStorage(fluid, amount, capacity, true);
    }

    @Environment(value=EnvType.CLIENT)
    public static class_5250 getFluidAmount(long amount, long capacity) {
        if (capacity < 8100000L || class_437.method_25442()) {
            String text = FluidTextHelper.getUnicodeMillibuckets(amount, false) + " / " + capacity / 81L;
            return new class_2585(text + " mB");
        }
        TextHelper.MaxedAmount maxedAmount = TextHelper.getMaxedAmount((double)amount / 81000.0, (double)capacity / 81000.0);
        return new class_2585(maxedAmount.digit() + " / " + maxedAmount.maxDigit() + " " + maxedAmount.unit() + "B");
    }

    @Environment(value=EnvType.CLIENT)
    public static class_5250 getFluidAmount(long amount) {
        if (amount < 8100000L || class_437.method_25442()) {
            String text = FluidTextHelper.getUnicodeMillibuckets(amount, false);
            return new class_2585(text + " mB");
        }
        TextHelper.Amount amountUnit = TextHelper.getAmount((double)amount / 81000.0);
        return new class_2585(amountUnit.digit() + " " + amountUnit.unit() + "B");
    }

    public static int getColorMinLuminance(int color) {
        int r = color & 0xFF;
        int g = (color & 0xFF00) >> 8;
        int b = (color & 0xFF0000) >> 16;
        double lum = (0.2126 * (double)r + 0.7152 * (double)g + 0.0722 * (double)b) / 255.0;
        if (lum < 0.3) {
            if (lum == 0.0) {
                return 0x4C4C4C;
            }
            r = Math.min((int)((double)r * 0.3 / lum), 255);
            g = Math.min((int)((double)g * 0.3 / lum), 255);
            b = Math.min((int)((double)b * 0.3 / lum), 255);
            return r + (g << 8) + (b << 16);
        }
        return color;
    }
}

