/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.util;

import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.textures.TextureHelper;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_5250;
import net.minecraft.class_5251;

public class TextHelper {
    public static final class_2583 GRAY_TEXT = class_2583.field_24360.method_27703(class_5251.method_27717((int)0xA9A9A9)).method_10978(Boolean.valueOf(true));
    public static final class_2583 NUMBER_TEXT = class_2583.field_24360.method_27703(class_5251.method_27717((int)16768637)).method_10978(Boolean.valueOf(false));
    public static final class_2583 WATER_TEXT = class_2583.field_24360.method_27703(class_5251.method_27717((int)3302655));
    public static final class_2583 WARNING_TEXT = class_2583.field_24360.method_10977(class_124.field_1061);
    public static final class_2583 MAX_TEMP_TEXT = class_2583.field_24360.method_27703(class_5251.method_27717((int)14240286));
    public static final class_2583 HEAT_CONDUCTION = class_2583.field_24360.method_27703(class_5251.method_27717((int)29626));
    public static final class_2583 NEUTRONS = class_2583.field_24360.method_27703(class_5251.method_27717((int)2728745));
    public static final class_2583 YELLOW_BOLD = class_2583.field_24360.method_10977(class_124.field_1054).method_10982(Boolean.valueOf(true));
    public static final class_2583 YELLOW = class_2583.field_24360.method_10977(class_124.field_1054);
    public static final class_2583 RED = class_2583.field_24360.method_10977(class_124.field_1061);
    public static final class_2583 GREEN = class_2583.field_24360.method_10977(class_124.field_1060);
    public static final String[] units = new String[]{"k", "M", "G", "T", "P", "E"};
    public static final long[] nums = new long[]{1000L, 1000000L, 1000000000L, 1000000000000L, 1000000000000000L, 1000000000000000000L};

    public static int getOverlayTextColor(int rgb) {
        double luminance = TextureHelper.getLuminance(rgb);
        if (luminance < 0.5) {
            return 0xFFFFFF;
        }
        return 0;
    }

    public static String getAmount(double amount, long num) {
        double fract = amount / (double)num;
        if (fract < 10.0) {
            return String.format("%.3f", fract);
        }
        if (fract < 100.0) {
            return String.format("%.2f", fract);
        }
        return String.format("%.1f", fract);
    }

    public static Amount getAmountGeneric(Number number) {
        if (number instanceof Long) {
            Long l = (Long)number;
            return TextHelper.getAmount(l);
        }
        if (number instanceof Integer) {
            Integer i = (Integer)number;
            return TextHelper.getAmount(i.intValue());
        }
        if (number instanceof Double) {
            Double d = (Double)number;
            return TextHelper.getAmount(d);
        }
        if (number instanceof Float) {
            Float f = (Float)number;
            return TextHelper.getAmount(f.floatValue());
        }
        throw new IllegalArgumentException("Number " + number + " is neither long, int, double or float");
    }

    public static Amount getAmount(double amount) {
        if (amount < 10000.0) {
            return new Amount(TextHelper.getAmount(amount, 1L), "");
        }
        int i = 0;
        while (amount / (double)nums[i] >= 1000.0) {
            ++i;
        }
        return new Amount(TextHelper.getAmount(amount, nums[i]), units[i]);
    }

    public static MaxedAmount getMaxedAmount(double amount, double max) {
        if (max < 10000.0) {
            return new MaxedAmount(TextHelper.getAmount(amount, 1L), TextHelper.getAmount(max, 1L), "");
        }
        int i = 0;
        while (max / (double)nums[i] >= 1000.0) {
            ++i;
        }
        return new MaxedAmount(TextHelper.getAmount(amount, nums[i]), TextHelper.getAmount(max, nums[i]), units[i]);
    }

    public static Amount getAmount(long amount) {
        if (amount < 10000L) {
            return new Amount(String.valueOf(amount), "");
        }
        int i = 0;
        while (amount / nums[i] >= 1000L) {
            ++i;
        }
        return new Amount(TextHelper.getAmount(amount, nums[i]), units[i]);
    }

    public static MaxedAmount getMaxedAmount(long amount, long max) {
        if (max < 10000L) {
            return new MaxedAmount(String.valueOf(amount), String.valueOf(max), "");
        }
        int i = 0;
        while (max / nums[i] >= 1000L) {
            ++i;
        }
        return new MaxedAmount(TextHelper.getAmount(amount, nums[i]), TextHelper.getAmount(max, nums[i]), units[i]);
    }

    public static class_5250 getEuTextMaxed(long eu, long max) {
        MaxedAmount amount = TextHelper.getMaxedAmount(eu, max);
        return MIText.EuMaxed.text(amount.digit(), amount.maxDigit(), amount.unit());
    }

    public static class_5250 getEuText(double eu) {
        Amount amount = TextHelper.getAmount(eu);
        return MIText.Eu.text(amount.digit(), amount.unit());
    }

    public static class_5250 getEuTextTick(double eu) {
        Amount amount = TextHelper.getAmount(eu);
        return MIText.EuT.text(amount.digit(), amount.unit());
    }

    public static class_5250 getEuText(long eu) {
        Amount amount = TextHelper.getAmount(eu);
        return MIText.Eu.text(amount.digit(), amount.unit());
    }

    public static class_5250 getEuTextTick(long eu) {
        Amount amount = TextHelper.getAmount(eu);
        return MIText.EuT.text(amount.digit(), amount.unit());
    }

    public static class_2561 getEuTextTick(double eu, boolean style) {
        class_5250 text = TextHelper.getEuTextTick(eu);
        if (style) {
            text.method_10862(NUMBER_TEXT);
        }
        return text;
    }

    public static class_5250 getEuTextMaxed(long eu, long max, boolean style) {
        class_5250 text = TextHelper.getEuTextMaxed(eu, max);
        if (style) {
            text.method_10862(NUMBER_TEXT);
        }
        return text;
    }

    public record Amount(String digit, String unit) {
    }

    public record MaxedAmount(String digit, String maxDigit, String unit) {
    }
}

