/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.compat.rei.category;

import com.simibubi.create.Create;
import com.simibubi.create.compat.rei.category.CreateRecipeCategory;
import com.simibubi.create.compat.rei.category.WidgetUtil;
import com.simibubi.create.compat.rei.category.animations.AnimatedSpout;
import com.simibubi.create.compat.rei.display.CreateDisplay;
import com.simibubi.create.content.contraptions.fluids.actors.FillingRecipe;
import com.simibubi.create.content.contraptions.fluids.actors.GenericItemFilling;
import com.simibubi.create.content.contraptions.fluids.potion.PotionFluidHandler;
import com.simibubi.create.content.contraptions.processing.ProcessingRecipeBuilder;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.item.ItemHelper;
import dev.architectury.fluid.FluidStack;
import io.github.fabricators_of_create.porting_lib.transfer.TransferUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.widgets.Slot;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.entry.EntryRegistry;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1812;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2960;

public class SpoutCategory
extends CreateRecipeCategory<FillingRecipe> {
    public SpoutCategory(CreateRecipeCategory.Info<FillingRecipe> info) {
        super(info);
    }

    public static void consumeRecipes(Consumer<FillingRecipe> consumer) {
        List<EntryStack> fluidStacks = EntryRegistry.getInstance().getEntryStacks().filter(stack -> Objects.equals(stack.getType(), VanillaEntryTypes.FLUID)).map(EntryStack::cast).toList();
        EntryRegistry.getInstance().getEntryStacks().filter(stack -> Objects.equals(stack.getType(), VanillaEntryTypes.ITEM)).map(EntryStack::cast).toList().forEach(entryStack -> {
            class_1799 stack = (class_1799)entryStack.getValue();
            if (stack.method_7909() instanceof class_1812) {
                io.github.fabricators_of_create.porting_lib.util.FluidStack fluidFromPotionItem = PotionFluidHandler.getFluidFromPotionItem(stack);
                class_1856 bottle = class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8469});
                consumer.accept(new ProcessingRecipeBuilder<FillingRecipe>(FillingRecipe::new, Create.asResource("potions")).withItemIngredients(bottle).withFluidIngredients(FluidIngredient.fromFluidStack(fluidFromPotionItem)).withSingleItemOutput(stack).build());
                return;
            }
            for (EntryStack fluidEntry : fluidStacks) {
                io.github.fabricators_of_create.porting_lib.util.FluidStack fluidStack = new io.github.fabricators_of_create.porting_lib.util.FluidStack(((FluidStack)fluidEntry.getValue()).getFluid(), ((FluidStack)fluidEntry.getValue()).getAmount(), ((FluidStack)fluidEntry.getValue()).getTag());
                class_1799 copy = stack.method_7972();
                ContainerItemContext ctx = ContainerItemContext.withInitial((class_1799)copy);
                Storage fhi = (Storage)ctx.find(FluidStorage.ITEM);
                if (fhi == null) continue;
                if (!GenericItemFilling.isFluidHandlerValid(copy, (Storage<FluidVariant>)fhi)) {
                    return;
                }
                io.github.fabricators_of_create.porting_lib.util.FluidStack fluidCopy = fluidStack.copy();
                fluidCopy.setAmount(81000L);
                try (Transaction t = TransferUtil.getTransaction();){
                    fhi.insert((Object)fluidCopy.getType(), fluidCopy.getAmount(), (TransactionContext)t);
                    t.commit();
                }
                class_1799 container = ctx.getItemVariant().toStack(ItemHelper.truncateLong(ctx.getAmount()));
                if (container.method_7962(copy)) {
                    return;
                }
                if (container.method_7960()) {
                    return;
                }
                class_1856 bucket = class_1856.method_8101((class_1799[])new class_1799[]{stack});
                class_2960 itemName = class_2378.field_11142.method_10221((Object)stack.method_7909());
                class_2960 fluidName = class_2378.field_11154.method_10221((Object)fluidCopy.getFluid());
                consumer.accept(new ProcessingRecipeBuilder<FillingRecipe>(FillingRecipe::new, Create.asResource("fill_" + itemName.method_12836() + "_" + itemName.method_12832() + "_with_" + fluidName.method_12836() + "_" + fluidName.method_12832())).withItemIngredients(bucket).withFluidIngredients(FluidIngredient.fromFluidStack(fluidCopy)).withSingleItemOutput(container).build());
            }
        });
    }

    @Override
    public List<Widget> setupDisplay(CreateDisplay<FillingRecipe> display, Rectangle bounds) {
        Point origin = new Point(bounds.getX(), bounds.getY() + 4);
        ArrayList<Widget> widgets = new ArrayList<Widget>();
        widgets.add((Widget)Widgets.createRecipeBase((Rectangle)bounds));
        io.github.fabricators_of_create.porting_lib.util.FluidStack fluidStack = display.getRecipe().getRequiredFluid().getMatchingFluidStacks().get(0);
        widgets.add(WidgetUtil.textured(AllGuiTextures.JEI_SLOT, origin.getX() + 26, origin.getY() + 31));
        Slot fluidSlot = SpoutCategory.basicSlot(27, 31, origin).disableBackground().markInput().entries((Collection)EntryIngredients.of((FluidStack)CreateRecipeCategory.convertToREIFluid(fluidStack)));
        CreateRecipeCategory.setFluidRenderRatio(fluidSlot);
        widgets.add((Widget)fluidSlot);
        SpoutCategory.addFluidTooltip(widgets, List.of(display.getRecipe().getRequiredFluid()), Collections.emptyList());
        widgets.add(WidgetUtil.textured(AllGuiTextures.JEI_SLOT, origin.getX() + 26, origin.getY() + 50));
        widgets.add((Widget)Widgets.createSlot((Point)SpoutCategory.point(origin.getX() + 27, origin.getY() + 51)).disableBackground().markInput().entries((Collection)display.getInputEntries().get(0)));
        widgets.add(WidgetUtil.textured(SpoutCategory.getRenderedSlot(display.getRecipe(), 0), origin.getX() + 131, origin.getY() + 50));
        widgets.add((Widget)Widgets.createSlot((Point)new Point(origin.getX() + 132, origin.getY() + 51)).disableBackground().markOutput().entries((Collection)display.getOutputEntries().get(0)));
        widgets.add(WidgetUtil.textured(AllGuiTextures.JEI_SHADOW, origin.getX() + 62, origin.getY() + 57));
        widgets.add(WidgetUtil.textured(AllGuiTextures.JEI_DOWN_ARROW, origin.getX() + 126, origin.getY() + 29));
        AnimatedSpout spout = new AnimatedSpout();
        spout.setPos(new Point(origin.getX() + (this.getDisplayWidth(display) / 2 - 13), origin.getY() + 22));
        spout.withFluids(display.getRecipe().getRequiredFluid().getMatchingFluidStacks());
        widgets.add(spout);
        return widgets;
    }
}

