/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement;

import com.jozufozu.flywheel.util.transform.TransformStack;
import com.simibubi.create.AllEntityTypes;
import com.simibubi.create.content.contraptions.components.structureMovement.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.Contraption;
import com.simibubi.create.content.contraptions.components.structureMovement.IControlContraption;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementBehaviour;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementContext;
import com.simibubi.create.content.contraptions.components.structureMovement.StructureTransform;
import com.simibubi.create.content.contraptions.components.structureMovement.TranslatingContraption;
import com.simibubi.create.content.contraptions.components.structureMovement.bearing.BearingContraption;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.NBTHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_3499;
import net.minecraft.class_4587;

public class ControlledContraptionEntity
extends AbstractContraptionEntity {
    protected class_2338 controllerPos;
    protected class_2350.class_2351 rotationAxis;
    protected float prevAngle;
    protected float angle;
    protected float angleDelta;

    public ControlledContraptionEntity(class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    public static ControlledContraptionEntity create(class_1937 world, IControlContraption controller, Contraption contraption) {
        ControlledContraptionEntity entity = new ControlledContraptionEntity((class_1299)AllEntityTypes.CONTROLLED_CONTRAPTION.get(), world);
        entity.controllerPos = controller.getBlockPosition();
        entity.setContraption(contraption);
        return entity;
    }

    @Override
    public class_243 getContactPointMotion(class_243 globalContactPoint) {
        if (this.contraption instanceof TranslatingContraption) {
            return this.method_18798();
        }
        return super.getContactPointMotion(globalContactPoint);
    }

    @Override
    protected void setContraption(Contraption contraption) {
        super.setContraption(contraption);
        if (contraption instanceof BearingContraption) {
            this.rotationAxis = ((BearingContraption)contraption).getFacing().method_10166();
        }
    }

    @Override
    protected void readAdditional(class_2487 compound, boolean spawnPacket) {
        super.readAdditional(compound, spawnPacket);
        this.controllerPos = compound.method_10545("Controller") ? class_2512.method_10691((class_2487)compound.method_10562("Controller")) : class_2512.method_10691((class_2487)compound.method_10562("ControllerRelative")).method_10081((class_2382)this.method_24515());
        if (compound.method_10545("Axis")) {
            this.rotationAxis = NBTHelper.readEnum(compound, "Axis", class_2350.class_2351.class);
        }
        this.angle = compound.method_10583("Angle");
    }

    @Override
    protected void writeAdditional(class_2487 compound, boolean spawnPacket) {
        super.writeAdditional(compound, spawnPacket);
        compound.method_10566("ControllerRelative", (class_2520)class_2512.method_10692((class_2338)this.controllerPos.method_10059((class_2382)this.method_24515())));
        if (this.rotationAxis != null) {
            NBTHelper.writeEnum(compound, "Axis", this.rotationAxis);
        }
        compound.method_10548("Angle", this.angle);
    }

    @Override
    public AbstractContraptionEntity.ContraptionRotationState getRotationState() {
        AbstractContraptionEntity.ContraptionRotationState crs = new AbstractContraptionEntity.ContraptionRotationState();
        if (this.rotationAxis == class_2350.class_2351.field_11048) {
            crs.xRotation = this.angle;
        }
        if (this.rotationAxis == class_2350.class_2351.field_11052) {
            crs.yRotation = this.angle;
        }
        if (this.rotationAxis == class_2350.class_2351.field_11051) {
            crs.zRotation = this.angle;
        }
        return crs;
    }

    @Override
    public class_243 applyRotation(class_243 localPos, float partialTicks) {
        localPos = VecHelper.rotate(localPos, this.getAngle(partialTicks), this.rotationAxis);
        return localPos;
    }

    @Override
    public class_243 reverseRotation(class_243 localPos, float partialTicks) {
        localPos = VecHelper.rotate(localPos, -this.getAngle(partialTicks), this.rotationAxis);
        return localPos;
    }

    public void setAngle(float angle) {
        this.angle = angle;
    }

    public float getAngle(float partialTicks) {
        return partialTicks == 1.0f ? this.angle : AngleHelper.angleLerp(partialTicks, this.prevAngle, this.angle);
    }

    public void setRotationAxis(class_2350.class_2351 rotationAxis) {
        this.rotationAxis = rotationAxis;
    }

    public class_2350.class_2351 getRotationAxis() {
        return this.rotationAxis;
    }

    public void method_5859(double p_70634_1_, double p_70634_3_, double p_70634_5_) {
    }

    @Environment(value=EnvType.CLIENT)
    public void method_5759(double x, double y, double z, float yw, float pt, int inc, boolean t) {
    }

    @Override
    protected void tickContraption() {
        this.angleDelta = this.angle - this.prevAngle;
        this.prevAngle = this.angle;
        this.tickActors();
        if (this.controllerPos == null) {
            return;
        }
        if (!this.field_6002.method_8477(this.controllerPos)) {
            return;
        }
        IControlContraption controller = this.getController();
        if (controller == null) {
            this.method_31472();
            return;
        }
        if (!controller.isAttachedTo(this)) {
            controller.attach(this);
            if (this.field_6002.field_9236) {
                this.method_5814(this.method_23317(), this.method_23318(), this.method_23321());
            }
        }
    }

    @Override
    protected boolean shouldActorTrigger(MovementContext context, class_3499.class_3501 blockInfo, MovementBehaviour actor, class_243 actorPosition, class_2338 gridPosition) {
        if (super.shouldActorTrigger(context, blockInfo, actor, actorPosition, gridPosition)) {
            return true;
        }
        if (!(this.contraption instanceof BearingContraption)) {
            return false;
        }
        BearingContraption bc = (BearingContraption)this.contraption;
        class_2350 facing = bc.getFacing();
        class_243 activeAreaOffset = actor.getActiveAreaOffset(context);
        if (!activeAreaOffset.method_18806(VecHelper.axisAlingedPlaneOf(class_243.method_24954((class_2382)facing.method_10163()))).equals((Object)class_243.field_1353)) {
            return false;
        }
        if (!VecHelper.onSameAxis(blockInfo.field_15597, class_2338.field_10980, facing.method_10166())) {
            return false;
        }
        context.relativeMotion = context.motion = class_243.method_24954((class_2382)facing.method_10163()).method_1021((double)this.angleDelta / 360.0);
        int timer = context.data.method_10550("StationaryTimer");
        if (timer > 0) {
            context.data.method_10569("StationaryTimer", timer - 1);
            return false;
        }
        context.data.method_10569("StationaryTimer", 20);
        return true;
    }

    protected IControlContraption getController() {
        if (this.controllerPos == null) {
            return null;
        }
        if (!this.field_6002.method_8477(this.controllerPos)) {
            return null;
        }
        class_2586 te = this.field_6002.method_8321(this.controllerPos);
        if (!(te instanceof IControlContraption)) {
            return null;
        }
        return (IControlContraption)te;
    }

    @Override
    protected StructureTransform makeStructureTransform() {
        class_2338 offset = new class_2338(this.getAnchorVec().method_1031(0.5, 0.5, 0.5));
        float xRot = this.rotationAxis == class_2350.class_2351.field_11048 ? this.angle : 0.0f;
        float yRot = this.rotationAxis == class_2350.class_2351.field_11052 ? this.angle : 0.0f;
        float zRot = this.rotationAxis == class_2350.class_2351.field_11051 ? this.angle : 0.0f;
        return new StructureTransform(offset, xRot, yRot, zRot);
    }

    @Override
    protected void onContraptionStalled() {
        IControlContraption controller = this.getController();
        if (controller != null) {
            controller.onStall();
        }
        super.onContraptionStalled();
    }

    @Override
    protected float getStalledAngle() {
        return this.angle;
    }

    @Override
    protected void handleStallInformation(float x, float y, float z, float angle) {
        this.method_23327(x, y, z);
        this.angle = this.prevAngle = angle;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void doLocalTransforms(float partialTicks, class_4587[] matrixStacks) {
        float angle = this.getAngle(partialTicks);
        class_2350.class_2351 axis = this.getRotationAxis();
        for (class_4587 stack : matrixStacks) {
            ((TransformStack)((TransformStack)((TransformStack)TransformStack.cast((class_4587)stack).nudge(this.method_5628())).centre()).rotate((double)angle, axis)).unCentre();
        }
    }
}

