/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement.gantry;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllEntityTypes;
import com.simibubi.create.content.contraptions.components.structureMovement.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.Contraption;
import com.simibubi.create.content.contraptions.components.structureMovement.ContraptionCollider;
import com.simibubi.create.content.contraptions.components.structureMovement.StructureTransform;
import com.simibubi.create.content.contraptions.components.structureMovement.gantry.GantryContraption;
import com.simibubi.create.content.contraptions.components.structureMovement.gantry.GantryContraptionUpdatePacket;
import com.simibubi.create.content.contraptions.relays.advanced.GantryShaftBlock;
import com.simibubi.create.content.contraptions.relays.advanced.GantryShaftTileEntity;
import com.simibubi.create.foundation.networking.AllPackets;
import com.simibubi.create.foundation.utility.NBTHelper;
import com.simibubi.create.foundation.utility.ServerSpeedProvider;
import me.pepperbell.simplenetworking.S2CPacket;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;

public class GantryContraptionEntity
extends AbstractContraptionEntity {
    class_2350 movementAxis;
    double clientOffsetDiff;
    double axisMotion;

    public GantryContraptionEntity(class_1299<?> entityTypeIn, class_1937 worldIn) {
        super(entityTypeIn, worldIn);
    }

    public static GantryContraptionEntity create(class_1937 world, Contraption contraption, class_2350 movementAxis) {
        GantryContraptionEntity entity = new GantryContraptionEntity((class_1299)AllEntityTypes.GANTRY_CONTRAPTION.get(), world);
        entity.setContraption(contraption);
        entity.movementAxis = movementAxis;
        return entity;
    }

    @Override
    protected void tickContraption() {
        if (!(this.contraption instanceof GantryContraption)) {
            return;
        }
        double prevAxisMotion = this.axisMotion;
        if (this.field_6002.field_9236) {
            this.clientOffsetDiff *= 0.75;
            this.updateClientMotion();
        }
        this.checkPinionShaft();
        this.tickActors();
        class_243 movementVec = this.method_18798();
        if (ContraptionCollider.collideBlocks(this)) {
            if (!this.field_6002.field_9236) {
                this.disassemble();
            }
            return;
        }
        if (!this.isStalled() && this.field_6012 > 2) {
            this.move(movementVec.field_1352, movementVec.field_1351, movementVec.field_1350);
        }
        if (Math.signum(prevAxisMotion) != Math.signum(this.axisMotion) && prevAxisMotion != 0.0) {
            this.contraption.stop(this.field_6002);
        }
        if (!(this.field_6002.field_9236 || prevAxisMotion == this.axisMotion && this.field_6012 % 3 != 0)) {
            this.sendPacket();
        }
    }

    protected void checkPinionShaft() {
        class_2350 facing = ((GantryContraption)this.contraption).getFacing();
        class_243 currentPosition = this.getAnchorVec().method_1031(0.5, 0.5, 0.5);
        class_2338 gantryShaftPos = new class_2338(currentPosition).method_10093(facing.method_10153());
        class_2586 te = this.field_6002.method_8321(gantryShaftPos);
        if (!(te instanceof GantryShaftTileEntity) || !AllBlocks.GANTRY_SHAFT.has(te.method_11010())) {
            if (!this.field_6002.field_9236) {
                this.setContraptionMotion(class_243.field_1353);
                this.disassemble();
            }
            return;
        }
        class_2680 blockState = te.method_11010();
        class_2350 direction = (class_2350)blockState.method_11654((class_2769)GantryShaftBlock.FACING);
        GantryShaftTileEntity gantryShaftTileEntity = (GantryShaftTileEntity)te;
        float pinionMovementSpeed = gantryShaftTileEntity.getPinionMovementSpeed();
        class_243 movementVec = class_243.method_24954((class_2382)direction.method_10163()).method_1021((double)pinionMovementSpeed);
        if (((Boolean)blockState.method_11654((class_2769)GantryShaftBlock.POWERED)).booleanValue() || pinionMovementSpeed == 0.0f) {
            this.setContraptionMotion(class_243.field_1353);
            if (!this.field_6002.field_9236) {
                this.disassemble();
            }
            return;
        }
        class_243 nextPosition = currentPosition.method_1019(movementVec);
        double currentCoord = direction.method_10166().method_10172(currentPosition.field_1352, currentPosition.field_1351, currentPosition.field_1350);
        double nextCoord = direction.method_10166().method_10172(nextPosition.field_1352, nextPosition.field_1351, nextPosition.field_1350);
        if ((double)((float)class_3532.method_15357((double)currentCoord) + 0.5f) < nextCoord != pinionMovementSpeed * (float)direction.method_10171().method_10181() < 0.0f && !gantryShaftTileEntity.canAssembleOn()) {
            this.setContraptionMotion(class_243.field_1353);
            if (!this.field_6002.field_9236) {
                this.disassemble();
            }
            return;
        }
        if (this.field_6002.field_9236) {
            return;
        }
        this.axisMotion = pinionMovementSpeed;
        this.setContraptionMotion(movementVec);
    }

    @Override
    protected void writeAdditional(class_2487 compound, boolean spawnPacket) {
        NBTHelper.writeEnum(compound, "GantryAxis", this.movementAxis);
        super.writeAdditional(compound, spawnPacket);
    }

    @Override
    protected void readAdditional(class_2487 compound, boolean spawnData) {
        this.movementAxis = NBTHelper.readEnum(compound, "GantryAxis", class_2350.class);
        super.readAdditional(compound, spawnData);
    }

    @Override
    public class_243 applyRotation(class_243 localPos, float partialTicks) {
        return localPos;
    }

    @Override
    public class_243 reverseRotation(class_243 localPos, float partialTicks) {
        return localPos;
    }

    @Override
    protected StructureTransform makeStructureTransform() {
        return new StructureTransform(new class_2338(this.getAnchorVec().method_1031(0.5, 0.5, 0.5)), 0.0f, 0.0f, 0.0f);
    }

    @Override
    protected float getStalledAngle() {
        return 0.0f;
    }

    public void method_5859(double p_70634_1_, double p_70634_3_, double p_70634_5_) {
    }

    @Environment(value=EnvType.CLIENT)
    public void method_5759(double x, double y, double z, float yw, float pt, int inc, boolean t) {
    }

    @Override
    protected void handleStallInformation(float x, float y, float z, float angle) {
        this.method_23327(x, y, z);
        this.clientOffsetDiff = 0.0;
    }

    @Override
    public AbstractContraptionEntity.ContraptionRotationState getRotationState() {
        return AbstractContraptionEntity.ContraptionRotationState.NONE;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void doLocalTransforms(float partialTicks, class_4587[] matrixStacks) {
    }

    public void updateClientMotion() {
        float modifier = this.movementAxis.method_10171().method_10181();
        this.setContraptionMotion(class_243.method_24954((class_2382)this.movementAxis.method_10163()).method_1021((this.axisMotion + this.clientOffsetDiff * (double)modifier / 2.0) * (double)ServerSpeedProvider.get()));
    }

    public double getAxisCoord() {
        class_243 anchorVec = this.getAnchorVec();
        return this.movementAxis.method_10166().method_10172(anchorVec.field_1352, anchorVec.field_1351, anchorVec.field_1350);
    }

    public void sendPacket() {
        AllPackets.channel.sendToClientsTracking((S2CPacket)new GantryContraptionUpdatePacket(this.method_5628(), this.getAxisCoord(), this.axisMotion), (class_1297)this);
    }

    @Environment(value=EnvType.CLIENT)
    public static void handlePacket(GantryContraptionUpdatePacket packet) {
        class_1297 entity = class_310.method_1551().field_1687.method_8469(packet.entityID);
        if (!(entity instanceof GantryContraptionEntity)) {
            return;
        }
        GantryContraptionEntity ce = (GantryContraptionEntity)entity;
        ce.axisMotion = packet.motion;
        ce.clientOffsetDiff = packet.coord - ce.getAxisCoord();
    }
}

